(function() {
  var LaunchModeView;

  module.exports = LaunchModeView = (function() {
    function LaunchModeView(arg) {
      var devMode, ref, safeMode;
      ref = arg != null ? arg : {}, safeMode = ref.safeMode, devMode = ref.devMode;
      this.element = document.createElement('status-bar-launch-mode');
      this.element.classList.add('inline-block', 'icon', 'icon-color-mode');
      if (devMode) {
        this.element.classList.add('text-error');
        this.tooltipDisposable = atom.tooltips.add(this.element, {
          title: 'This window is in dev mode'
        });
      } else if (safeMode) {
        this.element.classList.add('text-success');
        this.tooltipDisposable = atom.tooltips.add(this.element, {
          title: 'This window is in safe mode'
        });
      }
    }

    LaunchModeView.prototype.detachedCallback = function() {
      var ref;
      return (ref = this.tooltipDisposable) != null ? ref.dispose() : void 0;
    };

    return LaunchModeView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNi4wL291dC9hcHAvbm9kZV9tb2R1bGVzL3N0YXR1cy1iYXIvbGliL2xhdW5jaC1tb2RlLXZpZXcuY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQSxNQUFNLENBQUMsT0FBUCxHQUNNO0lBQ1Msd0JBQUMsR0FBRDtBQUNYLFVBQUE7MEJBRFksTUFBb0IsSUFBbkIseUJBQVU7TUFDdkIsSUFBQyxDQUFBLE9BQUQsR0FBVyxRQUFRLENBQUMsYUFBVCxDQUF1Qix3QkFBdkI7TUFDWCxJQUFDLENBQUEsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFuQixDQUF1QixjQUF2QixFQUF1QyxNQUF2QyxFQUErQyxpQkFBL0M7TUFDQSxJQUFHLE9BQUg7UUFDRSxJQUFDLENBQUEsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFuQixDQUF1QixZQUF2QjtRQUNBLElBQUMsQ0FBQSxpQkFBRCxHQUFxQixJQUFJLENBQUMsUUFBUSxDQUFDLEdBQWQsQ0FBa0IsSUFBQyxDQUFBLE9BQW5CLEVBQTRCO1VBQUEsS0FBQSxFQUFPLDRCQUFQO1NBQTVCLEVBRnZCO09BQUEsTUFHSyxJQUFHLFFBQUg7UUFDSCxJQUFDLENBQUEsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFuQixDQUF1QixjQUF2QjtRQUNBLElBQUMsQ0FBQSxpQkFBRCxHQUFxQixJQUFJLENBQUMsUUFBUSxDQUFDLEdBQWQsQ0FBa0IsSUFBQyxDQUFBLE9BQW5CLEVBQTRCO1VBQUEsS0FBQSxFQUFPLDZCQUFQO1NBQTVCLEVBRmxCOztJQU5NOzs2QkFVYixnQkFBQSxHQUFrQixTQUFBO0FBQ2hCLFVBQUE7eURBQWtCLENBQUUsT0FBcEIsQ0FBQTtJQURnQjs7Ozs7QUFacEIiLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9XG5jbGFzcyBMYXVuY2hNb2RlVmlld1xuICBjb25zdHJ1Y3RvcjogKHtzYWZlTW9kZSwgZGV2TW9kZX09e30pIC0+XG4gICAgQGVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzdGF0dXMtYmFyLWxhdW5jaC1tb2RlJylcbiAgICBAZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdpbmxpbmUtYmxvY2snLCAnaWNvbicsICdpY29uLWNvbG9yLW1vZGUnKVxuICAgIGlmIGRldk1vZGVcbiAgICAgIEBlbGVtZW50LmNsYXNzTGlzdC5hZGQoJ3RleHQtZXJyb3InKVxuICAgICAgQHRvb2x0aXBEaXNwb3NhYmxlID0gYXRvbS50b29sdGlwcy5hZGQoQGVsZW1lbnQsIHRpdGxlOiAnVGhpcyB3aW5kb3cgaXMgaW4gZGV2IG1vZGUnKVxuICAgIGVsc2UgaWYgc2FmZU1vZGVcbiAgICAgIEBlbGVtZW50LmNsYXNzTGlzdC5hZGQoJ3RleHQtc3VjY2VzcycpXG4gICAgICBAdG9vbHRpcERpc3Bvc2FibGUgPSBhdG9tLnRvb2x0aXBzLmFkZChAZWxlbWVudCwgdGl0bGU6ICdUaGlzIHdpbmRvdyBpcyBpbiBzYWZlIG1vZGUnKVxuXG4gIGRldGFjaGVkQ2FsbGJhY2s6IC0+XG4gICAgQHRvb2x0aXBEaXNwb3NhYmxlPy5kaXNwb3NlKClcbiJdfQ==
