Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var UpdatesPanel = (function () {
  function UpdatesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, UpdatesPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.updatingPackages = [];
    this.packageCards = [];

    _etch2['default'].initialize(this);

    this.refs.updateAllButton.style.display = 'none';
    this.checkForUpdates();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(this.packageManager.on('package-updating theme-updating', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.checkButton.disabled = true;
      _this.updatingPackages.push(pack);
    }));

    this.disposables.add(this.packageManager.on('package-updated theme-updated package-update-failed theme-update-failed', function (_ref2) {
      var pack = _ref2.pack;
      var error = _ref2.error;

      if (error != null) {
        _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
      }

      for (var i = 0; i < _this.updatingPackages.length; i++) {
        var update = _this.updatingPackages[i];
        if (update.name === pack.name) {
          _this.updatingPackages.splice(i, 1);
        }
      }

      if (!_this.updatingPackages.length) {
        _this.refs.checkButton.disabled = false;
      }
    }));
  }

  _createClass(UpdatesPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.clearPackageCards();
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item' },
        _etch2['default'].dom(
          'section',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container updates-container' },
            _etch2['default'].dom(
              'div',
              { className: 'updates-heading-container' },
              _etch2['default'].dom(
                'h1',
                { className: 'section-heading icon icon-cloud-download' },
                'Available Updates'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-heading updates-btn-group' },
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'checkButton',
                    className: 'update-all-button btn',
                    onclick: function () {
                      _this2.checkForUpdates(true);
                    } },
                  'Check for Updates'
                ),
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'updateAllButton',
                    className: 'update-all-button btn btn-primary',
                    onclick: function () {
                      _this2.updateAll();
                    } },
                  'Update All'
                )
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'versionPinnedPackagesMessage', className: 'alert alert-warning icon icon-alert' },
              'The following packages are pinned to their current version and are not being checked for updates: ',
              _etch2['default'].dom(
                'strong',
                null,
                this.packageManager.getVersionPinnedPackages().join(', ')
              )
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'div',
              { ref: 'checkingMessage', className: 'alert alert-info icon icon-hourglass' },
              'Checking for updates…'
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'noUpdatesMessage', className: 'alert alert-info icon icon-heart' },
              'All of your installed packages are up to date!'
            ),
            _etch2['default'].dom('div', { ref: 'updatesContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      var _this3 = this;

      if (opts && opts.back) {
        this.refs.breadcrumb.textContent = opts.back;
        this.refs.breadcrumb.onclick = function () {
          _this3.settingsView.showPanel(opts.back);
        };
      }

      if (opts && opts.updates) {
        this.availableUpdates = opts.updates;
        this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.clearPackageCards();
        this.checkForUpdates();
      }

      if (this.packageManager.getVersionPinnedPackages().length === 0) {
        this.refs.versionPinnedPackagesMessage.style.display = 'none';
      }
    }

    // Check for updates and display them
  }, {
    key: 'checkForUpdates',
    value: _asyncToGenerator(function* (clearCache) {
      this.refs.noUpdatesMessage.style.display = 'none';
      this.refs.updateAllButton.disabled = true;
      this.refs.checkButton.disabled = true;
      this.refs.checkingMessage.style.display = '';

      try {
        this.availableUpdates = yield this.packageManager.getOutdated(clearCache);
        this.refs.checkButton.disabled = false;
        this.addUpdateViews();
      } catch (error) {
        this.refs.checkButton.disabled = false;
        this.refs.checkingMessage.style.display = 'none';
        this.refs.updateErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addUpdateViews',
    value: function addUpdateViews() {
      if (this.availableUpdates.length > 0) {
        this.refs.updateAllButton.style.display = '';
        this.refs.updateAllButton.disabled = false;
      }
      this.refs.checkingMessage.style.display = 'none';
      this.clearPackageCards();
      if (this.availableUpdates.length === 0) {
        this.refs.noUpdatesMessage.style.display = '';
      }

      for (var pack of this.availableUpdates) {
        var packageCard = new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Updates' });
        this.refs.updatesContainer.appendChild(packageCard.element);
        this.packageCards.push(packageCard);
      }
    }
  }, {
    key: 'updateAll',
    value: _asyncToGenerator(function* () {
      this.refs.checkButton.disabled = true;
      this.refs.updateAllButton.disabled = true;

      var updatingPackages = this.updatingPackages;
      var successfulUpdatesCount = 0;
      var failedUpdatesCount = 0;

      var concurrency = atom.config.get('settings-view.packageUpdateConcurrency') > 0 ? atom.config.get('settings-view.packageUpdateConcurrency') : Number.POSITIVE_INFINITY;

      var queue = _async2['default'].queue(function (packageCard, callback) {
        var onUpdateCompleted = function onUpdateCompleted(err) {
          err == null ? successfulUpdatesCount++ : failedUpdatesCount++;
        };

        if (updatingPackages.includes(packageCard.pack)) {
          callback();
        } else {
          packageCard.update().then(onUpdateCompleted, onUpdateCompleted).then(callback);
        }
      }, concurrency);

      var queueDrainedPromise = new Promise(function (resolve) {
        queue.drain = resolve;
      });

      for (var packageCard of this.packageCards) {
        queue.push(packageCard);
      }

      yield queueDrainedPromise;

      if (successfulUpdatesCount > 0) {
        var message = 'Restart Atom to complete the update of ' + successfulUpdatesCount + ' ' + pluralize('package', successfulUpdatesCount) + ':';
        var detail = '';
        this.packageCards.forEach(function (card) {
          var oldVersion = '';
          var newVersion = '';

          if (card.pack.apmInstallSource && card.pack.apmInstallSource.type === 'git') {
            oldVersion = card.pack.apmInstallSource.sha.substr(0, 8);
            newVersion = '' + card.pack.latestSha.substr(0, 8);
          } else if (card.pack.version && card.pack.latestVersion) {
            oldVersion = card.pack.version;
            newVersion = card.pack.latestVersion;
          }

          if (oldVersion && newVersion) {
            detail += card.pack.name + '@' + oldVersion + ' -> ' + newVersion + '\n';
          }
        });
        detail = detail.trim();

        var buttons = [{
          text: 'Restart',
          onDidClick: function onDidClick() {
            return atom.restartApplication();
          }
        }];
        atom.notifications.addSuccess(message, { dismissable: true, buttons: buttons, detail: detail });
      }

      if (failedUpdatesCount === 0) {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.style.display = 'none';
      } else {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.disabled = false;
      }
    })
  }, {
    key: 'clearPackageCards',
    value: function clearPackageCards() {
      while (this.packageCards.length) {
        this.packageCards.pop().destroy();
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UpdatesPanel;
})();

exports['default'] = UpdatesPanel;

function pluralize(word, count) {
  return count > 1 ? word + 's' : word;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi91cGRhdGVzLXBhbmVsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7OztvQkFHa0MsTUFBTTs7cUJBQ3RCLE9BQU87Ozs7b0JBQ1IsTUFBTTs7Ozt5QkFFRCxjQUFjOzs7OzJCQUNaLGdCQUFnQjs7OztJQUVuQixZQUFZO0FBQ25CLFdBRE8sWUFBWSxDQUNsQixZQUFZLEVBQUUsY0FBYyxFQUFFOzs7MEJBRHhCLFlBQVk7O0FBRTdCLFFBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFBO0FBQ2hDLFFBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFBO0FBQ3BDLFFBQUksQ0FBQyxXQUFXLEdBQUcsK0JBQXlCLENBQUE7QUFDNUMsUUFBSSxDQUFDLGdCQUFnQixHQUFHLEVBQUUsQ0FBQTtBQUMxQixRQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTs7QUFFdEIsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVyQixRQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNoRCxRQUFJLENBQUMsZUFBZSxFQUFFLENBQUE7O0FBRXRCLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDbkQsb0JBQWMsRUFBRSxzQkFBTTtBQUFFLGNBQUssUUFBUSxFQUFFLENBQUE7T0FBRTtBQUN6QyxzQkFBZ0IsRUFBRSx3QkFBTTtBQUFFLGNBQUssVUFBVSxFQUFFLENBQUE7T0FBRTtBQUM3QyxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxNQUFNLEVBQUUsQ0FBQTtPQUFFO0FBQ3ZDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQzNDLHdCQUFrQixFQUFFLHlCQUFNO0FBQUUsY0FBSyxXQUFXLEVBQUUsQ0FBQTtPQUFFO0FBQ2hELDJCQUFxQixFQUFFLDRCQUFNO0FBQUUsY0FBSyxjQUFjLEVBQUUsQ0FBQTtPQUFFO0tBQ3ZELENBQUMsQ0FBQyxDQUFBOztBQUVILFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxFQUFFLFVBQUMsSUFBYSxFQUFLO1VBQWpCLElBQUksR0FBTCxJQUFhLENBQVosSUFBSTtVQUFFLEtBQUssR0FBWixJQUFhLENBQU4sS0FBSzs7QUFDMUYsWUFBSyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDckMsWUFBSyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDakMsQ0FBQyxDQUFDLENBQUE7O0FBRUgsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQ2xCLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLHlFQUF5RSxFQUFFLFVBQUMsS0FBYSxFQUFLO1VBQWpCLElBQUksR0FBTCxLQUFhLENBQVosSUFBSTtVQUFFLEtBQUssR0FBWixLQUFhLENBQU4sS0FBSzs7QUFDN0csVUFBSSxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ2pCLGNBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLENBQUMsMkJBQWMsTUFBSyxjQUFjLEVBQUUsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDdEY7O0FBRUQsV0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE1BQUssZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO0FBQ3JELFlBQU0sTUFBTSxHQUFHLE1BQUssZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDdkMsWUFBSSxNQUFNLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7QUFDN0IsZ0JBQUssZ0JBQWdCLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQTtTQUNuQztPQUNGOztBQUVELFVBQUksQ0FBQyxNQUFLLGdCQUFnQixDQUFDLE1BQU0sRUFBRTtBQUNqQyxjQUFLLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtPQUN2QztLQUNGLENBQUMsQ0FDSCxDQUFBO0dBQ0Y7O2VBN0NrQixZQUFZOztXQStDdkIsbUJBQUc7QUFDVCxVQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FBQTtBQUN4QixVQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzFCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRzs7O0FBQ1IsYUFDRTs7VUFBSyxRQUFRLEVBQUMsR0FBRyxFQUFDLFNBQVMsRUFBQyxhQUFhO1FBQ3ZDOztZQUFTLFNBQVMsRUFBQyxrQkFBa0I7VUFDbkM7O2NBQUssU0FBUyxFQUFDLHFDQUFxQztZQUNsRDs7Z0JBQUssU0FBUyxFQUFDLDJCQUEyQjtjQUN4Qzs7a0JBQUksU0FBUyxFQUFDLDBDQUEwQzs7ZUFBdUI7Y0FDL0U7O2tCQUFLLFNBQVMsRUFBQyxtQ0FBbUM7Z0JBQ2hEOzs7QUFDRSx1QkFBRyxFQUFDLGFBQWE7QUFDakIsNkJBQVMsRUFBQyx1QkFBdUI7QUFDakMsMkJBQU8sRUFBRSxZQUFNO0FBQUUsNkJBQUssZUFBZSxDQUFDLElBQUksQ0FBQyxDQUFBO3FCQUFFLEFBQUM7O2lCQUEyQjtnQkFDM0U7OztBQUNFLHVCQUFHLEVBQUMsaUJBQWlCO0FBQ3JCLDZCQUFTLEVBQUMsbUNBQW1DO0FBQzdDLDJCQUFPLEVBQUUsWUFBTTtBQUFFLDZCQUFLLFNBQVMsRUFBRSxDQUFBO3FCQUFFLEFBQUM7O2lCQUFvQjtlQUN0RDthQUNGO1lBRU47O2dCQUFLLEdBQUcsRUFBQyw4QkFBOEIsRUFBQyxTQUFTLEVBQUMscUNBQXFDOztjQUFtRzs7O2dCQUFVLElBQUksQ0FBQyxjQUFjLENBQUMsd0JBQXdCLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2VBQVc7YUFBTTtZQUM5USwrQkFBSyxHQUFHLEVBQUMsY0FBYyxHQUFHO1lBQzFCOztnQkFBSyxHQUFHLEVBQUMsaUJBQWlCLEVBQUMsU0FBUyxFQUFDLHNDQUFzQzs7YUFBcUM7WUFDaEg7O2dCQUFLLEdBQUcsRUFBQyxrQkFBa0IsRUFBQyxTQUFTLEVBQUMsa0NBQWtDOzthQUFxRDtZQUM3SCwrQkFBSyxHQUFHLEVBQUMsa0JBQWtCLEVBQUMsU0FBUyxFQUFDLDZCQUE2QixHQUFHO1dBQ2xFO1NBQ0U7T0FDTixDQUNQO0tBQ0Y7OztXQUVLLGlCQUFHO0FBQ1AsVUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtLQUNyQjs7O1dBRUksZ0JBQUc7QUFDTixVQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0tBQ2hDOzs7V0FFVSxvQkFBQyxJQUFJLEVBQUU7OztBQUNoQixVQUFJLElBQUksSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFO0FBQ3JCLFlBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFBO0FBQzVDLFlBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sR0FBRyxZQUFNO0FBQUUsaUJBQUssWUFBWSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7U0FBRSxDQUFBO09BQ2hGOztBQUVELFVBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDeEIsWUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQUE7QUFDcEMsWUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFBO09BQ3RCLE1BQU07QUFDTCxZQUFJLENBQUMsZ0JBQWdCLEdBQUcsRUFBRSxDQUFBO0FBQzFCLFlBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFBO0FBQ3hCLFlBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQTtPQUN2Qjs7QUFFRCxVQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsd0JBQXdCLEVBQUUsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO0FBQy9ELFlBQUksQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDOUQ7S0FDRjs7Ozs7NkJBR3FCLFdBQUMsVUFBVSxFQUFFO0FBQ2pDLFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDakQsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN6QyxVQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBO0FBQ3JDLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBOztBQUU1QyxVQUFJO0FBQ0YsWUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDekUsWUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtBQUN0QyxZQUFJLENBQUMsY0FBYyxFQUFFLENBQUE7T0FDdEIsQ0FBQyxPQUFPLEtBQUssRUFBRTtBQUNkLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDaEQsWUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxDQUFDLDJCQUFjLElBQUksQ0FBQyxjQUFjLEVBQUUsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDdEY7S0FDRjs7O1dBRWMsMEJBQUc7QUFDaEIsVUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUNwQyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUM1QyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO09BQzNDO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDaEQsVUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUE7QUFDeEIsVUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtBQUN0QyxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQzlDOztBQUVELFdBQUssSUFBTSxJQUFJLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFO0FBQ3hDLFlBQU0sV0FBVyxHQUFHLDZCQUFnQixJQUFJLEVBQUUsSUFBSSxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFFLEVBQUMsSUFBSSxFQUFFLFNBQVMsRUFBQyxDQUFDLENBQUE7QUFDcEcsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFBO0FBQzNELFlBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFBO09BQ3BDO0tBQ0Y7Ozs2QkFFZSxhQUFHO0FBQ2pCLFVBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDckMsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTs7QUFFekMsVUFBSSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUE7QUFDNUMsVUFBSSxzQkFBc0IsR0FBRyxDQUFDLENBQUE7QUFDOUIsVUFBSSxrQkFBa0IsR0FBRyxDQUFDLENBQUE7O0FBRTFCLFVBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLHdDQUF3QyxDQUFDLEdBQUcsQ0FBQyxHQUM3RSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyx3Q0FBd0MsQ0FBQyxHQUN6RCxNQUFNLENBQUMsaUJBQWlCLENBQUE7O0FBRTVCLFVBQU0sS0FBSyxHQUFHLG1CQUFNLEtBQUssQ0FBQyxVQUFVLFdBQVcsRUFBRSxRQUFRLEVBQUU7QUFDekQsWUFBTSxpQkFBaUIsR0FBRyxTQUFwQixpQkFBaUIsQ0FBYSxHQUFHLEVBQUU7QUFDdkMsYUFBRyxJQUFJLElBQUksR0FBRyxzQkFBc0IsRUFBRSxHQUFHLGtCQUFrQixFQUFFLENBQUE7U0FDOUQsQ0FBQTs7QUFFRCxZQUFJLGdCQUFnQixDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDL0Msa0JBQVEsRUFBRSxDQUFBO1NBQ1gsTUFBTTtBQUNMLHFCQUFXLENBQUMsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLGlCQUFpQixDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFBO1NBQy9FO09BQ0YsRUFBRSxXQUFXLENBQUMsQ0FBQTs7QUFFZixVQUFNLG1CQUFtQixHQUFHLElBQUksT0FBTyxDQUFDLFVBQUMsT0FBTyxFQUFLO0FBQ25ELGFBQUssQ0FBQyxLQUFLLEdBQUcsT0FBTyxDQUFBO09BQ3RCLENBQUMsQ0FBQTs7QUFFRixXQUFLLElBQUksV0FBVyxJQUFJLElBQUksQ0FBQyxZQUFZLEVBQUU7QUFDekMsYUFBSyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQTtPQUN4Qjs7QUFFRCxZQUFNLG1CQUFtQixDQUFBOztBQUV6QixVQUFJLHNCQUFzQixHQUFHLENBQUMsRUFBRTtBQUM5QixZQUFNLE9BQU8sK0NBQTZDLHNCQUFzQixTQUFJLFNBQVMsQ0FBQyxTQUFTLEVBQUUsc0JBQXNCLENBQUMsTUFBRyxDQUFBO0FBQ25JLFlBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQTtBQUNmLFlBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLFVBQUMsSUFBSSxFQUFLO0FBQ2xDLGNBQUksVUFBVSxHQUFHLEVBQUUsQ0FBQTtBQUNuQixjQUFJLFVBQVUsR0FBRyxFQUFFLENBQUE7O0FBRW5CLGNBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksS0FBSyxLQUFLLEVBQUU7QUFDM0Usc0JBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFBO0FBQ3hELHNCQUFVLFFBQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQUFBRSxDQUFBO1dBQ25ELE1BQU0sSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRTtBQUN2RCxzQkFBVSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFBO0FBQzlCLHNCQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUE7V0FDckM7O0FBRUQsY0FBSSxVQUFVLElBQUksVUFBVSxFQUFFO0FBQzVCLGtCQUFNLElBQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLFNBQUksVUFBVSxZQUFPLFVBQVUsT0FBSSxDQUFBO1dBQy9EO1NBQ0YsQ0FBQyxDQUFBO0FBQ0YsY0FBTSxHQUFHLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQTs7QUFFdEIsWUFBTSxPQUFPLEdBQUcsQ0FBQztBQUNmLGNBQUksRUFBRSxTQUFTO0FBQ2Ysb0JBQVUsRUFBQyxzQkFBRztBQUFFLG1CQUFPLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFBO1dBQUU7U0FDbkQsQ0FBQyxDQUFBO0FBQ0YsWUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLEVBQUMsV0FBVyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQVAsT0FBTyxFQUFFLE1BQU0sRUFBTixNQUFNLEVBQUMsQ0FBQyxDQUFBO09BQzdFOztBQUVELFVBQUksa0JBQWtCLEtBQUssQ0FBQyxFQUFFO0FBQzVCLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDakQsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtPQUMzQztLQUNGOzs7V0FFaUIsNkJBQUc7QUFDbkIsYUFBTyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRTtBQUMvQixZQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFBO09BQ2xDO0tBQ0Y7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0tBQzFEOzs7V0FFVSxzQkFBRztBQUNaLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUMxRDs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVEsb0JBQUc7QUFDVixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVcsdUJBQUc7QUFDYixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUE7S0FDM0I7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ25EOzs7U0F4UGtCLFlBQVk7OztxQkFBWixZQUFZOztBQTJQakMsU0FBUyxTQUFTLENBQUUsSUFBSSxFQUFFLEtBQUssRUFBRTtBQUMvQixTQUFPLEFBQUMsS0FBSyxHQUFHLENBQUMsR0FBTyxJQUFJLFNBQU0sSUFBSSxDQUFBO0NBQ3ZDIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi91cGRhdGVzLXBhbmVsLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IHtDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IGFzeW5jIGZyb20gJ2FzeW5jJ1xuaW1wb3J0IGV0Y2ggZnJvbSAnZXRjaCdcblxuaW1wb3J0IEVycm9yVmlldyBmcm9tICcuL2Vycm9yLXZpZXcnXG5pbXBvcnQgUGFja2FnZUNhcmQgZnJvbSAnLi9wYWNrYWdlLWNhcmQnXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFVwZGF0ZXNQYW5lbCB7XG4gIGNvbnN0cnVjdG9yIChzZXR0aW5nc1ZpZXcsIHBhY2thZ2VNYW5hZ2VyKSB7XG4gICAgdGhpcy5zZXR0aW5nc1ZpZXcgPSBzZXR0aW5nc1ZpZXdcbiAgICB0aGlzLnBhY2thZ2VNYW5hZ2VyID0gcGFja2FnZU1hbmFnZXJcbiAgICB0aGlzLmRpc3Bvc2FibGVzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuICAgIHRoaXMudXBkYXRpbmdQYWNrYWdlcyA9IFtdXG4gICAgdGhpcy5wYWNrYWdlQ2FyZHMgPSBbXVxuXG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG5cbiAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB0aGlzLmNoZWNrRm9yVXBkYXRlcygpXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLmNvbW1hbmRzLmFkZCh0aGlzLmVsZW1lbnQsIHtcbiAgICAgICdjb3JlOm1vdmUtdXAnOiAoKSA9PiB7IHRoaXMuc2Nyb2xsVXAoKSB9LFxuICAgICAgJ2NvcmU6bW92ZS1kb3duJzogKCkgPT4geyB0aGlzLnNjcm9sbERvd24oKSB9LFxuICAgICAgJ2NvcmU6cGFnZS11cCc6ICgpID0+IHsgdGhpcy5wYWdlVXAoKSB9LFxuICAgICAgJ2NvcmU6cGFnZS1kb3duJzogKCkgPT4geyB0aGlzLnBhZ2VEb3duKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtdG8tdG9wJzogKCkgPT4geyB0aGlzLnNjcm9sbFRvVG9wKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtdG8tYm90dG9tJzogKCkgPT4geyB0aGlzLnNjcm9sbFRvQm90dG9tKCkgfVxuICAgIH0pKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQodGhpcy5wYWNrYWdlTWFuYWdlci5vbigncGFja2FnZS11cGRhdGluZyB0aGVtZS11cGRhdGluZycsICh7cGFjaywgZXJyb3J9KSA9PiB7XG4gICAgICB0aGlzLnJlZnMuY2hlY2tCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgICB0aGlzLnVwZGF0aW5nUGFja2FnZXMucHVzaChwYWNrKVxuICAgIH0pKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoXG4gICAgICB0aGlzLnBhY2thZ2VNYW5hZ2VyLm9uKCdwYWNrYWdlLXVwZGF0ZWQgdGhlbWUtdXBkYXRlZCBwYWNrYWdlLXVwZGF0ZS1mYWlsZWQgdGhlbWUtdXBkYXRlLWZhaWxlZCcsICh7cGFjaywgZXJyb3J9KSA9PiB7XG4gICAgICAgIGlmIChlcnJvciAhPSBudWxsKSB7XG4gICAgICAgICAgdGhpcy5yZWZzLnVwZGF0ZUVycm9ycy5hcHBlbmRDaGlsZChuZXcgRXJyb3JWaWV3KHRoaXMucGFja2FnZU1hbmFnZXIsIGVycm9yKS5lbGVtZW50KVxuICAgICAgICB9XG5cbiAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCB0aGlzLnVwZGF0aW5nUGFja2FnZXMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICBjb25zdCB1cGRhdGUgPSB0aGlzLnVwZGF0aW5nUGFja2FnZXNbaV1cbiAgICAgICAgICBpZiAodXBkYXRlLm5hbWUgPT09IHBhY2submFtZSkge1xuICAgICAgICAgICAgdGhpcy51cGRhdGluZ1BhY2thZ2VzLnNwbGljZShpLCAxKVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy51cGRhdGluZ1BhY2thZ2VzLmxlbmd0aCkge1xuICAgICAgICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICAgIH1cbiAgICAgIH0pXG4gICAgKVxuICB9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5jbGVhclBhY2thZ2VDYXJkcygpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICByZXR1cm4gZXRjaC5kZXN0cm95KHRoaXMpXG4gIH1cblxuICB1cGRhdGUgKCkge31cblxuICByZW5kZXIgKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IHRhYkluZGV4PScwJyBjbGFzc05hbWU9J3BhbmVscy1pdGVtJz5cbiAgICAgICAgPHNlY3Rpb24gY2xhc3NOYW1lPSdzZWN0aW9uIHBhY2thZ2VzJz5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1jb250YWluZXIgdXBkYXRlcy1jb250YWluZXInPlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3VwZGF0ZXMtaGVhZGluZy1jb250YWluZXInPlxuICAgICAgICAgICAgICA8aDEgY2xhc3NOYW1lPSdzZWN0aW9uLWhlYWRpbmcgaWNvbiBpY29uLWNsb3VkLWRvd25sb2FkJz5BdmFpbGFibGUgVXBkYXRlczwvaDE+XG4gICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZWN0aW9uLWhlYWRpbmcgdXBkYXRlcy1idG4tZ3JvdXAnPlxuICAgICAgICAgICAgICAgIDxidXR0b25cbiAgICAgICAgICAgICAgICAgIHJlZj0nY2hlY2tCdXR0b24nXG4gICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J3VwZGF0ZS1hbGwtYnV0dG9uIGJ0bidcbiAgICAgICAgICAgICAgICAgIG9uY2xpY2s9eygpID0+IHsgdGhpcy5jaGVja0ZvclVwZGF0ZXModHJ1ZSkgfX0+Q2hlY2sgZm9yIFVwZGF0ZXM8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICAgICAgICByZWY9J3VwZGF0ZUFsbEJ1dHRvbidcbiAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZT0ndXBkYXRlLWFsbC1idXR0b24gYnRuIGJ0bi1wcmltYXJ5J1xuICAgICAgICAgICAgICAgICAgb25jbGljaz17KCkgPT4geyB0aGlzLnVwZGF0ZUFsbCgpIH19PlVwZGF0ZSBBbGw8L2J1dHRvbj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgPGRpdiByZWY9J3ZlcnNpb25QaW5uZWRQYWNrYWdlc01lc3NhZ2UnIGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtd2FybmluZyBpY29uIGljb24tYWxlcnQnPlRoZSBmb2xsb3dpbmcgcGFja2FnZXMgYXJlIHBpbm5lZCB0byB0aGVpciBjdXJyZW50IHZlcnNpb24gYW5kIGFyZSBub3QgYmVpbmcgY2hlY2tlZCBmb3IgdXBkYXRlczogPHN0cm9uZz57IHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0VmVyc2lvblBpbm5lZFBhY2thZ2VzKCkuam9pbignLCAnKSB9PC9zdHJvbmc+PC9kaXY+XG4gICAgICAgICAgICA8ZGl2IHJlZj0ndXBkYXRlRXJyb3JzJyAvPlxuICAgICAgICAgICAgPGRpdiByZWY9J2NoZWNraW5nTWVzc2FnZScgY2xhc3NOYW1lPSdhbGVydCBhbGVydC1pbmZvIGljb24gaWNvbi1ob3VyZ2xhc3MnPntgQ2hlY2tpbmcgZm9yIHVwZGF0ZXNcXHUyMDI2YH08L2Rpdj5cbiAgICAgICAgICAgIDxkaXYgcmVmPSdub1VwZGF0ZXNNZXNzYWdlJyBjbGFzc05hbWU9J2FsZXJ0IGFsZXJ0LWluZm8gaWNvbiBpY29uLWhlYXJ0Jz5BbGwgb2YgeW91ciBpbnN0YWxsZWQgcGFja2FnZXMgYXJlIHVwIHRvIGRhdGUhPC9kaXY+XG4gICAgICAgICAgICA8ZGl2IHJlZj0ndXBkYXRlc0NvbnRhaW5lcicgY2xhc3NOYW1lPSdjb250YWluZXIgcGFja2FnZS1jb250YWluZXInIC8+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvc2VjdGlvbj5cbiAgICAgIDwvZGl2PlxuICAgIClcbiAgfVxuXG4gIGZvY3VzICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuZm9jdXMoKVxuICB9XG5cbiAgc2hvdyAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnN0eWxlLmRpc3BsYXkgPSAnJ1xuICB9XG5cbiAgYmVmb3JlU2hvdyAob3B0cykge1xuICAgIGlmIChvcHRzICYmIG9wdHMuYmFjaykge1xuICAgICAgdGhpcy5yZWZzLmJyZWFkY3J1bWIudGV4dENvbnRlbnQgPSBvcHRzLmJhY2tcbiAgICAgIHRoaXMucmVmcy5icmVhZGNydW1iLm9uY2xpY2sgPSAoKSA9PiB7IHRoaXMuc2V0dGluZ3NWaWV3LnNob3dQYW5lbChvcHRzLmJhY2spIH1cbiAgICB9XG5cbiAgICBpZiAob3B0cyAmJiBvcHRzLnVwZGF0ZXMpIHtcbiAgICAgIHRoaXMuYXZhaWxhYmxlVXBkYXRlcyA9IG9wdHMudXBkYXRlc1xuICAgICAgdGhpcy5hZGRVcGRhdGVWaWV3cygpXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuYXZhaWxhYmxlVXBkYXRlcyA9IFtdXG4gICAgICB0aGlzLmNsZWFyUGFja2FnZUNhcmRzKClcbiAgICAgIHRoaXMuY2hlY2tGb3JVcGRhdGVzKClcbiAgICB9XG5cbiAgICBpZiAodGhpcy5wYWNrYWdlTWFuYWdlci5nZXRWZXJzaW9uUGlubmVkUGFja2FnZXMoKS5sZW5ndGggPT09IDApIHtcbiAgICAgIHRoaXMucmVmcy52ZXJzaW9uUGlubmVkUGFja2FnZXNNZXNzYWdlLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9XG4gIH1cblxuICAvLyBDaGVjayBmb3IgdXBkYXRlcyBhbmQgZGlzcGxheSB0aGVtXG4gIGFzeW5jIGNoZWNrRm9yVXBkYXRlcyAoY2xlYXJDYWNoZSkge1xuICAgIHRoaXMucmVmcy5ub1VwZGF0ZXNNZXNzYWdlLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICB0aGlzLnJlZnMuY2hlY2tpbmdNZXNzYWdlLnN0eWxlLmRpc3BsYXkgPSAnJ1xuXG4gICAgdHJ5IHtcbiAgICAgIHRoaXMuYXZhaWxhYmxlVXBkYXRlcyA9IGF3YWl0IHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0T3V0ZGF0ZWQoY2xlYXJDYWNoZSlcbiAgICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLmFkZFVwZGF0ZVZpZXdzKClcbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgdGhpcy5yZWZzLmNoZWNrQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy5jaGVja2luZ01lc3NhZ2Uuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUVycm9ycy5hcHBlbmRDaGlsZChuZXcgRXJyb3JWaWV3KHRoaXMucGFja2FnZU1hbmFnZXIsIGVycm9yKS5lbGVtZW50KVxuICAgIH1cbiAgfVxuXG4gIGFkZFVwZGF0ZVZpZXdzICgpIHtcbiAgICBpZiAodGhpcy5hdmFpbGFibGVVcGRhdGVzLmxlbmd0aCA+IDApIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVBbGxCdXR0b24uc3R5bGUuZGlzcGxheSA9ICcnXG4gICAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICB9XG4gICAgdGhpcy5yZWZzLmNoZWNraW5nTWVzc2FnZS5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgdGhpcy5jbGVhclBhY2thZ2VDYXJkcygpXG4gICAgaWYgKHRoaXMuYXZhaWxhYmxlVXBkYXRlcy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRoaXMucmVmcy5ub1VwZGF0ZXNNZXNzYWdlLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIH1cblxuICAgIGZvciAoY29uc3QgcGFjayBvZiB0aGlzLmF2YWlsYWJsZVVwZGF0ZXMpIHtcbiAgICAgIGNvbnN0IHBhY2thZ2VDYXJkID0gbmV3IFBhY2thZ2VDYXJkKHBhY2ssIHRoaXMuc2V0dGluZ3NWaWV3LCB0aGlzLnBhY2thZ2VNYW5hZ2VyLCB7YmFjazogJ1VwZGF0ZXMnfSlcbiAgICAgIHRoaXMucmVmcy51cGRhdGVzQ29udGFpbmVyLmFwcGVuZENoaWxkKHBhY2thZ2VDYXJkLmVsZW1lbnQpXG4gICAgICB0aGlzLnBhY2thZ2VDYXJkcy5wdXNoKHBhY2thZ2VDYXJkKVxuICAgIH1cbiAgfVxuXG4gIGFzeW5jIHVwZGF0ZUFsbCAoKSB7XG4gICAgdGhpcy5yZWZzLmNoZWNrQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgIHRoaXMucmVmcy51cGRhdGVBbGxCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG5cbiAgICBsZXQgdXBkYXRpbmdQYWNrYWdlcyA9IHRoaXMudXBkYXRpbmdQYWNrYWdlc1xuICAgIGxldCBzdWNjZXNzZnVsVXBkYXRlc0NvdW50ID0gMFxuICAgIGxldCBmYWlsZWRVcGRhdGVzQ291bnQgPSAwXG5cbiAgICBjb25zdCBjb25jdXJyZW5jeSA9IGF0b20uY29uZmlnLmdldCgnc2V0dGluZ3Mtdmlldy5wYWNrYWdlVXBkYXRlQ29uY3VycmVuY3knKSA+IDBcbiAgICAgID8gYXRvbS5jb25maWcuZ2V0KCdzZXR0aW5ncy12aWV3LnBhY2thZ2VVcGRhdGVDb25jdXJyZW5jeScpXG4gICAgICA6IE51bWJlci5QT1NJVElWRV9JTkZJTklUWVxuXG4gICAgY29uc3QgcXVldWUgPSBhc3luYy5xdWV1ZShmdW5jdGlvbiAocGFja2FnZUNhcmQsIGNhbGxiYWNrKSB7XG4gICAgICBjb25zdCBvblVwZGF0ZUNvbXBsZXRlZCA9IGZ1bmN0aW9uIChlcnIpIHtcbiAgICAgICAgZXJyID09IG51bGwgPyBzdWNjZXNzZnVsVXBkYXRlc0NvdW50KysgOiBmYWlsZWRVcGRhdGVzQ291bnQrK1xuICAgICAgfVxuXG4gICAgICBpZiAodXBkYXRpbmdQYWNrYWdlcy5pbmNsdWRlcyhwYWNrYWdlQ2FyZC5wYWNrKSkge1xuICAgICAgICBjYWxsYmFjaygpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBwYWNrYWdlQ2FyZC51cGRhdGUoKS50aGVuKG9uVXBkYXRlQ29tcGxldGVkLCBvblVwZGF0ZUNvbXBsZXRlZCkudGhlbihjYWxsYmFjaylcbiAgICAgIH1cbiAgICB9LCBjb25jdXJyZW5jeSlcblxuICAgIGNvbnN0IHF1ZXVlRHJhaW5lZFByb21pc2UgPSBuZXcgUHJvbWlzZSgocmVzb2x2ZSkgPT4ge1xuICAgICAgcXVldWUuZHJhaW4gPSByZXNvbHZlXG4gICAgfSlcblxuICAgIGZvciAobGV0IHBhY2thZ2VDYXJkIG9mIHRoaXMucGFja2FnZUNhcmRzKSB7XG4gICAgICBxdWV1ZS5wdXNoKHBhY2thZ2VDYXJkKVxuICAgIH1cblxuICAgIGF3YWl0IHF1ZXVlRHJhaW5lZFByb21pc2VcblxuICAgIGlmIChzdWNjZXNzZnVsVXBkYXRlc0NvdW50ID4gMCkge1xuICAgICAgY29uc3QgbWVzc2FnZSA9IGBSZXN0YXJ0IEF0b20gdG8gY29tcGxldGUgdGhlIHVwZGF0ZSBvZiAke3N1Y2Nlc3NmdWxVcGRhdGVzQ291bnR9ICR7cGx1cmFsaXplKCdwYWNrYWdlJywgc3VjY2Vzc2Z1bFVwZGF0ZXNDb3VudCl9OmBcbiAgICAgIGxldCBkZXRhaWwgPSAnJ1xuICAgICAgdGhpcy5wYWNrYWdlQ2FyZHMuZm9yRWFjaCgoY2FyZCkgPT4ge1xuICAgICAgICBsZXQgb2xkVmVyc2lvbiA9ICcnXG4gICAgICAgIGxldCBuZXdWZXJzaW9uID0gJydcblxuICAgICAgICBpZiAoY2FyZC5wYWNrLmFwbUluc3RhbGxTb3VyY2UgJiYgY2FyZC5wYWNrLmFwbUluc3RhbGxTb3VyY2UudHlwZSA9PT0gJ2dpdCcpIHtcbiAgICAgICAgICBvbGRWZXJzaW9uID0gY2FyZC5wYWNrLmFwbUluc3RhbGxTb3VyY2Uuc2hhLnN1YnN0cigwLCA4KVxuICAgICAgICAgIG5ld1ZlcnNpb24gPSBgJHtjYXJkLnBhY2subGF0ZXN0U2hhLnN1YnN0cigwLCA4KX1gXG4gICAgICAgIH0gZWxzZSBpZiAoY2FyZC5wYWNrLnZlcnNpb24gJiYgY2FyZC5wYWNrLmxhdGVzdFZlcnNpb24pIHtcbiAgICAgICAgICBvbGRWZXJzaW9uID0gY2FyZC5wYWNrLnZlcnNpb25cbiAgICAgICAgICBuZXdWZXJzaW9uID0gY2FyZC5wYWNrLmxhdGVzdFZlcnNpb25cbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChvbGRWZXJzaW9uICYmIG5ld1ZlcnNpb24pIHtcbiAgICAgICAgICBkZXRhaWwgKz0gYCR7Y2FyZC5wYWNrLm5hbWV9QCR7b2xkVmVyc2lvbn0gLT4gJHtuZXdWZXJzaW9ufVxcbmBcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICAgIGRldGFpbCA9IGRldGFpbC50cmltKClcblxuICAgICAgY29uc3QgYnV0dG9ucyA9IFt7XG4gICAgICAgIHRleHQ6ICdSZXN0YXJ0JyxcbiAgICAgICAgb25EaWRDbGljayAoKSB7IHJldHVybiBhdG9tLnJlc3RhcnRBcHBsaWNhdGlvbigpIH1cbiAgICAgIH1dXG4gICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkU3VjY2VzcyhtZXNzYWdlLCB7ZGlzbWlzc2FibGU6IHRydWUsIGJ1dHRvbnMsIGRldGFpbH0pXG4gICAgfVxuXG4gICAgaWYgKGZhaWxlZFVwZGF0ZXNDb3VudCA9PT0gMCkge1xuICAgICAgdGhpcy5yZWZzLmNoZWNrQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy51cGRhdGVBbGxCdXR0b24uc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMuY2hlY2tCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUFsbEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgfVxuICB9XG5cbiAgY2xlYXJQYWNrYWdlQ2FyZHMgKCkge1xuICAgIHdoaWxlICh0aGlzLnBhY2thZ2VDYXJkcy5sZW5ndGgpIHtcbiAgICAgIHRoaXMucGFja2FnZUNhcmRzLnBvcCgpLmRlc3Ryb3koKVxuICAgIH1cbiAgfVxuXG4gIHNjcm9sbFVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IGRvY3VtZW50LmJvZHkub2Zmc2V0SGVpZ2h0IC8gMjBcbiAgfVxuXG4gIHNjcm9sbERvd24gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgKz0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgcGFnZVVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHBhZ2VEb3duICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wICs9IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHNjcm9sbFRvVG9wICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wID0gMFxuICB9XG5cbiAgc2Nyb2xsVG9Cb3R0b20gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgPSB0aGlzLmVsZW1lbnQuc2Nyb2xsSGVpZ2h0XG4gIH1cbn1cblxuZnVuY3Rpb24gcGx1cmFsaXplICh3b3JkLCBjb3VudCkge1xuICByZXR1cm4gKGNvdW50ID4gMSkgPyBgJHt3b3JkfXNgIDogd29yZFxufVxuIl19