Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _hostedGitInfo = require('hosted-git-info');

var _hostedGitInfo2 = _interopRequireDefault(_hostedGitInfo);

var _atom = require('atom');

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var PackageNameRegex = /config\/install\/(package|theme):([a-z0-9-_]+)/i;

var InstallPanel = (function () {
  function InstallPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstallPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.client = this.packageManager.getClient();
    this.atomIoURL = 'https://atom.io/packages';

    _etch2['default'].initialize(this);

    this.refs.searchMessage.style.display = 'none';

    this.refs.searchEditor.setPlaceholderText('Search packages');
    this.searchType = 'packages';
    this.disposables.add(this.packageManager.on('package-install-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.searchErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.packageManager.on('package-installed theme-installed', function (_ref2) {
      var pack = _ref2.pack;

      var gitUrlInfo = _this.currentGitPackageCard && _this.currentGitPackageCard.pack && _this.currentGitPackageCard.pack.gitUrlInfo ? _this.currentGitPackageCard.pack.gitUrlInfo : null;

      if (gitUrlInfo && gitUrlInfo === pack.gitUrlInfo) {
        _this.updateGitPackageCard(pack);
      }
    }));
    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.performSearch();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadFeaturedPackages();
  }

  _createClass(InstallPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'h1',
              { ref: 'installHeading', className: 'section-heading icon icon-plus' },
              'Install Packages'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom('span', { className: 'icon icon-question' }),
              _etch2['default'].dom(
                'span',
                { ref: 'publishedToText' },
                'Packages are published to '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenAtomIo.bind(this) },
                'atom.io'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' and are installed to ',
                _path2['default'].join(process.env.ATOM_HOME, 'packages')
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'search-container clearfix' },
              _etch2['default'].dom(
                'div',
                { className: 'editor-container' },
                _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchPackagesButton', className: 'btn btn-default selected', onclick: this.didClickSearchPackagesButton.bind(this) },
                  'Packages'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchThemesButton', className: 'btn btn-default', onclick: this.didClickSearchThemesButton.bind(this) },
                  'Themes'
                )
              )
            ),
            _etch2['default'].dom('div', { ref: 'searchErrors' }),
            _etch2['default'].dom('div', { ref: 'searchMessage', className: 'alert alert-info search-message icon icon-search' }),
            _etch2['default'].dom('div', { ref: 'resultsContainer', className: 'container package-container' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom('div', { ref: 'featuredHeading', className: 'section-heading icon icon-star' }),
            _etch2['default'].dom('div', { ref: 'featuredErrors' }),
            _etch2['default'].dom('div', { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' }),
            _etch2['default'].dom('div', { ref: 'featuredContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'setSearchType',
    value: function setSearchType(searchType) {
      if (searchType === 'theme') {
        this.searchType = 'themes';
        this.refs.searchThemesButton.classList.add('selected');
        this.refs.searchPackagesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search themes');
        this.refs.publishedToText.textContent = 'Themes are published to ';
        this.atomIoURL = 'https://atom.io/themes';
        this.loadFeaturedPackages(true);
      } else if (searchType === 'package') {
        this.searchType = 'packages';
        this.refs.searchPackagesButton.classList.add('selected');
        this.refs.searchThemesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search packages');
        this.refs.publishedToText.textContent = 'Packages are published to ';
        this.atomIoURL = 'https://atom.io/packages';
        this.loadFeaturedPackages();
      }
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(options) {
      if (options && options.uri) {
        var query = this.extractQueryFromURI(options.uri);
        if (query != null) {
          var searchType = query.searchType;
          var packageName = query.packageName;

          this.setSearchType(searchType);
          this.refs.searchEditor.setText(packageName);
          this.performSearch();
        }
      }
    }
  }, {
    key: 'extractQueryFromURI',
    value: function extractQueryFromURI(uri) {
      var matches = PackageNameRegex.exec(uri);
      if (matches) {
        var _Array$from = Array.from(matches);

        var _Array$from2 = _slicedToArray(_Array$from, 3);

        var searchType = _Array$from2[1];
        var packageName = _Array$from2[2];

        return { searchType: searchType, packageName: packageName };
      } else {
        return null;
      }
    }
  }, {
    key: 'performSearch',
    value: function performSearch() {
      var query = this.refs.searchEditor.getText().trim().toLowerCase();
      if (query) {
        this.performSearchForQuery(query);
      }
    }
  }, {
    key: 'performSearchForQuery',
    value: function performSearchForQuery(query) {
      var gitUrlInfo = _hostedGitInfo2['default'].fromUrl(query);
      if (gitUrlInfo) {
        var type = gitUrlInfo['default'];
        if (type === 'sshurl' || type === 'https' || type === 'shortcut') {
          this.showGitInstallPackageCard({ name: query, gitUrlInfo: gitUrlInfo });
        }
      } else {
        this.search(query);
      }
    }
  }, {
    key: 'showGitInstallPackageCard',
    value: function showGitInstallPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.currentGitPackageCard.displayGitPackageInstallInformation();
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'updateGitPackageCard',
    value: function updateGitPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'replaceCurrentGitPackageCardView',
    value: function replaceCurrentGitPackageCardView() {
      this.refs.resultsContainer.innerHTML = '';
      this.addPackageCardView(this.refs.resultsContainer, this.currentGitPackageCard);
    }
  }, {
    key: 'search',
    value: _asyncToGenerator(function* (query) {
      this.refs.resultsContainer.innerHTML = '';
      this.refs.searchMessage.textContent = 'Searching ' + this.searchType + ' for “' + query + '”…';
      this.refs.searchMessage.style.display = '';

      var options = {};
      options[this.searchType] = true;

      try {
        var packages = (yield this.client.search(query, options)) || [];
        this.refs.resultsContainer.innerHTML = '';
        this.refs.searchMessage.style.display = 'none';
        if (packages.length === 0) {
          this.refs.searchMessage.textContent = 'No ' + this.searchType.replace(/s$/, '') + ' results for “' + query + '”';
          this.refs.searchMessage.style.display = '';
        }

        this.addPackageViews(this.refs.resultsContainer, packages);
      } catch (error) {
        this.refs.searchMessage.style.display = 'none';
        this.refs.searchErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addPackageViews',
    value: function addPackageViews(container, packages) {
      for (var pack of packages) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
      }
    }
  }, {
    key: 'addPackageCardView',
    value: function addPackageCardView(container, packageCard) {
      var packageRow = document.createElement('div');
      packageRow.classList.add('row');
      packageRow.appendChild(packageCard.element);
      container.appendChild(packageRow);
    }
  }, {
    key: 'getPackageCardView',
    value: function getPackageCardView(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Install' });
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages, themes) {
      return packages.filter(function (_ref3) {
        var theme = _ref3.theme;
        return themes ? theme : !theme;
      });
    }

    // Load and display the featured packages that are available to install.
  }, {
    key: 'loadFeaturedPackages',
    value: function loadFeaturedPackages(loadThemes) {
      var _this2 = this;

      if (loadThemes == null) {
        loadThemes = false;
      }
      this.refs.featuredContainer.innerHTML = '';

      if (loadThemes) {
        this.refs.installHeading.textContent = 'Install Themes';
        this.refs.featuredHeading.textContent = 'Featured Themes';
        this.refs.loadingMessage.textContent = 'Loading featured themes…';
      } else {
        this.refs.installHeading.textContent = 'Install Packages';
        this.refs.featuredHeading.textContent = 'Featured Packages';
        this.refs.loadingMessage.textContent = 'Loading featured packages…';
      }

      this.refs.loadingMessage.style.display = '';

      var handle = function handle(error) {
        _this2.refs.loadingMessage.style.display = 'none';
        _this2.refs.featuredErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      };

      if (loadThemes) {
        this.client.featuredThemes(function (error, themes) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Themes';
            _this2.addPackageViews(_this2.refs.featuredContainer, themes);
          }
        });
      } else {
        this.client.featuredPackages(function (error, packages) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Packages';
            _this2.addPackageViews(_this2.refs.featuredContainer, packages);
          }
        });
      }
    }
  }, {
    key: 'didClickOpenAtomIo',
    value: function didClickOpenAtomIo(event) {
      event.preventDefault();
      _electron2['default'].shell.openExternal(this.atomIoURL);
    }
  }, {
    key: 'didClickSearchPackagesButton',
    value: function didClickSearchPackagesButton() {
      if (!this.refs.searchPackagesButton.classList.contains('selected')) {
        this.setSearchType('package');
      }

      this.performSearch();
    }
  }, {
    key: 'didClickSearchThemesButton',
    value: function didClickSearchThemesButton() {
      if (!this.refs.searchThemesButton.classList.contains('selected')) {
        this.setSearchType('theme');
      }

      this.performSearch();
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstallPanel;
})();

exports['default'] = InstallPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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