/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));

var _taggedTemplateLiteral2 = _interopRequireDefault(require("./taggedTemplateLiteral"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function _templateObject2() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n      query ReactRelayPaginationContainerFlowtest_Foo_ViewerQuery(\n        $count: Int!\n        $cursor: ID\n      ) {\n        viewer {\n          ...Foo_viewer\n        }\n      }\n    "]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment ReactRelayPaginationContainerFlowtest_Foo_viewer on Viewer {\n      all_friends(after: $cursor, first: $count) @connection {\n        edges {\n          node {\n            __typename\n          }\n        }\n      }\n    }\n  "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var React = require("react");

var _require = require("./ReactRelayPublic"),
    graphql = _require.graphql,
    createPaginationContainer = _require.createPaginationContainer;
/**
 * Verifies that normal prop type checking, as well as the methods proxying Relay does, is
 * type-checked correctly on Relay components.
 */

/* $FlowFixMe(>=0.53.0) This comment suppresses an error
 * when upgrading Flow's support for React. Common errors found when upgrading
 * Flow's React support are documented at https://fburl.com/eq7bs81w */


var FooComponent =
/*#__PURE__*/
function (_React$Component) {
  (0, _inheritsLoose2["default"])(FooComponent, _React$Component);

  function FooComponent() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = FooComponent.prototype;

  _proto.getNum = function getNum() {
    return 42;
  };

  _proto.render = function render() {
    var reqLen = this.props.requiredProp.length;
    var optionalProp = this.props.optionalProp;
    /** $FlowExpectedError: `optionalProp` might be null **/

    var optionalFoo = this.props.optionalProp.foo;
    /** $FlowExpectedError: there is no prop `missingProp` **/

    var missing = this.props.missingProp;
    var defLen = this.props.defaultProp.length; // always a valid string, so no error

    return React.createElement("div", null, reqLen && optionalProp && optionalFoo && missing && defLen);
  };

  return FooComponent;
}(React.Component); // Note that we must reassign to a new identifier to make sure flow doesn't propogate types without
// the relay type definition doing the work.


(0, _defineProperty2["default"])(FooComponent, "defaultProps", {
  defaultProp: 'default'
});
var Foo = createPaginationContainer(FooComponent, graphql(_templateObject()), {
  direction: 'forward',
  getConnectionFromProps: function getConnectionFromProps(props) {
    return props.viewer.all_friends;
  },
  getFragmentVariables: function getFragmentVariables(vars, totalCount) {
    return (0, _objectSpread2["default"])({}, vars, {
      count: totalCount
    });
  },
  getVariables: function getVariables(props, _ref) {
    var count = _ref.count,
        cursor = _ref.cursor;
    return {
      after: cursor,
      count: count
    };
  },
  query: graphql(_templateObject2())
});
module.exports = {
  checkMissingProp: function checkMissingProp() {
    /** $ShouldBeFlowExpectedError: Foo missing `requiredProp` **/
    return React.createElement(Foo, null);
  },
  checkMinimalProps: function checkMinimalProps() {
    // All is well
    return React.createElement(Foo, {
      requiredProp: "foo"
    });
  },
  checkWrongPropType: function checkWrongPropType() {
    /** $ShouldBeFlowExpectedError: Foo1 wrong `requiredProp` type, should be string **/
    return React.createElement(Foo, {
      requiredProp: 17
    });
  },
  checkWrongOptionalType: function checkWrongOptionalType() {
    /** $ShouldBeFlowExpectedError: Foo wrong `optionalProp` type, should be `{foo: string}` **/
    return React.createElement(Foo, {
      optionalProp: "wrongType",
      requiredProp: "foo"
    });
  },
  checkNullOptionalType: function checkNullOptionalType() {
    /** $ShouldBeFlowExpectedError: Foo `optionalProp` must be omitted or truthy, not null **/
    return React.createElement(Foo, {
      optionalProp: null,
      requiredProp: "foo"
    });
  },
  checkWrongDefaultPropType: function checkWrongDefaultPropType() {
    /** $ShouldBeFlowExpectedError: Foo wrong `defaultProp` type, should be string **/
    return React.createElement(Foo, {
      defaultProp: false,
      requiredProp: "foo"
    });
  },
  checkAllPossibleProps: function checkAllPossibleProps() {
    // All is well
    return React.createElement(Foo, {
      defaultProp: "bar",
      optionalProp: {
        foo: 42
      },
      requiredProp: "foo"
    });
  },
  checkMinimalPropSpread: function checkMinimalPropSpread() {
    // All is well
    var props = {
      requiredProp: 'foo'
    };
    return React.createElement(Foo, props);
  },
  checkMissingPropSpread: function checkMissingPropSpread() {
    var props = {
      defaultProp: 'foo'
    };
    /** $ShouldBeFlowExpectedError: Foo missing `requiredProp` with spread **/

    return React.createElement(Foo, props);
  },
  checkStaticsAndMethodsProxying: function checkStaticsAndMethodsProxying() {
    /* $FlowFixMe(>=0.53.0) This comment suppresses an
     * error when upgrading Flow's support for React. Common errors found when
     * upgrading Flow's React support are documented at
     * https://fburl.com/eq7bs81w */
    var ProxyChecker =
    /*#__PURE__*/
    function (_React$PureComponent) {
      (0, _inheritsLoose2["default"])(ProxyChecker, _React$PureComponent);

      function ProxyChecker() {
        return _React$PureComponent.apply(this, arguments) || this;
      }

      var _proto2 = ProxyChecker.prototype;

      _proto2.getString = function getString() {
        var ok = this._fooRef ? this._fooRef.getNum() : 'default'; // legit

        /** $FlowExpectedError: Foo does not have `missingMethod` **/

        var bad = this._fooRef ? this._fooRef.missingMethod() : 'default';
        /** $FlowExpectedError: Foo `getNum` gives number, but `getString` assumes string  **/

        return bad ? 'not good' : ok;
      };

      _proto2.render = function render() {
        var _this = this;

        return React.createElement(Foo, {
          componentRef: function componentRef(ref) {
            _this._fooRef = ref;
          },
          requiredProp: "bar"
        });
      };

      return ProxyChecker;
    }(React.PureComponent);

    return React.createElement(ProxyChecker, null);
  }
};