"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareMergedEventView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../../views/timeago"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareMergedEventView extends _react.default.Component {
  render() {
    const {
      actor,
      mergeRefName,
      createdAt
    } = this.props.item;
    return _react.default.createElement("div", {
      className: "merged-event"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "git-merge"
    }), actor && _react.default.createElement("img", {
      className: "author-avatar",
      src: actor.avatarUrl,
      alt: actor.login,
      title: actor.login
    }), _react.default.createElement("span", {
      className: "merged-event-header"
    }, _react.default.createElement("span", {
      className: "username"
    }, actor ? actor.login : 'someone'), " merged", ' ', this.renderCommit(), " into", ' ', _react.default.createElement("span", {
      className: "merge-ref"
    }, mergeRefName), " on ", _react.default.createElement(_timeago.default, {
      time: createdAt
    })));
  }

  renderCommit() {
    const {
      commit
    } = this.props.item;

    if (!commit) {
      return 'a commit';
    }

    return _react.default.createElement(_react.Fragment, null, "commit ", _react.default.createElement("span", {
      className: "sha"
    }, commit.oid.slice(0, 8)));
  }

}

exports.BareMergedEventView = BareMergedEventView;

_defineProperty(BareMergedEventView, "propTypes", {
  item: _propTypes.default.shape({
    actor: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    }),
    commit: _propTypes.default.shape({
      oid: _propTypes.default.string.isRequired
    }),
    mergeRefName: _propTypes.default.string.isRequired,
    createdAt: _propTypes.default.string.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareMergedEventView, {
  item: function () {
    const node = require("./__generated__/mergedEventView_item.graphql");

    if (node.hash && node.hash !== "d265decf08c14d96c2ec47fd5852a956") {
      console.error("The definition of 'mergedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/mergedEventView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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