"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCrossReferencedEventsView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../../views/timeago"));

var _crossReferencedEventView = _interopRequireDefault(require("./cross-referenced-event-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCrossReferencedEventsView extends _react.default.Component {
  render() {
    return _react.default.createElement("div", {
      className: "timeline-item cross-referenced-events"
    }, _react.default.createElement("div", {
      className: "info-row"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "bookmark"
    }), _react.default.createElement("span", {
      className: "cross-referenced-event-header"
    }, this.renderSummary())), this.renderEvents());
  }

  renderSummary() {
    const first = this.props.nodes[0];

    if (this.props.nodes.length > 1) {
      return _react.default.createElement("span", null, "This was referenced ", _react.default.createElement(_timeago.default, {
        time: first.referencedAt
      }));
    } else {
      const type = {
        PullRequest: 'a pull request',
        Issue: 'an issue'
      }[first.source.__typename];
      let xrefClause = '';

      if (first.isCrossRepository) {
        const repo = first.source.repository;
        xrefClause = _react.default.createElement("span", null, "in ", _react.default.createElement("strong", null, repo.owner.login, "/", repo.name));
      }

      return _react.default.createElement("span", null, _react.default.createElement("img", {
        className: "author-avatar",
        src: first.actor.avatarUrl,
        alt: first.actor.login,
        title: first.actor.login
      }), _react.default.createElement("strong", null, first.actor.login), " referenced this from ", type, " ", xrefClause, _react.default.createElement(_timeago.default, {
        time: first.referencedAt
      }));
    }
  }

  renderEvents() {
    return this.props.nodes.map(node => {
      return _react.default.createElement(_crossReferencedEventView.default, {
        key: node.id,
        item: node
      });
    });
  }

}

exports.BareCrossReferencedEventsView = BareCrossReferencedEventsView;

_defineProperty(BareCrossReferencedEventsView, "propTypes", {
  nodes: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    referencedAt: _propTypes.default.string.isRequired,
    isCrossRepository: _propTypes.default.bool.isRequired,
    actor: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    }),
    source: _propTypes.default.shape({
      __typename: _propTypes.default.oneOf(['Issue', 'PullRequest']).isRequired,
      repository: _propTypes.default.shape({
        name: _propTypes.default.string.isRequired,
        owner: _propTypes.default.shape({
          login: _propTypes.default.string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventsView, {
  nodes: function () {
    const node = require("./__generated__/crossReferencedEventsView_nodes.graphql");

    if (node.hash && node.hash !== "5bbb7b39e10559bac4af2d6f9ff7a9e2") {
      console.error("The definition of 'crossReferencedEventsView_nodes' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/crossReferencedEventsView_nodes.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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