"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderIssueish', 'renderLoadingTile', 'renderEmptyTile', 'renderMoreTile');
  }

  render() {
    return _react.default.createElement(_accordion.default, {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  renderIssueish(issueish) {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("img", {
      className: "github-IssueishList-item github-IssueishList-item--avatar",
      src: issueish.getAuthorAvatarURL(32),
      title: issueish.getAuthorLogin(),
      alt: issueish.getAuthorLogin()
    }), _react.default.createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--title"
    }, issueish.getTitle()), _react.default.createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--number"
    }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react.default.createElement(_timeago.default, {
      time: issueish.getCreatedAt(),
      displayStyle: "short",
      className: "github-IssueishList-item github-IssueishList-item--age"
    }));
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react.default.createElement(_statusDonutChart.default, _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

  renderLoadingTile() {
    return _react.default.createElement("div", {
      className: "github-IssueishList-loading"
    }, "Loading");
  }

  renderEmptyTile() {
    if (this.props.error) {
      return _react.default.createElement(_queryErrorTile.default, {
        error: this.props.error
      });
    }

    if (this.props.emptyComponent) {
      const EmptyComponent = this.props.emptyComponent;
      return _react.default.createElement(EmptyComponent, null);
    }

    return null;
  }

  renderMoreTile() {
    /* eslint-disable jsx-a11y/anchor-is-valid */
    if (this.props.onMoreClick) {
      return _react.default.createElement("div", {
        className: "github-IssueishList-more"
      }, _react.default.createElement("a", {
        onClick: this.props.onMoreClick
      }, "More..."));
    }

    return null;
  }

}

exports.default = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes.default.string.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  total: _propTypes.default.number.isRequired,
  issueishes: _propTypes.default.arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes.default.shape({
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  onIssueishClick: _propTypes.default.func.isRequired,
  onMoreClick: _propTypes.default.func,
  emptyComponent: _propTypes.default.func,
  error: _propTypes.default.object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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