"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderDescription');
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-Message"
    }, _react.default.createElement("div", {
      className: "github-Message-wrapper"
    }, _react.default.createElement("h1", {
      className: "github-Message-title"
    }, this.props.title), this.props.descriptions.map(this.renderDescription), _react.default.createElement("div", {
      className: "github-Message-action"
    }, this.props.retry && _react.default.createElement("button", {
      className: "github-Message-button btn btn-primary",
      onClick: this.props.retry
    }, "Try Again"), this.props.logout && _react.default.createElement("button", {
      className: "github-Message-button btn btn-logout",
      onClick: this.props.logout
    }, "Logout"))));
  }

  renderDescription(description, key) {
    if (this.props.preformatted) {
      return _react.default.createElement("pre", {
        key: key,
        className: "github-Message-description"
      }, description);
    } else {
      return _react.default.createElement("p", {
        key: key,
        className: "github-Message-description"
      }, description);
    }
  }

}

exports.default = ErrorView;

_defineProperty(ErrorView, "propTypes", {
  title: _propTypes.default.string,
  descriptions: _propTypes.default.arrayOf(_propTypes.default.string),
  preformatted: _propTypes.default.bool,
  retry: _propTypes.default.func,
  logout: _propTypes.default.func
});

_defineProperty(ErrorView, "defaultProps", {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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