"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️',
  ROCKET: '🚀',
  EYES: '👀'
};

class EmojiReactionsView extends _react.default.Component {
  render() {
    return _react.default.createElement("div", {
      className: "github-IssueishDetailView-reactions"
    }, this.props.reactionGroups.map(group => {
      const emoji = reactionTypeToEmoji[group.content];

      if (!emoji) {
        return null;
      }

      return group.users.totalCount > 0 ? _react.default.createElement("span", {
        className: (0, _classnames.default)('github-IssueishDetailView-reactionsGroup', group.content.toLowerCase()),
        key: group.content
      }, reactionTypeToEmoji[group.content], " \xA0 ", group.users.totalCount) : null;
    }));
  }

}

exports.default = EmojiReactionsView;

_defineProperty(EmojiReactionsView, "propTypes", {
  reactionGroups: _propTypes.default.arrayOf(_propTypes.default.shape({
    content: _propTypes.default.string.isRequired,
    users: _propTypes.default.shape({
      totalCount: _propTypes.default.number.isRequired
    }).isRequired
  })).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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