"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CreatePullRequestTile extends _react.default.Component {
  render() {
    if (this.isRepositoryNotFound()) {
      return _react.default.createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, _react.default.createElement("strong", null, "Repository not found"), " for the remote ", _react.default.createElement("code", null, this.props.remote.getName()), ".", _react.default.createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react.default.createElement(_octicon.default, {
        icon: "link"
      }), "Do you need to update your ", _react.default.createElement("strong", null, "remote URL"), "?");
    }

    if (this.isDetachedHead()) {
      return _react.default.createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are not currently on ", _react.default.createElement("strong", null, "any branch"), ".", _react.default.createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react.default.createElement(_octicon.default, {
        icon: "git-branch"
      }), _react.default.createElement("strong", null, "Create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.hasNoDefaultRef()) {
      return _react.default.createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "The repository at remote ", _react.default.createElement("code", null, this.props.remote.getName()), " is ", _react.default.createElement("strong", null, "empty"), ".", _react.default.createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react.default.createElement(_octicon.default, {
        icon: "arrow-up"
      }), _react.default.createElement("strong", null, "Push a main branch"), " to begin sharing your work.");
    }

    if (this.isOnDefaultRef()) {
      return _react.default.createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are currently on your repository's ", _react.default.createElement("strong", null, "default branch"), ".", _react.default.createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react.default.createElement(_octicon.default, {
        icon: "git-branch"
      }), _react.default.createElement("strong", null, "Checkout or create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.isSameAsDefaultRef()) {
      return _react.default.createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "Your current branch ", _react.default.createElement("strong", null, "has not moved"), " from the repository's default branch.", _react.default.createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react.default.createElement(_octicon.default, {
        icon: "git-commit"
      }), _react.default.createElement("strong", null, "Make some commits"), "\xA0 to share your work with a pull request.");
    }

    let message = 'Open new pull request';
    let disable = false;
    const differentRemote = this.pushesToDifferentRemote();

    if (this.props.pushInProgress) {
      message = 'Pushing...';
      disable = true;
    } else if (!this.hasUpstreamBranch() || differentRemote) {
      message = 'Publish + open new pull request';
    } else if (this.props.aheadCount > 0) {
      message = 'Push + open new pull request';
    }

    return _react.default.createElement("div", null, differentRemote && _react.default.createElement("div", {
      className: "github-CreatePullRequestTile-message"
    }, "Your current branch is ", _react.default.createElement("strong", null, "configured"), " to push to the remote ", _react.default.createElement("code", null, this.props.branches.getHeadBranch().getPush().getRemoteName()), ".", _react.default.createElement("hr", {
      className: "github-CreatePullRequestTile-divider"
    }), _react.default.createElement(_octicon.default, {
      icon: "cloud-upload"
    }), _react.default.createElement("strong", null, "Publish"), " it to ", _react.default.createElement("code", null, this.props.remote.getName()), " instead?"), _react.default.createElement("div", {
      className: "github-CreatePullRequestTile-controls"
    }, _react.default.createElement("button", {
      className: "github-CreatePullRequestTile-createPr btn btn-primary",
      onClick: this.props.onCreatePr,
      disabled: disable
    }, message)));
  }

  isRepositoryNotFound() {
    return !this.props.repository;
  }

  isDetachedHead() {
    return !this.props.branches.getHeadBranch().isPresent();
  }

  hasNoDefaultRef() {
    return !this.props.repository.defaultBranchRef;
  }

  isOnDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    return currentBranch.getPush().getRemoteRef() === `${defaultRef.prefix}${defaultRef.name}`;
  }

  isSameAsDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    const mainBranches = this.props.branches.getPushSources(this.props.remote.getName(), `${defaultRef.prefix}${defaultRef.name}`);
    return mainBranches.some(branch => branch.getSha() === currentBranch.getSha());
  }

  pushesToDifferentRemote() {
    const p = this.props.branches.getHeadBranch().getPush();

    if (!p.isRemoteTracking()) {
      return false;
    }

    const pushRemoteName = p.getRemoteName();
    return pushRemoteName !== this.props.remote.getName();
  }

  hasUpstreamBranch() {
    return this.props.branches.getHeadBranch().getUpstream().isPresent();
  }

}

exports.default = CreatePullRequestTile;

_defineProperty(CreatePullRequestTile, "propTypes", {
  repository: _propTypes.default.shape({
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  remote: _propTypes2.RemotePropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  onCreatePr: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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