"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _reactSelect = _interopRequireDefault(require("react-select"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _coAuthorForm = _interopRequireDefault(require("./co-author-form"));

var _recentCommitsView = _interopRequireDefault(require("./recent-commits-view"));

var _stagingView = _interopRequireDefault(require("./staging-view"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _author = _interopRequireDefault(require("../models/author"));

var _observeModel = _interopRequireDefault(require("./observe-model"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const TOOLTIP_DELAY = 200; // CustomEvent is a DOM primitive, which v8 can't access
// so we're essentially lazy loading to keep snapshotting from breaking.

let FakeKeyDownEvent;

class CommitView extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'submitNewCoAuthor', 'cancelNewCoAuthor', 'didMoveCursor', 'toggleHardWrap', 'toggleCoAuthorInput', 'abortMerge', 'commit', 'amendLastCommit', 'toggleExpandedCommitMessageEditor', 'renderCoAuthorListItem', 'onSelectedCoAuthorsChanged', 'excludeCoAuthor');
    this.state = {
      showWorking: false,
      showCoAuthorInput: false,
      showCoAuthorForm: false,
      coAuthorInput: ''
    };
    this.timeoutHandle = null;
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.refRoot = new _refHolder.default();
    this.refCommitPreviewButton = new _refHolder.default();
    this.refExpandButton = new _refHolder.default();
    this.refCommitButton = new _refHolder.default();
    this.refHardWrapButton = new _refHolder.default();
    this.refAbortMergeButton = new _refHolder.default();
    this.refCoAuthorToggle = new _refHolder.default();
    this.refCoAuthorSelect = new _refHolder.default();
    this.refCoAuthorForm = new _refHolder.default();
    this.refEditorComponent = new _refHolder.default();
    this.refEditorModel = new _refHolder.default();
    this.subs = new _eventKit.CompositeDisposable();
  }

  proxyKeyCode(keyCode) {
    return e => {
      if (this.refCoAuthorSelect.isEmpty()) {
        return;
      }

      if (!FakeKeyDownEvent) {
        FakeKeyDownEvent = class extends CustomEvent {
          constructor(kCode) {
            super('keydown');
            this.keyCode = kCode;
          }

        };
      }

      const fakeEvent = new FakeKeyDownEvent(keyCode);
      this.refCoAuthorSelect.get().handleKeyDown(fakeEvent);

      if (!fakeEvent.defaultPrevented) {
        e.abortKeyBinding();
      }
    };
  } // eslint-disable-next-line camelcase


  UNSAFE_componentWillMount() {
    this.scheduleShowWorking(this.props);
    this.subs.add(this.props.config.onDidChange('github.automaticCommitMessageWrapping', () => this.forceUpdate()), this.props.messageBuffer.onDidChange(() => this.forceUpdate()));
  }

  render() {
    let remainingCharsClassName = '';
    const remainingCharacters = parseInt(this.getRemainingCharacters(), 10);

    if (remainingCharacters < 0) {
      remainingCharsClassName = 'is-error';
    } else if (remainingCharacters < this.props.maximumCharacterLimit / 4) {
      remainingCharsClassName = 'is-warning';
    }

    const showAbortMergeButton = this.props.isMerging || null;
    /* istanbul ignore next */

    const modKey = process.platform === 'darwin' ? 'Cmd' : 'Ctrl';
    return _react.default.createElement("div", {
      className: "github-CommitView",
      ref: this.refRoot.setter
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: "atom-workspace"
    }, _react.default.createElement(_commands.Command, {
      command: "github:commit",
      callback: this.commit
    }), _react.default.createElement(_commands.Command, {
      command: "github:amend-last-commit",
      callback: this.amendLastCommit
    }), _react.default.createElement(_commands.Command, {
      command: "github:toggle-expanded-commit-message-editor",
      callback: this.toggleExpandedCommitMessageEditor
    })), _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-CommitView-coAuthorEditor"
    }, _react.default.createElement(_commands.Command, {
      command: "github:co-author:down",
      callback: this.proxyKeyCode(40)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:up",
      callback: this.proxyKeyCode(38)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:enter",
      callback: this.proxyKeyCode(13)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:tab",
      callback: this.proxyKeyCode(9)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:backspace",
      callback: this.proxyKeyCode(8)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:pageup",
      callback: this.proxyKeyCode(33)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:pagedown",
      callback: this.proxyKeyCode(34)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:end",
      callback: this.proxyKeyCode(35)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:home",
      callback: this.proxyKeyCode(36)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:delete",
      callback: this.proxyKeyCode(46)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author:escape",
      callback: this.proxyKeyCode(27)
    }), _react.default.createElement(_commands.Command, {
      command: "github:co-author-exclude",
      callback: this.excludeCoAuthor
    })), _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-CommitView-commitPreview"
    }, _react.default.createElement(_commands.Command, {
      command: "github:dive",
      callback: this.props.activateCommitPreview
    })), _react.default.createElement("div", {
      className: "github-CommitView-buttonWrapper"
    }, _react.default.createElement("button", {
      ref: this.refCommitPreviewButton.setter,
      className: "github-CommitView-commitPreview github-CommitView-button btn",
      disabled: !this.props.stagedChangesExist,
      onClick: this.props.toggleCommitPreview
    }, this.props.commitPreviewActive ? 'Hide All Staged Changes' : 'See All Staged Changes')), _react.default.createElement("div", {
      className: (0, _classnames.default)('github-CommitView-editor', {
        'is-expanded': this.props.deactivateCommitBox
      })
    }, _react.default.createElement(_atomTextEditor.default, {
      ref: this.refEditorComponent.setter,
      refModel: this.refEditorModel,
      softWrapped: true,
      placeholderText: "Commit message",
      lineNumberGutterVisible: false,
      showInvisibles: false,
      autoHeight: false,
      scrollPastEnd: false,
      buffer: this.props.messageBuffer,
      workspace: this.props.workspace,
      didChangeCursorPosition: this.didMoveCursor
    }), _react.default.createElement("button", {
      ref: this.refCoAuthorToggle.setter,
      className: (0, _classnames.default)('github-CommitView-coAuthorToggle', {
        focused: this.state.showCoAuthorInput
      }),
      onClick: this.toggleCoAuthorInput
    }, this.renderCoAuthorToggleIcon()), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refCoAuthorToggle,
      title: `${this.state.showCoAuthorInput ? 'Remove' : 'Add'} co-authors`,
      showDelay: TOOLTIP_DELAY
    }), _react.default.createElement("button", {
      ref: this.refHardWrapButton.setter,
      onClick: this.toggleHardWrap,
      className: "github-CommitView-hardwrap hard-wrap-icons"
    }, this.renderHardWrapIcon()), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refHardWrapButton,
      className: "github-CommitView-hardwrap-tooltip",
      title: "Toggle hard wrap on commit",
      showDelay: TOOLTIP_DELAY
    }), _react.default.createElement("button", {
      ref: this.refExpandButton.setter,
      className: "github-CommitView-expandButton icon icon-screen-full",
      onClick: this.toggleExpandedCommitMessageEditor
    }), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refExpandButton,
      className: "github-CommitView-expandButton-tooltip",
      title: "Expand commit message editor",
      showDelay: TOOLTIP_DELAY
    })), this.renderCoAuthorForm(), this.renderCoAuthorInput(), _react.default.createElement("footer", {
      className: "github-CommitView-bar"
    }, showAbortMergeButton && _react.default.createElement("button", {
      ref: this.refAbortMergeButton.setter,
      className: "btn github-CommitView-button github-CommitView-abortMerge is-secondary",
      onClick: this.abortMerge
    }, "Abort Merge"), _react.default.createElement("button", {
      ref: this.refCommitButton.setter,
      className: "github-CommitView-button github-CommitView-commit btn btn-primary native-key-bindings",
      onClick: this.commit,
      disabled: !this.commitIsEnabled(false)
    }, this.commitButtonText()), this.commitIsEnabled(false) && _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refCommitButton,
      className: "github-CommitView-button-tooltip",
      title: `${modKey}-enter to commit`,
      showDelay: TOOLTIP_DELAY
    }), _react.default.createElement("div", {
      className: `github-CommitView-remaining-characters ${remainingCharsClassName}`
    }, this.getRemainingCharacters())));
  }

  renderCoAuthorToggleIcon() {
    /* eslint-disable max-len */
    const svgPath = 'M9.875 2.125H12v1.75H9.875V6h-1.75V3.875H6v-1.75h2.125V0h1.75v2.125zM6 6.5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5V6c0-1.316 2-2 2-2s.114-.204 0-.5c-.42-.31-.472-.795-.5-2C1.587.293 2.434 0 3 0s1.413.293 1.5 1.5c-.028 1.205-.08 1.69-.5 2-.114.295 0 .5 0 .5s2 .684 2 2v.5z';
    return _react.default.createElement("svg", {
      className: (0, _classnames.default)('github-CommitView-coAuthorToggleIcon', {
        focused: this.state.showCoAuthorInput
      }),
      viewBox: "0 0 12 7",
      xmlns: "http://www.w3.org/2000/svg"
    }, _react.default.createElement("title", null, "Add or remove co-authors"), _react.default.createElement("path", {
      d: svgPath
    }));
  }

  renderCoAuthorInput() {
    if (!this.state.showCoAuthorInput) {
      return null;
    }

    return _react.default.createElement(_observeModel.default, {
      model: this.props.userStore,
      fetchData: store => store.getUsers()
    }, mentionableUsers => _react.default.createElement(_reactSelect.default, {
      ref: this.refCoAuthorSelect.setter,
      className: "github-CommitView-coAuthorEditor input-textarea native-key-bindings",
      placeholder: "Co-Authors",
      arrowRenderer: null,
      options: mentionableUsers,
      labelKey: "fullName",
      valueKey: "email",
      filterOptions: this.matchAuthors,
      optionRenderer: this.renderCoAuthorListItem,
      valueRenderer: this.renderCoAuthorValue,
      onChange: this.onSelectedCoAuthorsChanged,
      value: this.props.selectedCoAuthors,
      multi: true,
      openOnClick: false,
      openOnFocus: false,
      tabIndex: "5"
    }));
  }

  renderHardWrapIcon() {
    const singleLineMessage = this.props.messageBuffer.getText().split(_helpers.LINE_ENDING_REGEX).length === 1;
    const hardWrap = this.props.config.get('github.automaticCommitMessageWrapping');
    const notApplicable = this.props.deactivateCommitBox || singleLineMessage;
    /* eslint-disable max-len */

    const svgPaths = {
      hardWrapEnabled: {
        path1: 'M7.058 10.2h-.975v2.4L2 9l4.083-3.6v2.4h.97l1.202 1.203L7.058 10.2zm2.525-4.865V4.2h2.334v1.14l-1.164 1.165-1.17-1.17z',
        // eslint-disable-line max-len
        path2: 'M7.842 6.94l2.063 2.063-2.122 2.12.908.91 2.123-2.123 1.98 1.98.85-.848L11.58 8.98l2.12-2.123-.824-.825-2.122 2.12-2.062-2.06z' // eslint-disable-line max-len

      },
      hardWrapDisabled: {
        path1: 'M11.917 8.4c0 .99-.788 1.8-1.75 1.8H6.083v2.4L2 9l4.083-3.6v2.4h3.5V4.2h2.334v4.2z'
      }
    };
    /* eslint-enable max-line */

    if (notApplicable) {
      return null;
    }

    if (hardWrap) {
      return _react.default.createElement("div", {
        className: (0, _classnames.default)('icon', 'hardwrap', 'icon-hardwrap-enabled', {
          hidden: notApplicable || !hardWrap
        })
      }, _react.default.createElement("svg", {
        width: "16",
        height: "16",
        viewBox: "0 0 16 16",
        xmlns: "http://www.w3.org/2000/svg"
      }, _react.default.createElement("path", {
        d: svgPaths.hardWrapDisabled.path1,
        fillRule: "evenodd"
      })));
    } else {
      return _react.default.createElement("div", {
        className: (0, _classnames.default)('icon', 'no-hardwrap', 'icon-hardwrap-disabled', {
          hidden: notApplicable || hardWrap
        })
      }, _react.default.createElement("svg", {
        width: "16",
        height: "16",
        viewBox: "0 0 16 16",
        xmlns: "http://www.w3.org/2000/svg"
      }, _react.default.createElement("g", {
        fillRule: "evenodd"
      }, _react.default.createElement("path", {
        d: svgPaths.hardWrapEnabled.path1
      }), _react.default.createElement("path", {
        fillRule: "nonzero",
        d: svgPaths.hardWrapEnabled.path2
      }))));
    }
  }

  renderCoAuthorForm() {
    if (!this.state.showCoAuthorForm) {
      return null;
    }

    return _react.default.createElement(_coAuthorForm.default, {
      ref: this.refCoAuthorForm.setter,
      commandRegistry: this.props.commandRegistry,
      onSubmit: this.submitNewCoAuthor,
      onCancel: this.cancelNewCoAuthor,
      name: this.state.coAuthorInput
    });
  }

  submitNewCoAuthor(newAuthor) {
    this.props.updateSelectedCoAuthors(this.props.selectedCoAuthors, newAuthor);
    this.hideNewAuthorForm();
  }

  cancelNewCoAuthor() {
    this.hideNewAuthorForm();
  }

  hideNewAuthorForm() {
    this.setState({
      showCoAuthorForm: false
    }, () => {
      this.refCoAuthorSelect.map(c => c.focus());
    });
  } // eslint-disable-next-line camelcase


  UNSAFE_componentWillReceiveProps(nextProps) {
    this.scheduleShowWorking(nextProps);
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  didMoveCursor() {
    this.forceUpdate();
  }

  toggleHardWrap() {
    const currentSetting = this.props.config.get('github.automaticCommitMessageWrapping');
    this.props.config.set('github.automaticCommitMessageWrapping', !currentSetting);
  }

  toggleCoAuthorInput() {
    this.setState({
      showCoAuthorInput: !this.state.showCoAuthorInput
    }, () => {
      if (this.state.showCoAuthorInput) {
        (0, _reporterProxy.incrementCounter)('show-co-author-input');
        this.refCoAuthorSelect.map(c => c.focus());
      } else {
        // if input is closed, remove all co-authors
        this.props.updateSelectedCoAuthors([]);
        (0, _reporterProxy.incrementCounter)('hide-co-author-input');
      }
    });
  }

  excludeCoAuthor() {
    const author = this.refCoAuthorSelect.map(c => c.getFocusedOption()).getOr(null);

    if (!author || author.isNew()) {
      return;
    }

    let excluded = this.props.config.get('github.excludedUsers');

    if (excluded && excluded !== '') {
      excluded += ', ';
    }

    excluded += author.getEmail();
    this.props.config.set('github.excludedUsers', excluded);
  }

  abortMerge() {
    this.props.abortMerge();
  }

  async commit(event, amend) {
    if ((await this.props.prepareToCommit()) && this.commitIsEnabled(amend)) {
      try {
        await this.props.commit(this.props.messageBuffer.getText(), this.props.selectedCoAuthors, amend);
      } catch (e) {
        // do nothing - error was taken care of in pipeline manager
        if (!atom.isReleasedVersion()) {
          throw e;
        }
      }
    } else {
      this.setFocus(CommitView.focus.EDITOR);
    }
  }

  amendLastCommit() {
    (0, _reporterProxy.incrementCounter)('amend');
    this.commit(null, true);
  }

  getRemainingCharacters() {
    return this.refEditorModel.map(editor => {
      if (editor.getCursorBufferPosition().row === 0) {
        return (this.props.maximumCharacterLimit - editor.lineTextForBufferRow(0).length).toString();
      } else {
        return '∞';
      }
    }).getOr(this.props.maximumCharacterLimit || '');
  } // We don't want the user to see the UI flicker in the case
  // the commit takes a very small time to complete. Instead we
  // will only show the working message if we are working for longer
  // than 1 second as per https://www.nngroup.com/articles/response-times-3-important-limits/
  //
  // The closure is created to restrict variable access


  scheduleShowWorking(props) {
    if (props.isCommitting) {
      if (!this.state.showWorking && this.timeoutHandle === null) {
        this.timeoutHandle = setTimeout(() => {
          this.timeoutHandle = null;
          this.setState({
            showWorking: true
          });
        }, 1000);
      }
    } else {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
      this.setState({
        showWorking: false
      });
    }
  }

  isValidMessage() {
    // ensure that there are at least some non-comment lines in the commit message.
    // Commented lines are stripped out of commit messages by git, by default configuration.
    return this.props.messageBuffer.getText().replace(/^#.*$/gm, '').trim().length !== 0;
  }

  commitIsEnabled(amend) {
    return !this.props.isCommitting && (amend || this.props.stagedChangesExist) && !this.props.mergeConflictsExist && this.props.lastCommit.isPresent() && (this.props.deactivateCommitBox || amend || this.isValidMessage());
  }

  commitButtonText() {
    if (this.state.showWorking) {
      return 'Working...';
    } else if (this.props.currentBranch.isDetached()) {
      return 'Create detached commit';
    } else if (this.props.currentBranch.isPresent()) {
      return `Commit to ${this.props.currentBranch.getName()}`;
    } else {
      return 'Commit';
    }
  }

  toggleExpandedCommitMessageEditor() {
    return this.props.toggleExpandedCommitMessageEditor(this.props.messageBuffer.getText());
  }

  matchAuthors(authors, filterText, selectedAuthors) {
    const matchedAuthors = authors.filter((author, index) => {
      const isAlreadySelected = selectedAuthors && selectedAuthors.find(selected => selected.matches(author));
      const matchesFilter = [author.getLogin(), author.getFullName(), author.getEmail()].some(field => field && field.toLowerCase().indexOf(filterText.toLowerCase()) !== -1);
      return !isAlreadySelected && matchesFilter;
    });
    matchedAuthors.push(_author.default.createNew('Add new author', filterText));
    return matchedAuthors;
  }

  renderCoAuthorListItemField(fieldName, value) {
    if (!value || value.length === 0) {
      return null;
    }

    return _react.default.createElement("span", {
      className: `github-CommitView-coAuthorEditor-${fieldName}`
    }, value);
  }

  renderCoAuthorListItem(author) {
    return _react.default.createElement("div", {
      className: (0, _classnames.default)('github-CommitView-coAuthorEditor-selectListItem', {
        'new-author': author.isNew()
      })
    }, this.renderCoAuthorListItemField('name', author.getFullName()), author.hasLogin() && this.renderCoAuthorListItemField('login', '@' + author.getLogin()), this.renderCoAuthorListItemField('email', author.getEmail()));
  }

  renderCoAuthorValue(author) {
    const fullName = author.getFullName();

    if (fullName && fullName.length > 0) {
      return _react.default.createElement("span", null, author.getFullName());
    }

    if (author.hasLogin()) {
      return _react.default.createElement("span", null, "@", author.getLogin());
    }

    return _react.default.createElement("span", null, author.getEmail());
  }

  onSelectedCoAuthorsChanged(selectedCoAuthors) {
    (0, _reporterProxy.incrementCounter)('selected-co-authors-changed');
    const newAuthor = selectedCoAuthors.find(author => author.isNew());

    if (newAuthor) {
      this.setState({
        coAuthorInput: newAuthor.getFullName(),
        showCoAuthorForm: true
      });
    } else {
      this.props.updateSelectedCoAuthors(selectedCoAuthors);
    }
  }

  hasFocus() {
    return this.refRoot.map(element => element.contains(document.activeElement)).getOr(false);
  }

  getFocus(element) {
    if (this.refCommitPreviewButton.map(button => button.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_PREVIEW_BUTTON;
    }

    if (this.refEditorComponent.map(editor => editor.contains(element)).getOr(false)) {
      return CommitView.focus.EDITOR;
    }

    if (this.refAbortMergeButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.ABORT_MERGE_BUTTON;
    }

    if (this.refCommitButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_BUTTON;
    }

    if (this.refCoAuthorSelect.map(c => c.wrapper && c.wrapper.contains(element)).getOr(false)) {
      return CommitView.focus.COAUTHOR_INPUT;
    }

    return null;
  }

  setFocus(focus) {
    let fallback = false;

    const focusElement = element => {
      element.focus();
      return true;
    };

    if (focus === CommitView.focus.COMMIT_PREVIEW_BUTTON) {
      if (this.refCommitPreviewButton.map(focusElement).getOr(false)) {
        return true;
      }
    }

    if (focus === CommitView.focus.EDITOR) {
      if (this.refEditorComponent.map(focusElement).getOr(false)) {
        if (this.props.messageBuffer.getText().length > 0 && !this.isValidMessage()) {
          // there is likely a commit message template present
          // we want the cursor to be at the beginning, not at the and of the template
          this.refEditorComponent.get().getModel().setCursorBufferPosition([0, 0]);
        }

        return true;
      }
    }

    if (focus === CommitView.focus.ABORT_MERGE_BUTTON) {
      if (this.refAbortMergeButton.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.focus.COMMIT_BUTTON) {
      if (this.refCommitButton.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.focus.COAUTHOR_INPUT) {
      if (this.refCoAuthorSelect.map(focusElement).getOr(false)) {
        return true;
      }

      fallback = true;
    }

    if (focus === CommitView.lastFocus) {
      if (this.commitIsEnabled(false)) {
        return this.setFocus(CommitView.focus.COMMIT_BUTTON);
      } else if (this.props.isMerging) {
        return this.setFocus(CommitView.focus.ABORT_MERGE_BUTTON);
      } else if (this.state.showCoAuthorInput) {
        return this.setFocus(CommitView.focus.COAUTHOR_INPUT);
      } else {
        return this.setFocus(CommitView.focus.EDITOR);
      }
    }

    if (fallback && this.refEditorComponent.map(focusElement).getOr(false)) {
      return true;
    }

    return false;
  }

  advanceFocusFrom(focus) {
    const f = this.constructor.focus;
    let next = null;

    switch (focus) {
      case f.COMMIT_PREVIEW_BUTTON:
        next = f.EDITOR;
        break;

      case f.EDITOR:
        if (this.state.showCoAuthorInput) {
          next = f.COAUTHOR_INPUT;
        } else if (this.props.isMerging) {
          next = f.ABORT_MERGE_BUTTON;
        } else if (this.commitIsEnabled(false)) {
          next = f.COMMIT_BUTTON;
        } else {
          next = _recentCommitsView.default.firstFocus;
        }

        break;

      case f.COAUTHOR_INPUT:
        if (this.props.isMerging) {
          next = f.ABORT_MERGE_BUTTON;
        } else if (this.commitIsEnabled(false)) {
          next = f.COMMIT_BUTTON;
        } else {
          next = _recentCommitsView.default.firstFocus;
        }

        break;

      case f.ABORT_MERGE_BUTTON:
        next = this.commitIsEnabled(false) ? f.COMMIT_BUTTON : _recentCommitsView.default.firstFocus;
        break;

      case f.COMMIT_BUTTON:
        next = _recentCommitsView.default.firstFocus;
        break;
    }

    return Promise.resolve(next);
  }

  retreatFocusFrom(focus) {
    const f = this.constructor.focus;
    let previous = null;

    switch (focus) {
      case f.COMMIT_BUTTON:
        if (this.props.isMerging) {
          previous = f.ABORT_MERGE_BUTTON;
        } else if (this.state.showCoAuthorInput) {
          previous = f.COAUTHOR_INPUT;
        } else {
          previous = f.EDITOR;
        }

        break;

      case f.ABORT_MERGE_BUTTON:
        previous = this.state.showCoAuthorInput ? f.COAUTHOR_INPUT : f.EDITOR;
        break;

      case f.COAUTHOR_INPUT:
        previous = f.EDITOR;
        break;

      case f.EDITOR:
        previous = f.COMMIT_PREVIEW_BUTTON;
        break;

      case f.COMMIT_PREVIEW_BUTTON:
        previous = _stagingView.default.lastFocus;
        break;
    }

    return Promise.resolve(previous);
  }

}

exports.default = CommitView;

_defineProperty(CommitView, "focus", {
  COMMIT_PREVIEW_BUTTON: Symbol('commit-preview-button'),
  EDITOR: Symbol('commit-editor'),
  COAUTHOR_INPUT: Symbol('coauthor-input'),
  ABORT_MERGE_BUTTON: Symbol('commit-abort-merge-button'),
  COMMIT_BUTTON: Symbol('commit-button')
});

_defineProperty(CommitView, "firstFocus", CommitView.focus.COMMIT_PREVIEW_BUTTON);

_defineProperty(CommitView, "lastFocus", Symbol('last-focus'));

_defineProperty(CommitView, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired,
  lastCommit: _propTypes.default.object.isRequired,
  currentBranch: _propTypes.default.object.isRequired,
  isMerging: _propTypes.default.bool.isRequired,
  mergeConflictsExist: _propTypes.default.bool.isRequired,
  stagedChangesExist: _propTypes.default.bool.isRequired,
  isCommitting: _propTypes.default.bool.isRequired,
  commitPreviewActive: _propTypes.default.bool.isRequired,
  deactivateCommitBox: _propTypes.default.bool.isRequired,
  maximumCharacterLimit: _propTypes.default.number.isRequired,
  messageBuffer: _propTypes.default.object.isRequired,
  // FIXME more specific proptype
  userStore: _propTypes2.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes.default.arrayOf(_propTypes2.AuthorPropType),
  updateSelectedCoAuthors: _propTypes.default.func,
  commit: _propTypes.default.func.isRequired,
  abortMerge: _propTypes.default.func.isRequired,
  prepareToCommit: _propTypes.default.func.isRequired,
  toggleExpandedCommitMessageEditor: _propTypes.default.func.isRequired,
  toggleCommitPreview: _propTypes.default.func.isRequired,
  activateCommitPreview: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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