"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _url = _interopRequireDefault(require("url"));

var _path = _interopRequireDefault(require("path"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CloneDialog extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'clone', 'cancel', 'didChangeRemoteUrl', 'didChangeProjectPath', 'editorRefs');
    this.state = {
      cloneDisabled: false
    };
    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.remoteUrlElement) {
      setTimeout(() => this.remoteUrlElement.focus());
    }
  }

  render() {
    if (!this.props.inProgress) {
      return this.renderDialog();
    } else {
      return this.renderSpinner();
    }
  }

  renderDialog() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-Clone modal"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: ".github-Clone"
    }, _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.clone
    })), _react.default.createElement("main", {
      className: "github-DialogInputs"
    }, _react.default.createElement("label", {
      className: "github-DialogLabel github-CloneUrl"
    }, "Clone from", _react.default.createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('remoteUrl'),
      tabIndex: "1"
    })), _react.default.createElement("label", {
      className: "github-DialogLabel github-ProjectPath"
    }, "To directory", _react.default.createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('projectPath'),
      tabIndex: "2"
    }))), _react.default.createElement("div", {
      className: "github-DialogButtons"
    }, _react.default.createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react.default.createElement("button", {
      className: "btn btn-primary icon icon-repo-clone",
      onClick: this.clone,
      disabled: this.state.cloneDisabled,
      tabIndex: "4"
    }, "Clone")));
  }

  renderSpinner() {
    return _react.default.createElement("div", {
      className: "github-Dialog github-Clone modal"
    }, _react.default.createElement("main", {
      className: "github-DialogSpinner"
    }, _react.default.createElement("span", {
      className: "loading loading-spinner-small inline-block"
    }), _react.default.createElement("span", {
      className: "github-DialogMessage inline-block"
    }, "Cloning ", _react.default.createElement("strong", null, this.getRemoteUrl()))));
  }

  clone() {
    if (this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getRemoteUrl(), this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  didChangeRemoteUrl() {
    if (!this.projectPathModified) {
      const name = _path.default.basename(_url.default.parse(this.getRemoteUrl()).pathname, '.git') || '';

      if (name.length > 0) {
        const proposedPath = _path.default.join(this.projectHome, name);

        this.projectPathEditor.setText(proposedPath);
        this.projectPathModified = false;
      }
    }

    this.setCloneEnablement();
  }

  didChangeProjectPath() {
    this.projectPathModified = true;
    this.setCloneEnablement();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();

      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setCloneEnablement() {
    const disabled = this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0;
    this.setState({
      cloneDisabled: disabled
    });
  }

}

exports.default = CloneDialog;

_defineProperty(CloneDialog, "propTypes", {
  config: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired,
  inProgress: _propTypes.default.bool,
  didAccept: _propTypes.default.func,
  didCancel: _propTypes.default.func
});

_defineProperty(CloneDialog, "defaultProps", {
  inProgress: false,
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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