"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
class Empty extends _state.default {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }

}

exports.default = Empty;

_state.default.register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiU3RhdGUiLCJpc0VtcHR5IiwiaW5pdCIsInRyYW5zaXRpb25UbyIsImNsb25lIiwicmVtb3RlVXJsIiwic2hvd0dpdFRhYkluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLEtBQU4sU0FBb0JDLGNBQXBCLENBQTBCO0FBQ3ZDQyxFQUFBQSxPQUFPLEdBQUc7QUFDUixXQUFPLElBQVA7QUFDRDs7QUFFREMsRUFBQUEsSUFBSSxHQUFHO0FBQ0wsV0FBTyxLQUFLQyxZQUFMLENBQWtCLGNBQWxCLENBQVA7QUFDRDs7QUFFREMsRUFBQUEsS0FBSyxDQUFDQyxTQUFELEVBQVk7QUFDZixXQUFPLEtBQUtGLFlBQUwsQ0FBa0IsU0FBbEIsRUFBNkJFLFNBQTdCLENBQVA7QUFDRDs7QUFFREMsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBZnNDOzs7O0FBa0J6Q04sZUFBTU8sUUFBTixDQUFlUixLQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogVGhlIHdvcmtpbmcgZGlyZWN0b3J5IGV4aXN0cywgYnV0IGNvbnRhaW5zIG5vIGdpdCByZXBvc2l0b3J5IHlldC5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRW1wdHkgZXh0ZW5kcyBTdGF0ZSB7XG4gIGlzRW1wdHkoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBpbml0KCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25UbygnSW5pdGlhbGl6aW5nJyk7XG4gIH1cblxuICBjbG9uZShyZW1vdGVVcmwpIHtcbiAgICByZXR1cm4gdGhpcy50cmFuc2l0aW9uVG8oJ0Nsb25pbmcnLCByZW1vdGVVcmwpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoRW1wdHkpO1xuIl19