"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullAuthor = exports.default = exports.NO_REPLY_GITHUB_EMAIL = void 0;
const NEW = Symbol('new');
const NO_REPLY_GITHUB_EMAIL = 'noreply@github.com';
exports.NO_REPLY_GITHUB_EMAIL = NO_REPLY_GITHUB_EMAIL;

class Author {
  constructor(email, fullName, login = null, isNew = null) {
    this.email = email;
    this.fullName = fullName;
    this.login = login;
    this.new = isNew === NEW;
  }

  static createNew(email, fullName) {
    return new this(email, fullName, null, NEW);
  }

  getEmail() {
    return this.email;
  }

  getFullName() {
    return this.fullName;
  }

  getLogin() {
    return this.login;
  }

  isNoReply() {
    return this.email === NO_REPLY_GITHUB_EMAIL;
  }

  hasLogin() {
    return this.login !== null;
  }

  isNew() {
    return this.new;
  }

  isPresent() {
    return true;
  }

  matches(other) {
    return this.getEmail() === other.getEmail();
  }

  toString() {
    let s = `${this.fullName} <${this.email}>`;

    if (this.hasLogin()) {
      s += ` @${this.login}`;
    }

    return s;
  }

  static compare(a, b) {
    if (a.getFullName() < b.getFullName()) {
      return -1;
    }

    if (a.getFullName() > b.getFullName()) {
      return 1;
    }

    return 0;
  }

}

exports.default = Author;
const nullAuthor = {
  getEmail() {
    return '';
  },

  getFullName() {
    return '';
  },

  getLogin() {
    return null;
  },

  isNoReply() {
    return false;
  },

  hasLogin() {
    return false;
  },

  isNew() {
    return false;
  },

  isPresent() {
    return false;
  },

  matches(other) {
    return other === this;
  },

  toString() {
    return 'null author';
  }

};
exports.nullAuthor = nullAuthor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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