"use strict";

var _githubPackage = _interopRequireDefault(require("./github-package"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage.default({
      workspace: atom.workspace,
      project: atom.project,
      commandRegistry: atom.commands,
      notificationManager: atom.notifications,
      tooltips: atom.tooltips,
      styles: atom.styles,
      keymaps: atom.keymaps,
      grammars: atom.grammars,
      config: atom.config,
      deserializers: atom.deserializers,
      confirm: atom.confirm.bind(atom),
      getLoadSettings: atom.getLoadSettings.bind(atom),
      configDirPath: atom.getConfigDirPath()
    });
  }

};
module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];

      if (typeof item === 'function') {
        item = item.bind(pack);
      }

      return item;
    } else {
      return target[name];
    }
  }

});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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