(function() {
  var COMPLETIONS, cssDocsURL, firstCharsEqual, firstInlinePropertyNameWithColonPattern, hasScope, importantPrefixPattern, inlinePropertyNameWithColonPattern, lineEndsWithSemicolon, propertyNamePrefixPattern, propertyNameWithColonPattern, pseudoSelectorPrefixPattern, tagSelectorPrefixPattern;

  COMPLETIONS = require('../completions.json');

  firstInlinePropertyNameWithColonPattern = /{\s*(\S+)\s*:/;

  inlinePropertyNameWithColonPattern = /(?:;.+?)*;\s*(\S+)\s*:/;

  propertyNameWithColonPattern = /^\s*(\S+)\s*:/;

  propertyNamePrefixPattern = /[a-zA-Z]+[-a-zA-Z]*$/;

  pseudoSelectorPrefixPattern = /:(:)?([a-z]+[a-z-]*)?$/;

  tagSelectorPrefixPattern = /(^|\s|,)([a-z]+)?$/;

  importantPrefixPattern = /(![a-z]+)$/;

  cssDocsURL = "https://developer.mozilla.org/en-US/docs/Web/CSS";

  module.exports = {
    selector: '.source.css, .source.sass, .source.css.postcss',
    disableForSelector: '.source.css .comment, .source.css .string, .source.sass .comment, .source.sass .string, .source.css.postcss .comment, source.css.postcss .string',
    properties: COMPLETIONS.properties,
    pseudoSelectors: COMPLETIONS.pseudoSelectors,
    tags: COMPLETIONS.tags,
    filterSuggestions: true,
    getSuggestions: function(request) {
      var completions, isSass, scopes, tagCompletions;
      completions = null;
      scopes = request.scopeDescriptor.getScopesArray();
      isSass = hasScope(scopes, 'source.sass', true);
      if (this.isCompletingValue(request)) {
        completions = this.getPropertyValueCompletions(request);
      } else if (this.isCompletingPseudoSelector(request)) {
        completions = this.getPseudoSelectorCompletions(request);
      } else {
        if (isSass && this.isCompletingNameOrTag(request)) {
          completions = this.getPropertyNameCompletions(request).concat(this.getTagCompletions(request));
        } else if (!isSass && this.isCompletingName(request)) {
          completions = this.getPropertyNameCompletions(request);
        }
      }
      if (!isSass && this.isCompletingTagSelector(request)) {
        tagCompletions = this.getTagCompletions(request);
        if (tagCompletions != null ? tagCompletions.length : void 0) {
          if (completions == null) {
            completions = [];
          }
          completions = completions.concat(tagCompletions);
        }
      }
      return completions;
    },
    onDidInsertSuggestion: function(arg) {
      var editor, suggestion;
      editor = arg.editor, suggestion = arg.suggestion;
      if (suggestion.type === 'property') {
        return setTimeout(this.triggerAutocomplete.bind(this, editor), 1);
      }
    },
    triggerAutocomplete: function(editor) {
      return atom.commands.dispatch(atom.views.getView(editor), 'autocomplete-plus:activate', {
        activatedManually: false
      });
    },
    isCompletingValue: function(arg) {
      var beforePrefixBufferPosition, beforePrefixScopes, beforePrefixScopesArray, bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      beforePrefixBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      beforePrefixScopes = editor.scopeDescriptorForBufferPosition(beforePrefixBufferPosition);
      beforePrefixScopesArray = beforePrefixScopes.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      return (hasScope(scopes, 'meta.property-list.css') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.css')) || (hasScope(scopes, 'meta.property-list.scss') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.scss')) || (hasScope(scopes, 'meta.property-list.postcss') && prefix.trim() === ":") || (hasScope(previousScopesArray, 'meta.property-value.postcss')) || (hasScope(scopes, 'source.sass', true) && (hasScope(scopes, 'meta.property-value.sass') || (!hasScope(beforePrefixScopesArray, 'entity.name.tag.css') && prefix.trim() === ":")));
    },
    isCompletingName: function(arg) {
      var bufferPosition, editor, isAtBeginScopePunctuation, isAtEndScopePunctuation, isAtParentSymbol, isAtTerminator, isInPropertyList, isVariable, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, prefix = arg.prefix, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      isAtTerminator = prefix.endsWith(';');
      isAtParentSymbol = prefix.endsWith('&');
      isVariable = hasScope(scopes, 'variable.css') || hasScope(scopes, 'variable.scss') || hasScope(scopes, 'variable.var.postcss');
      isInPropertyList = !isAtTerminator && (hasScope(scopes, 'meta.property-list.css') || hasScope(scopes, 'meta.property-list.scss') || hasScope(scopes, 'meta.property-list.postcss'));
      if (!isInPropertyList) {
        return false;
      }
      if (isAtParentSymbol || isVariable) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(previousScopesArray, 'entity.other.attribute-name.class.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id.css') || hasScope(previousScopesArray, 'entity.other.attribute-name.id') || hasScope(previousScopesArray, 'entity.other.attribute-name.parent-selector.css') || hasScope(previousScopesArray, 'entity.name.tag.reference.scss') || hasScope(previousScopesArray, 'entity.name.tag.scss') || hasScope(previousScopesArray, 'entity.name.tag.reference.postcss') || hasScope(previousScopesArray, 'entity.name.tag.postcss')) {
        return false;
      }
      isAtBeginScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.begin.bracket.curly.scss') || hasScope(scopes, 'punctuation.section.property-list.begin.postcss');
      isAtEndScopePunctuation = hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.css') || hasScope(scopes, 'punctuation.section.property-list.end.bracket.curly.scss') || hasScope(scopes, 'punctuation.section.property-list.end.postcss');
      if (isAtBeginScopePunctuation) {
        return prefix.endsWith('{');
      } else if (isAtEndScopePunctuation) {
        return !prefix.endsWith('}');
      } else {
        return true;
      }
    },
    isCompletingNameOrTag: function(arg) {
      var bufferPosition, editor, prefix, scopeDescriptor, scopes;
      scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition, editor = arg.editor;
      scopes = scopeDescriptor.getScopesArray();
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      return this.isPropertyNamePrefix(prefix) && hasScope(scopes, 'meta.selector.css') && !hasScope(scopes, 'entity.other.attribute-name.id.css.sass') && !hasScope(scopes, 'entity.other.attribute-name.class.sass');
    },
    isCompletingTagSelector: function(arg) {
      var bufferPosition, editor, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes, tagSelectorPrefix;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      tagSelectorPrefix = this.getTagSelectorPrefix(editor, bufferPosition);
      if (!(tagSelectorPrefix != null ? tagSelectorPrefix.length : void 0)) {
        return false;
      }
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if (hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss', true) || hasScope(scopes, 'source.css.less', true) || hasScope(scopes, 'source.css.postcss', true)) {
        return !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'meta.property-value.css') && !hasScope(previousScopesArray, 'meta.property-value.postcss') && !hasScope(previousScopesArray, 'support.type.property-value.css');
      } else {
        return false;
      }
    },
    isCompletingPseudoSelector: function(arg) {
      var bufferPosition, editor, prefix, previousBufferPosition, previousScopes, previousScopesArray, scopeDescriptor, scopes;
      editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, bufferPosition = arg.bufferPosition;
      scopes = scopeDescriptor.getScopesArray();
      previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - 1)];
      previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
      previousScopesArray = previousScopes.getScopesArray();
      if ((hasScope(scopes, 'meta.selector.css') || hasScope(previousScopesArray, 'meta.selector.css')) && !hasScope(scopes, 'source.sass', true)) {
        return true;
      } else if (hasScope(scopes, 'source.css.scss', true) || hasScope(scopes, 'source.css.less', true) || hasScope(scopes, 'source.sass', true) || hasScope(scopes, 'source.css.postcss', true)) {
        prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
        if (prefix) {
          previousBufferPosition = [bufferPosition.row, Math.max(0, bufferPosition.column - prefix.length - 1)];
          previousScopes = editor.scopeDescriptorForBufferPosition(previousBufferPosition);
          previousScopesArray = previousScopes.getScopesArray();
          return !hasScope(previousScopesArray, 'meta.property-name.scss') && !hasScope(previousScopesArray, 'meta.property-value.scss') && !hasScope(previousScopesArray, 'meta.property-value.postcss') && !hasScope(previousScopesArray, 'support.type.property-name.css') && !hasScope(previousScopesArray, 'support.type.property-value.css') && !hasScope(previousScopesArray, 'support.type.property-name.postcss');
        } else {
          return false;
        }
      } else {
        return false;
      }
    },
    isPropertyValuePrefix: function(prefix) {
      prefix = prefix.trim();
      return prefix.length > 0 && prefix !== ':';
    },
    isPropertyNamePrefix: function(prefix) {
      if (prefix == null) {
        return false;
      }
      prefix = prefix.trim();
      return prefix.length > 0 && prefix.match(/^[a-zA-Z-]+$/);
    },
    getImportantPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = importantPrefixPattern.exec(line)) != null ? ref[1] : void 0;
    },
    getPreviousPropertyName: function(bufferPosition, editor) {
      var column, line, propertyName, ref, ref1, ref2, row;
      row = bufferPosition.row, column = bufferPosition.column;
      while (row >= 0) {
        line = editor.lineTextForBufferRow(row);
        if (row === bufferPosition.row) {
          line = line.substr(0, column);
        }
        propertyName = (ref = inlinePropertyNameWithColonPattern.exec(line)) != null ? ref[1] : void 0;
        if (propertyName == null) {
          propertyName = (ref1 = firstInlinePropertyNameWithColonPattern.exec(line)) != null ? ref1[1] : void 0;
        }
        if (propertyName == null) {
          propertyName = (ref2 = propertyNameWithColonPattern.exec(line)) != null ? ref2[1] : void 0;
        }
        if (propertyName) {
          return propertyName;
        }
        row--;
      }
    },
    getPropertyValueCompletions: function(arg) {
      var addSemicolon, bufferPosition, completions, editor, i, importantPrefix, j, len, len1, prefix, property, ref, scopeDescriptor, scopes, value, values;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix, scopeDescriptor = arg.scopeDescriptor;
      property = this.getPreviousPropertyName(bufferPosition, editor);
      values = (ref = this.properties[property]) != null ? ref.values : void 0;
      if (values == null) {
        return null;
      }
      scopes = scopeDescriptor.getScopesArray();
      addSemicolon = !lineEndsWithSemicolon(bufferPosition, editor) && !hasScope(scopes, 'source.sass', true);
      completions = [];
      if (this.isPropertyValuePrefix(prefix)) {
        for (i = 0, len = values.length; i < len; i++) {
          value = values[i];
          if (firstCharsEqual(value, prefix)) {
            completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
          }
        }
      } else if (!hasScope(scopes, 'keyword.other.unit.percentage.css') && !hasScope(scopes, 'keyword.other.unit.scss') && !hasScope(scopes, 'keyword.other.unit.css')) {
        for (j = 0, len1 = values.length; j < len1; j++) {
          value = values[j];
          completions.push(this.buildPropertyValueCompletion(value, property, addSemicolon));
        }
      }
      if (importantPrefix = this.getImportantPrefix(editor, bufferPosition)) {
        completions.push({
          type: 'keyword',
          text: '!important',
          displayText: '!important',
          replacementPrefix: importantPrefix,
          description: "Forces this property to override any other declaration of the same property. Use with caution.",
          descriptionMoreURL: cssDocsURL + "/Specificity#The_!important_exception"
        });
      }
      return completions;
    },
    buildPropertyValueCompletion: function(value, propertyName, addSemicolon) {
      var text;
      text = value;
      if (addSemicolon) {
        text += ';';
      }
      return {
        type: 'value',
        text: text,
        displayText: value,
        description: value + " value for the " + propertyName + " property",
        descriptionMoreURL: cssDocsURL + "/" + propertyName + "#Values"
      };
    },
    getPropertyNamePrefix: function(bufferPosition, editor) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = propertyNamePrefixPattern.exec(line)) != null ? ref[0] : void 0;
    },
    getPropertyNameCompletions: function(arg) {
      var activatedManually, bufferPosition, completions, editor, line, options, prefix, property, ref, scopeDescriptor, scopes;
      bufferPosition = arg.bufferPosition, editor = arg.editor, scopeDescriptor = arg.scopeDescriptor, activatedManually = arg.activatedManually;
      scopes = scopeDescriptor.getScopesArray();
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      if (hasScope(scopes, 'source.sass', true) && !line.match(/^(\s|\t)/)) {
        return [];
      }
      prefix = this.getPropertyNamePrefix(bufferPosition, editor);
      if (!(activatedManually || prefix)) {
        return [];
      }
      completions = [];
      ref = this.properties;
      for (property in ref) {
        options = ref[property];
        if (!prefix || firstCharsEqual(property, prefix)) {
          completions.push(this.buildPropertyNameCompletion(property, prefix, options));
        }
      }
      return completions;
    },
    buildPropertyNameCompletion: function(propertyName, prefix, arg) {
      var description;
      description = arg.description;
      return {
        type: 'property',
        text: propertyName + ": ",
        displayText: propertyName,
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + propertyName
      };
    },
    getPseudoSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = line.match(pseudoSelectorPrefixPattern)) != null ? ref[0] : void 0;
    },
    getPseudoSelectorCompletions: function(arg) {
      var bufferPosition, completions, editor, options, prefix, pseudoSelector, ref;
      bufferPosition = arg.bufferPosition, editor = arg.editor;
      prefix = this.getPseudoSelectorPrefix(editor, bufferPosition);
      if (!prefix) {
        return null;
      }
      completions = [];
      ref = this.pseudoSelectors;
      for (pseudoSelector in ref) {
        options = ref[pseudoSelector];
        if (firstCharsEqual(pseudoSelector, prefix)) {
          completions.push(this.buildPseudoSelectorCompletion(pseudoSelector, prefix, options));
        }
      }
      return completions;
    },
    buildPseudoSelectorCompletion: function(pseudoSelector, prefix, arg) {
      var argument, completion, description;
      argument = arg.argument, description = arg.description;
      completion = {
        type: 'pseudo-selector',
        replacementPrefix: prefix,
        description: description,
        descriptionMoreURL: cssDocsURL + "/" + pseudoSelector
      };
      if (argument != null) {
        completion.snippet = pseudoSelector + "(${1:" + argument + "})";
      } else {
        completion.text = pseudoSelector;
      }
      return completion;
    },
    getTagSelectorPrefix: function(editor, bufferPosition) {
      var line, ref;
      line = editor.getTextInRange([[bufferPosition.row, 0], bufferPosition]);
      return (ref = tagSelectorPrefixPattern.exec(line)) != null ? ref[2] : void 0;
    },
    getTagCompletions: function(arg) {
      var bufferPosition, completions, editor, i, len, prefix, ref, tag;
      bufferPosition = arg.bufferPosition, editor = arg.editor, prefix = arg.prefix;
      completions = [];
      if (prefix) {
        ref = this.tags;
        for (i = 0, len = ref.length; i < len; i++) {
          tag = ref[i];
          if (firstCharsEqual(tag, prefix)) {
            completions.push(this.buildTagCompletion(tag));
          }
        }
      }
      return completions;
    },
    buildTagCompletion: function(tag) {
      return {
        type: 'tag',
        text: tag,
        description: "Selector for <" + tag + "> elements"
      };
    }
  };

  lineEndsWithSemicolon = function(bufferPosition, editor) {
    var line, row;
    row = bufferPosition.row;
    line = editor.lineTextForBufferRow(row);
    return /;\s*$/.test(line);
  };

  hasScope = function(scopesArray, scope, checkEmbedded) {
    if (checkEmbedded == null) {
      checkEmbedded = false;
    }
    return scopesArray.indexOf(scope) !== -1 || (checkEmbedded && scopesArray.indexOf(scope + ".embedded.html") !== -1);
  };

  firstCharsEqual = function(str1, str2) {
    return str1[0].toLowerCase() === str2[0].toLowerCase();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
