/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import sun.awt.SunToolkit;

public class JFrame
extends Frame
implements WindowConstants,
Accessible,
RootPaneContainer,
TransferHandler.HasGetTransferHandler {
    public static final int EXIT_ON_CLOSE = 3;
    private static final Object defaultLookAndFeelDecoratedKey = new StringBuffer("JFrame.defaultLookAndFeelDecorated");
    private int defaultCloseOperation = 1;
    private TransferHandler transferHandler;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JFrame() throws HeadlessException {
        this.frameInit();
    }

    public JFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.frameInit();
    }

    public JFrame(String string) throws HeadlessException {
        super(string);
        this.frameInit();
    }

    public JFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.frameInit();
    }

    protected void frameInit() {
        boolean bl;
        this.enableEvents(72L);
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setBackground(UIManager.getColor("control"));
        this.setRootPaneCheckingEnabled(true);
        if (JFrame.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        SunToolkit.checkAndSetPolicy(this);
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.setOpaque(true);
        return jRootPane;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this.dispose();
                    break;
                }
                case 3: {
                    System.exit(0);
                    break;
                }
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        SecurityManager securityManager;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("defaultCloseOperation must be one of: DO_NOTHING_ON_CLOSE, HIDE_ON_CLOSE, DISPOSE_ON_CLOSE, or EXIT_ON_CLOSE");
        }
        if (n == 3 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkExit(0);
        }
        if (this.defaultCloseOperation != n) {
            int n2 = this.defaultCloseOperation;
            this.defaultCloseOperation = n;
            this.firePropertyChange("defaultCloseOperation", n2, n);
        }
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        TransferHandler transferHandler2 = this.transferHandler;
        this.transferHandler = transferHandler;
        SwingUtilities.installSwingDropTargetAsNecessary(this, this.transferHandler);
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    @Override
    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    @Override
    public Graphics getGraphics() {
        JComponent.getGraphicsInvoked(this);
        return super.getGraphics();
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (RepaintManager.HANDLE_TOP_LEVEL_PAINT) {
            RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public static void setDefaultLookAndFeelDecorated(boolean bl) {
        if (bl) {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.TRUE);
        } else {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.FALSE);
        }
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLookAndFeelDecoratedKey);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    @Override
    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : (this.defaultCloseOperation == 3 ? "EXIT_ON_CLOSE" : "")));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJFrame
    extends Frame.AccessibleAWTFrame {
        protected AccessibleJFrame() {
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JFrame.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JFrame.this.getTitle();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JFrame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JFrame.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

