/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.image;

import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.Coords;

public abstract class CompoundImage {
    public static final int BORDER_SIZE_DEFAULT = 1;
    protected final int[] uSubdivision;
    protected final int[] u0;
    protected final int[] u1;
    protected final int[] vSubdivision;
    protected final int[] v0;
    protected final int[] v1;
    protected final int uSections;
    protected final int vSections;
    protected final int uBorderSize;
    protected final int vBorderSize;
    protected Image[] tiles;

    public CompoundImage(Image image, int maxSize) {
        this(image, maxSize, 1);
    }

    public CompoundImage(Image image, int maxSize, int borderSize) {
        int y;
        if (4 * borderSize >= maxSize) {
            borderSize = maxSize / 4;
        }
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        this.uBorderSize = imgW <= maxSize ? 0 : borderSize;
        this.vBorderSize = imgH <= maxSize ? 0 : borderSize;
        this.uSubdivision = CompoundImage.subdivideUVs(imgW, maxSize, this.uBorderSize);
        this.vSubdivision = CompoundImage.subdivideUVs(imgH, maxSize, this.vBorderSize);
        this.uSections = this.uSubdivision.length - 1;
        this.vSections = this.vSubdivision.length - 1;
        this.u0 = new int[this.uSections];
        this.u1 = new int[this.uSections];
        this.v0 = new int[this.vSections];
        this.v1 = new int[this.vSections];
        this.tiles = new Image[this.uSections * this.vSections];
        for (y = 0; y != this.vSections; ++y) {
            this.v0[y] = this.vSubdivision[y] - this.uBorder(y);
            this.v1[y] = this.vSubdivision[y + 1] + this.dBorder(y);
        }
        for (int x = 0; x != this.uSections; ++x) {
            this.u0[x] = this.uSubdivision[x] - this.lBorder(x);
            this.u1[x] = this.uSubdivision[x + 1] + this.rBorder(x);
        }
        for (y = 0; y != this.vSections; ++y) {
            for (int x = 0; x != this.uSections; ++x) {
                this.tiles[y * this.uSections + x] = image.createSubImage(this.u0[x], this.v0[y], this.u1[x] - this.u0[x], this.v1[y] - this.v0[y]);
            }
        }
    }

    private int lBorder(int i) {
        return i > 0 ? this.uBorderSize : 0;
    }

    private int rBorder(int i) {
        return i < this.uSections - 1 ? this.uBorderSize : 0;
    }

    private int uBorder(int i) {
        return i > 0 ? this.vBorderSize : 0;
    }

    private int dBorder(int i) {
        return i < this.vSections - 1 ? this.vBorderSize : 0;
    }

    private static int[] subdivideUVs(int size, int maxSize, int borderSize) {
        int contSize = maxSize - borderSize * 2;
        int nImages = (size - borderSize * 2 + contSize - 1) / contSize;
        int[] data = new int[nImages + 1];
        data[0] = 0;
        data[nImages] = size;
        for (int i = 1; i < nImages; ++i) {
            data[i] = borderSize + contSize * i;
        }
        return data;
    }

    protected abstract Texture getTile(int var1, int var2, ResourceFactory var3);

    public void drawLazy(Graphics g, Coords crd, float x, float y) {
        new CompoundCoords(this, crd).draw(g, this, x, y);
    }
}

