/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.swt.SWTCursor;
import com.sun.glass.ui.swt.SWTPixels;
import com.sun.glass.ui.swt.SWTRobot;
import com.sun.glass.ui.swt.SWTTimer;
import com.sun.glass.ui.swt.SWTView;
import com.sun.glass.ui.swt.SWTWindow;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class SWTApplication
extends Application {
    Object loopReturn;
    static final String IS_EVENTTHREAD_KEY = "javafx.embed.isEventThread";
    static long context = 0L;
    static long shareContext = 0L;
    static final long BROWSER_PARENT_ID = -1L;
    static final int[][] KeyTable = new int[][]{{0, 0}, {10, 13}, {10, 10}, {8, 8}, {9, 9}, {27, 27}, {32, 32}, {127, 127}, {155, 0x1000009}, {156, 0x1000051}, {16, 131072}, {17, 262144}, {18, 65536}, {524, 0x400000}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {33, 0x1000005}, {34, 0x1000006}, {35, 0x1000008}, {36, 0x1000007}, {37, 0x1000003}, {38, 0x1000001}, {39, 0x1000004}, {40, 0x1000002}, {44, 44}, {45, 45}, {46, 46}, {47, 47}, {59, 59}, {61, 61}, {91, 91}, {92, 92}, {93, 93}, {106, 16777258}, {107, 16777259}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {150, 64}, {151, 42}, {152, 34}, {153, 60}, {160, 62}, {161, 123}, {162, 125}, {192, 96}, {222, 39}, {512, 64}, {513, 58}, {514, 94}, {515, 36}, {517, 33}, {519, 40}, {520, 35}, {521, 43}, {522, 41}, {523, 95}, {48, 48}, {49, 49}, {50, 50}, {51, 51}, {52, 52}, {53, 53}, {54, 54}, {55, 55}, {56, 56}, {57, 57}, {65, 97}, {66, 98}, {67, 99}, {68, 100}, {69, 101}, {70, 102}, {71, 103}, {72, 104}, {73, 105}, {74, 106}, {75, 107}, {76, 108}, {77, 109}, {78, 110}, {79, 111}, {80, 112}, {81, 113}, {82, 114}, {83, 115}, {84, 116}, {85, 117}, {86, 118}, {87, 119}, {88, 120}, {89, 121}, {90, 122}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}};

    void runSWTEventLoop(Runnable launchable) {
        Display display = Display.getDefault();
        SWTApplication.setEventThread(display.getThread());
        display.asyncExec(launchable);
        while (!display.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    long getLauncherClass(final Runnable launchable, final long launcherSel) {
        try {
            Class<?> OS2 = Class.forName("org.eclipse.swt.internal.cocoa.OS");
            Callback callback = new Callback(new Object(){

                long launcherProc(long id, long sel) {
                    if (sel == launcherSel) {
                        SWTApplication.this.runSWTEventLoop(launchable);
                    }
                    return 0L;
                }
            }, "launcherProc", 2);
            long proc2 = callback.getAddress();
            Method objc_getClass = OS2.getDeclaredMethod("objc_getClass", String.class);
            long NSObject_class = (Long)objc_getClass.invoke(OS2, "NSObject");
            Method objc_allocateClassPair = OS2.getDeclaredMethod("objc_allocateClassPair", Long.TYPE, String.class, Long.TYPE);
            long launcherClass = (Long)objc_allocateClassPair.invoke(OS2, NSObject_class, "Proc", 0);
            Method class_addMethod = OS2.getDeclaredMethod("class_addMethod", Long.TYPE, Long.TYPE, Long.TYPE, String.class);
            class_addMethod.invoke(OS2, launcherClass, launcherSel, proc2, "@:");
            Method objc_registerClassPair = OS2.getDeclaredMethod("objc_registerClassPair", Long.TYPE);
            objc_registerClassPair.invoke(OS2, launcherClass);
            return launcherClass;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    void runCocoaLoop(Runnable launchable) {
        try {
            Class<?> OS2 = Class.forName("org.eclipse.swt.internal.cocoa.OS");
            Method objc_msgSend_bool = OS2.getDeclaredMethod("objc_msgSend_bool", Long.TYPE, Long.TYPE);
            long class_NSThread = OS2.getDeclaredField("class_NSThread").getLong(OS2);
            long sel_isMainThread = OS2.getDeclaredField("sel_isMainThread").getLong(OS2);
            boolean isMainThread = (Boolean)objc_msgSend_bool.invoke(OS2, class_NSThread, sel_isMainThread);
            if (isMainThread) {
                this.runSWTEventLoop(launchable);
            } else {
                Method sel_registerName = OS2.getDeclaredMethod("sel_registerName", String.class);
                long launcherSel = (Long)sel_registerName.invoke(OS2, "launcherSel");
                long launcherClass = this.getLauncherClass(launchable, launcherSel);
                long sel_alloc = OS2.getDeclaredField("sel_alloc").getLong(OS2);
                long sel_init = OS2.getDeclaredField("sel_init").getLong(OS2);
                long sel_performSelectorOnMainThread_withObject_waitUntilDone_ = OS2.getDeclaredField("sel_performSelectorOnMainThread_withObject_waitUntilDone_").getLong(OS2);
                long sel_release = OS2.getDeclaredField("sel_release").getLong(OS2);
                Method objc_msgSendLL = OS2.getDeclaredMethod("objc_msgSend", Long.TYPE, Long.TYPE);
                Method objc_msgSendLLLLZ = OS2.getDeclaredMethod("objc_msgSend", Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
                long id = (Long)objc_msgSendLL.invoke(OS2, launcherClass, sel_alloc);
                id = (Long)objc_msgSendLL.invoke(OS2, id, sel_init);
                objc_msgSendLLLLZ.invoke(OS2, id, sel_performSelectorOnMainThread_withObject_waitUntilDone_, launcherSel, 0, false);
                objc_msgSendLL.invoke(OS2, id, sel_release);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void runLoop(Runnable launchable) {
        if ("true".equals(System.getProperty(IS_EVENTTHREAD_KEY, "false"))) {
            Display display = Display.getDefault();
            SWTApplication.setEventThread(display.getThread());
            launchable.run();
            return;
        }
        if (SWT.getPlatform().equals("cocoa")) {
            this.runCocoaLoop(launchable);
        } else {
            new Thread(() -> this.runSWTEventLoop(launchable)).start();
        }
    }

    @Override
    protected void finishTerminating() {
        if ("true".equals(System.getProperty(IS_EVENTTHREAD_KEY, "false"))) {
            return;
        }
        Display.getDefault().dispose();
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new SWTWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        SWTWindow window = new SWTWindow(parent);
        if (parent == -1L) {
            window.setView(this.createView());
        }
        return window;
    }

    @Override
    public View createView() {
        return new SWTView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new SWTCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new SWTCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        Point[] sizes = Display.getDefault().getCursorSizes();
        return sizes.length > 0 ? new Size(sizes[0].x, sizes[0].y) : null;
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new SWTPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new SWTPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new SWTPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public Robot createRobot() {
        return new SWTRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected Screen[] staticScreen_getScreens() {
        Display display = Display.getDefault();
        Screen[] screens = new Screen[1];
        try {
            Constructor screenConstructor = Screen.class.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE);
            screenConstructor.setAccessible(true);
            Monitor monitor = display.getPrimaryMonitor();
            Rectangle bounds = monitor.getBounds();
            Rectangle client = monitor.getClientArea();
            int depth = display.getDepth();
            Point dpi = display.getDPI();
            screens[0] = (Screen)screenConstructor.newInstance(1L, depth, bounds.x, bounds.y, bounds.width, bounds.height, client.x, client.y, client.width, client.height, dpi.x, dpi.y, Float.valueOf(1.0f));
            return screens;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to construct a Screen", e);
        }
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new SWTTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return 0;
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return 100000;
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        int bits = 65536;
        if (multipleMode) {
            bits |= 2;
        }
        switch (type) {
            case 0: {
                bits |= 0x1000;
                break;
            }
            case 1: {
                bits |= 0x2000;
            }
        }
        Shell parent = ((SWTWindow)owner).shell;
        FileDialog dialog = new FileDialog(parent, bits);
        dialog.setText(title);
        String[] filters = new String[extensionFilters.length];
        String[] extensions = new String[extensionFilters.length];
        for (int i = 0; i < extensionFilters.length; ++i) {
            filters[i] = extensionFilters[i].getDescription();
            List<String> list = extensionFilters[i].getExtensions();
            if (list.size() <= 0) continue;
            extensions[i] = list.get(0);
        }
        dialog.setFilterNames(filters);
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(folder);
        dialog.setFilterIndex(defaultFilterIndex);
        dialog.setFileName(filename);
        if (dialog.open() == null) {
            return new CommonDialogs.FileChooserResult();
        }
        String path = dialog.getFilterPath();
        String[] names = dialog.getFileNames();
        String[] result = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = path + names[i];
        }
        ArrayList<File> l = new ArrayList<File>();
        for (String s : result) {
            l.add(new File(s));
        }
        return new CommonDialogs.FileChooserResult(l, null);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        int bits = 65536;
        Shell parent = ((SWTWindow)owner).shell;
        DirectoryDialog dialog = new DirectoryDialog(parent, bits);
        dialog.setText(title);
        String result = dialog.open();
        return result == null ? null : new File(result);
    }

    @Override
    protected Object _enterNestedEventLoop() {
        this.loopReturn = null;
        while (this.loopReturn == null) {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
        }
        try {
            Object object = this.loopReturn;
            return object;
        }
        finally {
            this.loopReturn = null;
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        this.loopReturn = retValue;
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return Display.getDefault().getDoubleClickTime();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return 4;
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return 4;
    }

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        Display.getDefault().syncExec(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    @Override
    protected boolean _supportsSystemMenu() {
        return SWT.getPlatform().equals("cocoa");
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return SWT.getPlatform().equals("cocoa");
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    static int getKeyCode(Event event) {
        int keyCode = event.keyCode;
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][1] != keyCode) continue;
            return KeyTable[i][0];
        }
        return 0;
    }

    static int getSWTKeyCode(int keyCode) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != keyCode) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    static int getModifiers(Event event) {
        int stateMask = event.stateMask;
        if (event.type == 1) {
            if (event.keyCode == 131072) {
                stateMask |= 0x20000;
            }
            if (event.keyCode == 262144) {
                stateMask |= 0x40000;
            }
            if (event.keyCode == 65536) {
                stateMask |= 0x10000;
            }
            if (event.keyCode == 0x400000) {
                stateMask |= 0x400000;
            }
        }
        if (event.type == 2) {
            if (event.keyCode == 131072) {
                stateMask &= 0xFFFDFFFF;
            }
            if (event.keyCode == 262144) {
                stateMask &= 0xFFFBFFFF;
            }
            if (event.keyCode == 65536) {
                stateMask &= 0xFFFEFFFF;
            }
            if (event.keyCode == 0x400000) {
                stateMask &= 0xFFBFFFFF;
            }
        }
        int modifiers = 0;
        if ((stateMask & 0x20000) != 0) {
            modifiers |= 1;
        }
        if ((stateMask & 0x40000) != 0) {
            modifiers |= 4;
        }
        if ((stateMask & 0x10000) != 0) {
            modifiers |= 8;
        }
        if ((stateMask & 0x400000) != 0) {
            modifiers |= 0x10;
        }
        if (event.type == 3) {
            if (event.button == 1) {
                stateMask |= 0x80000;
            }
            if (event.button == 2) {
                stateMask |= 0x100000;
            }
            if (event.button == 3) {
                stateMask |= 0x200000;
            }
            if (event.button == 4) {
                stateMask |= 0x800000;
            }
            if (event.button == 5) {
                stateMask |= 0x2000000;
            }
        }
        if (event.type == 4) {
            if (event.button == 1) {
                stateMask &= 0xFFF7FFFF;
            }
            if (event.button == 2) {
                stateMask &= 0xFFEFFFFF;
            }
            if (event.button == 3) {
                stateMask &= 0xFFDFFFFF;
            }
            if (event.button == 4) {
                stateMask &= 0xFF7FFFFF;
            }
            if (event.button == 5) {
                stateMask &= 0xFDFFFFFF;
            }
        }
        if ((stateMask & 0x80000) != 0) {
            modifiers |= 0x20;
        }
        if ((stateMask & 0x100000) != 0) {
            modifiers |= 0x80;
        }
        if ((stateMask & 0x200000) != 0) {
            modifiers |= 0x40;
        }
        return modifiers;
    }

    static int getButton(Event event) {
        int button = 211;
        if (event.button == 1 || (event.stateMask & 0x80000) != 0) {
            button = 212;
        }
        if (event.button == 2 || (event.stateMask & 0x100000) != 0) {
            button = 214;
        }
        if (event.button == 3 || (event.stateMask & 0x200000) != 0) {
            button = 213;
        }
        return button;
    }

    static Widget findWidget(long handle) {
        try {
            Method method = Display.class.getDeclaredMethod("findWidget", Long.TYPE);
            method.setAccessible(true);
            return (Widget)method.invoke((Object)Display.getDefault(), handle);
        }
        catch (Exception e) {
            try {
                Method method = Display.class.getDeclaredMethod("findWidget", Integer.TYPE);
                method.setAccessible(true);
                return (Widget)method.invoke((Object)Display.getDefault(), (int)handle);
            }
            catch (Exception e2) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static long getHandle(Shell shell) {
        if (SWT.getPlatform().equals("win32")) {
            return SWTApplication.getHandleW32((Control)shell);
        }
        if (SWT.getPlatform().equals("cocoa")) {
            return SWTApplication.getHandleCocoa(shell);
        }
        if (SWT.getPlatform().equals("gtk")) {
            return SWTApplication.getHandleGTK(shell);
        }
        return 0L;
    }

    static long getHandle(Control control) {
        if (SWT.getPlatform().equals("win32")) {
            return SWTApplication.getHandleW32(control);
        }
        if (SWT.getPlatform().equals("cocoa")) {
            return SWTApplication.getHandleCocoa(control);
        }
        if (SWT.getPlatform().equals("gtk")) {
            return SWTApplication.getHandleGTK(control);
        }
        return 0L;
    }

    static long getHandle(Class clazz, Object object, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            try {
                return field.getLong(object);
            }
            catch (Exception e) {
                try {
                    return field.getInt(object);
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    static void setHandle(Class clazz, Object object, String name, long value) {
        try {
            Field field = clazz.getField(name);
            field.setAccessible(true);
            try {
                field.setLong(object, value);
            }
            catch (Exception e) {
                try {
                    field.setInt(object, (int)value);
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static long getHandleW32(Control control) {
        return SWTApplication.getHandle(Control.class, control, "handle");
    }

    static long getHandleGTK(Control control) {
        return SWTApplication.getHandle(Widget.class, control, "handle");
    }

    static long getHandleGTK(Shell control) {
        return SWTApplication.getHandle(control.getClass(), control, "shellHandle");
    }

    static long getHandleCocoa(Control control) {
        try {
            Field field = control.getClass().getField("view");
            field.setAccessible(true);
            Object view = field.get(control);
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.id");
            return SWTApplication.getHandle(clazz, view, "id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    static long getHandleCocoa(Shell control) {
        try {
            Field field = control.getClass().getDeclaredField("window");
            field.setAccessible(true);
            Object view = field.get(control);
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.id");
            return SWTApplication.getHandle(clazz, view, "id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    static void invokeLock(Control control, String name) {
        try {
            Field field = control.getClass().getField("view");
            field.setAccessible(true);
            Object view = field.get(control);
            Method method = view.getClass().getMethod(name, new Class[0]);
            method.invoke(view, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void lockFocus(Control control) {
        if (SWT.getPlatform().equals("cocoa")) {
            SWTApplication.setView(control, SWTApplication.new_NSOpenGLContext(context));
        }
    }

    static void unlockFocus(Control control) {
    }

    static Object new_NSOpenGLContext(long context) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSOpenGLContext");
            Object object = clazz.newInstance();
            SWTApplication.setHandle(clazz, object, "id", context);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    static void setView(Control control, Object context) {
        try {
            Field field = control.getClass().getField("view");
            field.setAccessible(true);
            Object view = field.get(control);
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSView");
            Method method = context.getClass().getMethod("setView", clazz);
            method.invoke(context, view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void setTransparent(Shell shell) {
        if (SWT.getPlatform().equals("cocoa")) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSOpenGLContext");
                Object object = SWTApplication.new_NSOpenGLContext(context);
                Method method = clazz.getMethod("setValues", int[].class, Integer.TYPE);
                method.invoke(object, new int[]{0}, 236);
                Field field = shell.getClass().getField("view");
                Object view = field.get(shell);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSView");
                method = clazz.getMethod("window", new Class[0]);
                Object window = method.invoke(view, new Object[0]);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSWindow");
                method = clazz.getMethod("graphicsContext", new Class[0]);
                Object context = method.invoke(window, new Object[0]);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSGraphicsContext");
                method = clazz.getMethod("saveGraphicsState", new Class[0]);
                method.invoke(context, new Object[0]);
                method = clazz.getMethod("setCurrentContext", clazz);
                method.invoke(null, context);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSGraphicsContext");
                method = clazz.getMethod("setCompositingOperation", Long.TYPE);
                method.invoke(context, 0);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSRect");
                Object rect = clazz.newInstance();
                field = clazz.getField("width");
                field.setInt(rect, 1024);
                field = clazz.getField("height");
                field.setInt(rect, 1024);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSBezierPath");
                method = clazz.getMethod("fillRect", rect.getClass());
                method.invoke(null, rect);
                clazz = Class.forName("org.eclipse.swt.internal.cocoa.NSGraphicsContext");
                method = clazz.getMethod("restoreGraphicsState", new Class[0]);
                method.invoke(context, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Canvas createGLCanvas(Shell shell, int bits, Map caps) {
        GLData data = new GLData();
        if (caps != null) {
            Long contextPtr;
            Long shareContextPtr = (Long)caps.get("shareContextPtr");
            if (shareContextPtr != null) {
                shareContext = shareContextPtr;
            }
            if ((contextPtr = (Long)caps.get("contextPtr")) != null) {
                context = contextPtr;
            }
        }
        data.doubleBuffer = true;
        GLCanvas canvas = new GLCanvas((Composite)shell, bits, data);
        if (context != 0L) {
            String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
            canvas.setData("org.eclipse.swt.internal.cocoa.glcontext", SWTApplication.new_NSOpenGLContext(context));
        }
        return canvas;
    }

    static Image createImage(Pixels pixels) {
        if (pixels == null) {
            return null;
        }
        ImageData data = SWTApplication.createImageData(pixels);
        return new Image((Device)Display.getDefault(), data);
    }

    static ImageData createImageData(Pixels pixels) {
        int y;
        Buffer pixbuf;
        if (pixels == null) {
            return null;
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        int bpr = width * 4;
        int dataSize = bpr * height;
        byte[] buffer = new byte[dataSize];
        byte[] alphaData = new byte[width * height];
        if (pixels.getBytesPerComponent() == 1) {
            pixbuf = (ByteBuffer)pixels.getPixels();
            int offset = 0;
            int alphaOffset = 0;
            for (y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    byte b = ((ByteBuffer)pixbuf).get();
                    byte g = ((ByteBuffer)pixbuf).get();
                    byte r = ((ByteBuffer)pixbuf).get();
                    byte a = ((ByteBuffer)pixbuf).get();
                    alphaData[alphaOffset++] = a;
                    buffer[offset] = b;
                    buffer[offset + 1] = g;
                    buffer[offset + 2] = r;
                    buffer[offset + 3] = 0;
                    ++x;
                    offset += 4;
                }
            }
        } else if (pixels.getBytesPerComponent() == 4) {
            pixbuf = (IntBuffer)pixels.getPixels();
            int offset = 0;
            int alphaOffset = 0;
            for (y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    int pixel = ((IntBuffer)pixbuf).get();
                    byte b = (byte)(pixel & 0xFF);
                    byte g = (byte)(pixel >> 8 & 0xFF);
                    byte r = (byte)(pixel >> 16 & 0xFF);
                    byte a = (byte)(pixel >> 24 & 0xFF);
                    alphaData[alphaOffset++] = a;
                    buffer[offset] = b;
                    buffer[offset + 1] = g;
                    buffer[offset + 2] = r;
                    buffer[offset + 3] = 0;
                    ++x;
                    offset += 4;
                }
            }
        } else {
            throw new IllegalArgumentException("unhandled pixel buffer");
        }
        PaletteData palette = new PaletteData(65280, 0xFF0000, -16777216);
        ImageData imageData = new ImageData(width, height, 32, palette, 4, buffer);
        imageData.alphaData = alphaData;
        return imageData;
    }

    static Pixels createPixels(ImageData data) {
        if (data == null) {
            return null;
        }
        return null;
    }

    @Override
    protected int _getKeyCodeForChar(char c) {
        return 0;
    }
}

