import * as logdown from 'logdown';
interface LoggerOptions {
    color?: string;
    forceEnable?: boolean;
    logFilePath?: string;
    namespace?: string;
    separator?: string;
}
declare class LogFactory {
    private static readonly logFilePath?;
    private static readonly namespace?;
    static COLOR_STEP: {
        B: number;
        G: number;
        R: number;
    };
    static COLOR_CODE: {
        B: number;
        G: number;
        R: number;
    };
    static getColor(): string;
    static addTimestamp(logTransport: logdown.TransportOptions): void;
    static writeTransport(logTransport: logdown.TransportOptions): Promise<void>;
    static writeMessage(message: string, logFilePath: string): Promise<void>;
    static createLoggerName(fileName: string, namespace?: string, separator?: string): string;
    static getLogger(name: string, options?: LoggerOptions): logdown.Logger;
}
export { LogFactory, LoggerOptions };
