/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.util.concurrency.Semaphore;
import java.io.InputStream;
import java.io.OutputStream;

public class CloudTerminalProcess
extends Process {
    private final OutputStream myOutputStream;
    private final InputStream myInputStream;
    private final Semaphore mySemaphore;

    public CloudTerminalProcess(OutputStream terminalInput, InputStream terminalOutput) {
        this.myOutputStream = terminalInput;
        this.myInputStream = terminalOutput;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.myInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return null;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.mySemaphore.waitFor();
        return this.exitValue();
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public void destroy() {
        this.mySemaphore.up();
    }
}

