/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralExpressionImpl
extends PyElementImpl
implements PyStringLiteralExpression,
RegExpLanguageHost,
PsiLiteralValue {
    @Nullable
    private volatile String myStringValue;
    @Nullable
    private volatile List<TextRange> myValueTextRanges;
    @Nullable
    private volatile List<Pair<TextRange, String>> myDecodedFragments;
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public PyStringLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myStringValue = null;
        this.myValueTextRanges = null;
        this.myDecodedFragments = null;
    }

    @Override
    @NotNull
    public List<TextRange> getStringValueTextRanges() {
        List<Object> result = this.myValueTextRanges;
        if (result == null) {
            int elementStart = this.getTextRange().getStartOffset();
            List ranges = StreamEx.of(this.getStringElements()).map(node -> {
                int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
                return node.getContentRange().shiftRight(nodeRelativeOffset);
            }).toList();
            this.myValueTextRanges = result = Collections.unmodifiableList(ranges);
        }
        List<TextRange> list = result;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        int elementStart = this.getTextRange().getStartOffset();
        List<Object> result = this.myDecodedFragments;
        if (result == null) {
            List combined = StreamEx.of(this.getStringElements()).flatMap(node -> StreamEx.of(node.getDecodedFragments()).map(pair -> {
                int nodeRelativeOffset = node.getTextRange().getStartOffset() - elementStart;
                return Pair.create((Object)((TextRange)pair.getFirst()).shiftRight(nodeRelativeOffset), (Object)pair.getSecond());
            })).toList();
            this.myDecodedFragments = result = Collections.unmodifiableList(combined);
        }
        List<Pair<TextRange, String>> list = result;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isDocString() {
        List<ASTNode> stringNodes = this.getStringNodes();
        return stringNodes.size() == 1 && stringNodes.get(0).getElementType() == PyTokenTypes.DOCSTRING;
    }

    @Override
    @NotNull
    public List<ASTNode> getStringNodes() {
        TokenSet stringNodeTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{PyTokenTypes.STRING_NODES, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.FSTRING_NODE})});
        List<ASTNode> list = Arrays.asList(this.getNode().getChildren(stringNodeTypes));
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyStringElement> getStringElements() {
        List list = StreamEx.of(this.getStringNodes()).map(ASTNode::getPsi).select(PyStringElement.class).toList();
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public String getStringValue() {
        String result = this.myStringValue;
        if (result == null) {
            StringBuilder out = new StringBuilder();
            for (Pair<TextRange, String> fragment : this.getDecodedFragments()) {
                out.append((String)fragment.getSecond());
            }
            this.myStringValue = result = out.toString();
        }
        String string = result;
        if (string == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Object getValue() {
        return this.getStringValue();
    }

    @Override
    public TextRange getStringValueTextRange() {
        List<TextRange> allRanges = this.getStringValueTextRanges();
        if (allRanges.size() == 1) {
            return allRanges.get(0);
        }
        if (allRanges.size() > 1) {
            return allRanges.get(0).union(allRanges.get(allRanges.size() - 1));
        }
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getStringValue();
    }

    public boolean isValidHost() {
        return true;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        ASTNode firstNode;
        if (context == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (key == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if ((firstNode = (ASTNode)ContainerUtil.getFirstItem(this.getStringNodes())) != null) {
            IElementType type;
            if (firstNode.getElementType() == PyElementTypes.FSTRING_NODE) {
                return PyBuiltinCache.getInstance(this).getUnicodeType(LanguageLevel.forElement(this));
            }
            PyFile file = (PyFile)PsiTreeUtil.getParentOfType((PsiElement)this, PyFile.class);
            if (file != null && PyTokenTypes.UNICODE_NODES.contains(type = PythonHighlightingLexer.convertStringType(firstNode.getElementType(), firstNode.getText(), LanguageLevel.forElement(this), file.hasImportFromFuture(FutureFeature.UNICODE_LITERALS)))) {
                return PyBuiltinCache.getInstance(this).getUnicodeType(LanguageLevel.forElement(this));
            }
        }
        return PyBuiltinCache.getInstance(this).getBytesType(LanguageLevel.forElement(this));
    }

    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiReferenceArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return PyStringLiteralExpressionImpl.this.getStringValue();
            }

            @Nullable
            public String getLocationString() {
                String packageForFile = PyElementPresentation.getPackageForFile(PyStringLiteralExpressionImpl.this.getContainingFile());
                return packageForFile != null ? String.format("(%s)", packageForFile) : null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.Variable;
            }
        };
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text2);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        StringLiteralTextEscaper stringLiteralTextEscaper = new StringLiteralTextEscaper(this);
        if (stringLiteralTextEscaper == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        return stringLiteralTextEscaper;
    }

    @Override
    public int valueOffsetToTextOffset(int valueOffset) {
        return this.createLiteralTextEscaper().getOffsetInHost(valueOffset, this.getStringValueTextRange());
    }

    public boolean characterNeedsEscaping(char c) {
        if (c == '#') {
            return this.isVerboseInjection();
        }
        return c == ']' || c == '}' || c == '\"' || c == '\'';
    }

    private boolean isVerboseInjection() {
        List files = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles((PsiElement)this);
        if (files != null) {
            for (Pair file : files) {
                Language language = ((PsiElement)file.getFirst()).getLanguage();
                if (language != PythonVerboseRegexpLanguage.INSTANCE) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isPythonNamedGroupRef();
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
        if (enumSet == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        return RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION;
    }

    public Long getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        try {
            long result = Long.parseLong(number.getText());
            if (result >= 0xFFFFFFFFL) {
                return null;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(13);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCharacterClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringLiteralTextEscaper
    extends LiteralTextEscaper<PyStringLiteralExpression> {
        private final PyStringLiteralExpressionImpl myHost;

        protected StringLiteralTextEscaper(@NotNull PyStringLiteralExpressionImpl host) {
            if (host == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(0);
            }
            super((PsiLanguageInjectionHost)host);
            this.myHost = host;
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(2);
            }
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                String intersectedValue;
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                if (value.codePointCount(0, value.length()) == 1 || value.length() == intersection.getLength()) {
                    intersectedValue = value;
                } else {
                    int start = Math.max(0, rangeInsideHost.getStartOffset() - encodedTextRange.getStartOffset());
                    int end = Math.min(value.length(), start + intersection.getLength());
                    intersectedValue = value.substring(start, end);
                }
                outChars.append(intersectedValue);
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(3);
            }
            int offset = 0;
            int endOffset = -1;
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                int valueLength = value.length();
                int intersectionLength = intersection.getLength();
                if (valueLength == 0) {
                    return -1;
                }
                if (value.codePointCount(0, valueLength) == 1) {
                    if (offset == offsetInDecoded) {
                        return intersection.getStartOffset();
                    }
                    offset += valueLength;
                } else {
                    if (offset + intersectionLength >= offsetInDecoded) {
                        int delta = offsetInDecoded - offset;
                        return intersection.getStartOffset() + delta;
                    }
                    offset += intersectionLength;
                }
                endOffset = intersection.getEndOffset();
            }
            if (offset == offsetInDecoded) {
                return endOffset;
            }
            return -1;
        }

        public boolean isOneLine() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffsetInHost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

