/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
extends ConsoleViewImpl
implements LanguageConsoleView,
DataProvider {
    private final Helper myHelper;
    private final EditorEx myConsoleEditor;
    private final EditorEx myHistoryViewer;
    private final Document myEditorDocument;
    private final JPanel myPanel;
    private final JScrollBar myScrollBar;
    private final DocumentListener myDocumentAdapter;
    @Nullable
    private String myPrompt;
    private ConsoleViewContentType myPromptAttributes;
    private EditorEx myCurrentEditor;
    private final MessageBusConnection myBusConnection;
    private final FocusChangeListener myFocusListener;

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(1);
        }
        if (language == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(2);
        }
        this(new Helper(project, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)"")));
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(3);
        }
        if (title == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(5);
        }
        this(new Helper(project, virtualFile).setTitle(title));
    }

    public LanguageConsoleImpl(@NotNull Helper helper) {
        if (helper == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(6);
        }
        super(helper.project, GlobalSearchScope.allScope((Project)helper.project), true, true);
        this.myPanel = new JPanel((LayoutManager)((Object)new MyLayout()));
        this.myScrollBar = new JBScrollBar(0);
        this.myDocumentAdapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LanguageConsoleImpl.this.myPanel.revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/console/LanguageConsoleImpl$1", "documentChanged"));
            }
        };
        this.myPrompt = "> ";
        this.myPromptAttributes = ConsoleViewContentType.USER_INPUT;
        this.myFocusListener = new FocusChangeListener(){

            @Override
            public void focusGained(@NotNull Editor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                LanguageConsoleImpl.this.myCurrentEditor = (EditorEx)editor;
                if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                    TransactionGuard.submitTransaction((Disposable)LanguageConsoleImpl.this, () -> FileDocumentManager.getInstance().saveAllDocuments());
                }
            }

            @Override
            public void focusLost(@NotNull Editor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myHelper = helper;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myEditorDocument = helper.getDocument();
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, this.getProject());
        this.myConsoleEditor.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().setEnabled(false);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myConsoleEditor.getSettings().setVirtualSpace(false);
        this.myCurrentEditor = this.myConsoleEditor;
        Document historyDocument = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)historyDocument);
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(historyDocument, this.getProject(), EditorKind.CONSOLE);
        this.myHistoryViewer.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myScrollBar.setModel(new MyModel(this.myScrollBar, this.myHistoryViewer, this.myConsoleEditor));
        this.myScrollBar.putClientProperty(JBScrollPane.Alignment.class, JBScrollPane.Alignment.BOTTOM);
        this.myBusConnection = this.getProject().getMessageBus().connect();
        ApplicationManager.getApplication().invokeLater(() -> this.installEditorFactoryListener(), this.getProject().getDisposed());
    }

    @Override
    @NotNull
    protected final EditorEx doCreateConsoleEditor() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    @Override
    protected final void disposeEditor() {
    }

    @Override
    @NotNull
    protected JComponent createCenterComponent() {
        this.initComponents();
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleEditor().getContentComponent();
    }

    private void initComponents() {
        this.setupComponents();
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleEditor.getComponent());
        this.myPanel.add(this.myScrollBar);
        this.myPanel.setBackground(this.myConsoleEditor.getBackgroundColor());
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
        this.setPromptInner(this.myPrompt);
    }

    @Override
    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.getVirtualFile());
            this.myCurrentEditor = this.myConsoleEditor;
        }
        this.setHistoryScrollBarVisible(!consoleEditorEnabled);
        this.myScrollBar.setVisible(consoleEditorEnabled);
        this.myConsoleEditor.getComponent().setVisible(consoleEditorEnabled);
    }

    private void setHistoryScrollBarVisible(boolean visible) {
        JScrollBar prev2 = this.myHistoryViewer.getScrollPane().getHorizontalScrollBar();
        prev2.setEnabled(visible);
    }

    private void setupComponents() {
        this.myHelper.setupEditor(this.myConsoleEditor);
        this.myHelper.setupEditor(this.myHistoryViewer);
        this.myHistoryViewer.getComponent().setMinimumSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.getComponent().setPreferredSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleEditor.setContextMenuGroupId("ConsoleEditorPopupMenu");
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getVirtualFile(), this.myConsoleEditor.getColorsScheme(), this.getProject()));
        this.setHistoryScrollBarVisible(false);
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LanguageConsoleImpl.this.myConsoleEditor.getContentComponent(), true));
                    LanguageConsoleImpl.this.myConsoleEditor.processKeyTyped(event);
                }
            }
        });
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleEditor.getComponent());
    }

    @Override
    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleEditor.getComponent().isVisible();
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.myPrompt;
    }

    @Override
    @Nullable
    public ConsoleViewContentType getPromptAttributes() {
        return this.myPromptAttributes;
    }

    @Override
    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(9);
        }
        this.myPromptAttributes = textAttributes;
    }

    @Override
    public void setPrompt(@Nullable String prompt) {
        this.myPrompt = prompt != null && !prompt.endsWith(" ") ? prompt + " " : prompt;
        this.setPromptInner(this.myPrompt);
    }

    private void setPromptInner(@Nullable String prompt) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myConsoleEditor.isDisposed()) {
                this.myConsoleEditor.setPrefixTextAndAttributes(prompt, this.myPromptAttributes.getAttributes());
            }
        });
    }

    @Override
    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.setPromptInner(editable ? this.myPrompt : "");
    }

    @Override
    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    @Override
    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.myHelper.getFileSafe();
        if (psiFile == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(10);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myHelper.virtualFile;
        if (virtualFile == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public final EditorEx getHistoryViewer() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(12);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public final Document getEditorDocument() {
        Document document = this.myEditorDocument;
        if (document == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(13);
        }
        return document;
    }

    @Override
    @NotNull
    public final EditorEx getConsoleEditor() {
        EditorEx editorEx = this.myConsoleEditor;
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myHelper.title;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void setTitle(@NotNull String title) {
        if (title == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(16);
        }
        this.myHelper.setTitle(title);
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(18);
        }
        return this.addToHistoryInner(textRange, editor, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx document = editor.getDocument();
        String text = document.getText();
        TextRange range2 = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range2, editor, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        String string = text;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result2 = this.addTextRangeToHistory(textRange, editor, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset()));
        }
        this.scrollToEnd();
        String string = result2;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static String printWithHighlighting(@NotNull LanguageConsoleView console, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        String text;
        EditorHighlighter highlighter;
        if (console == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(23);
        }
        if (inputEditor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(24);
        }
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(25);
        }
        if (inputEditor instanceof EditorWindow) {
            PsiFile file2 = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)console.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText(file2, null, null);
            highlighter.setText((CharSequence)fullText);
            text = textRange.substring(fullText);
        } else {
            text = inputEditor.getDocument().getText(textRange);
            highlighter = ((EditorEx)inputEditor).getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        ((LanguageConsoleImpl)console).doAddPromptToHistory();
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, syntax);
        } else {
            console.print(text, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return text;
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(26);
        }
        if (inputEditor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(27);
        }
        String string = LanguageConsoleImpl.printWithHighlighting(this, inputEditor, textRange);
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected void doAddPromptToHistory() {
        if (this.myPrompt != null) {
            this.print(this.myPrompt, this.myPromptAttributes);
        }
    }

    @Override
    public void dispose() {
        FileEditorManager editorManager;
        super.dispose();
        if (this.myHistoryViewer.isDisposed()) {
            return;
        }
        this.myConsoleEditor.getDocument().removeDocumentListener(this.myDocumentAdapter);
        this.myHistoryViewer.getDocument().removeDocumentListener(this.myDocumentAdapter);
        this.myBusConnection.deliverImmediately();
        Disposer.dispose((Disposable)this.myBusConnection);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.getVirtualFile())) {
            editorManager.closeFile(this.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(29);
        }
        return super.getData(dataId);
    }

    private void installEditorFactoryListener() {
        FileEditorManagerListener fileEditorListener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (LanguageConsoleImpl.this.myConsoleEditor == null || !Comparing.equal((Object)file2, (Object)LanguageConsoleImpl.this.getVirtualFile())) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file2)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor.addFocusListener(LanguageConsoleImpl.this.myFocusListener);
                    if (selectedTextEditor == editor) {
                        LanguageConsoleImpl.this.myCurrentEditor = editor;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor.getComponent(), (JComponent)LanguageConsoleImpl.this.myConsoleEditor.getComponent());
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (!Comparing.equal((Object)file2, (Object)LanguageConsoleImpl.this.getVirtualFile())) {
                    return;
                }
                if (!Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) && LanguageConsoleImpl.this.myCurrentEditor != null && LanguageConsoleImpl.this.myCurrentEditor.isDisposed()) {
                    LanguageConsoleImpl.this.myCurrentEditor = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (editorManager.isFileOpen(this.getVirtualFile())) {
            fileEditorListener.fileOpened(editorManager, this.getVirtualFile());
        }
    }

    @Override
    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = (EditorEx)ObjectUtils.notNull((Object)this.myCurrentEditor, (Object)this.myConsoleEditor);
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(30);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        if (language == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(31);
        }
        return language;
    }

    @Override
    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(32);
        }
        this.myHelper.setLanguage(language);
        this.myHelper.getFileSafe();
    }

    @Override
    public void setInputText(@NotNull String query) {
        if (query == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(33);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> this.myConsoleEditor.getDocument().setText(StringUtil.convertLineSeparators((String)query)));
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    int getMinHistoryLineCount() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/LanguageConsoleImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 17: 
            case 20: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEditor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryViewer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDocument";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleEditor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareExecuteAction";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addToHistoryInner";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextRangeToHistory";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPromptAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addToHistoryInner";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "printWithHighlighting";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTextRangeToHistory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setInputText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyModel
    extends DefaultBoundedRangeModel {
        private volatile boolean myInternalChange;
        private final JScrollBar myBar;
        private final EditorEx myFirstEditor;
        private final EditorEx mySecondEditor;
        private int myFirstValue;
        private int mySecondValue;

        private MyModel(JScrollBar bar, EditorEx first, EditorEx second) {
            this.myBar = bar;
            this.myFirstEditor = first;
            this.mySecondEditor = second;
            this.addChangeListener(event -> this.onChange());
            first.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
            second.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
        }

        private boolean isInternal() {
            return this.myInternalChange || !this.myFirstEditor.getComponent().isVisible() || !this.mySecondEditor.getComponent().isVisible();
        }

        private void onChange() {
            if (this.isInternal()) {
                return;
            }
            this.myInternalChange = true;
            MyModel.setValue(this.myFirstEditor.getScrollPane().getViewport(), this.getValue());
            MyModel.setValue(this.mySecondEditor.getScrollPane().getViewport(), this.getValue());
            this.myInternalChange = false;
        }

        private void onUpdate(Object source) {
            Point position;
            if (this.isInternal()) {
                return;
            }
            JViewport first = this.myFirstEditor.getScrollPane().getViewport();
            JViewport second = this.mySecondEditor.getScrollPane().getViewport();
            int value = this.getValue();
            if (source == first) {
                position = first.getViewPosition();
                if (position.x != this.myFirstValue) {
                    this.myFirstValue = value = position.x;
                }
            } else {
                position = second.getViewPosition();
                if (position.x != this.mySecondValue) {
                    this.mySecondValue = value = position.x;
                }
            }
            int ext = Math.min(first.getExtentSize().width, second.getExtentSize().width);
            int max = Math.max(first.getViewSize().width, second.getViewSize().width);
            this.setRangeProperties(value, ext, 0, max, false);
            this.myBar.setEnabled(ext < max);
        }

        private static void setValue(JViewport viewport, int value) {
            Point position = viewport.getViewPosition();
            position.x = Math.max(0, Math.min(value, viewport.getViewSize().width - viewport.getExtentSize().width));
            viewport.setViewPosition(position);
        }
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(@NotNull Container parent) {
            EditorEx input;
            int componentCount;
            if (parent == null) {
                MyLayout.$$$reportNull$$$0(0);
            }
            if ((componentCount = parent.getComponentCount()) == 0) {
                return;
            }
            EditorEx history = LanguageConsoleImpl.this.myHistoryViewer;
            EditorEx editorEx = input = LanguageConsoleImpl.this.isConsoleEditorEnabled() ? LanguageConsoleImpl.this.myConsoleEditor : null;
            if (input == null) {
                parent.getComponent(0).setBounds(parent.getBounds());
                return;
            }
            Dimension panelSize = parent.getSize();
            if (LanguageConsoleImpl.this.myScrollBar.isVisible()) {
                Dimension size = LanguageConsoleImpl.this.myScrollBar.getPreferredSize();
                if (panelSize.height < size.height) {
                    return;
                }
                panelSize.height -= size.height;
                LanguageConsoleImpl.this.myScrollBar.setBounds(0, panelSize.height, panelSize.width, size.height);
            }
            if (panelSize.getHeight() <= 0.0) {
                return;
            }
            Dimension historySize = history.getContentSize();
            Dimension inputSize = input.getContentSize();
            if (LanguageConsoleImpl.this.isHistoryViewerForceAdditionalColumnsUsage()) {
                history.getSoftWrapModel().forceAdditionalColumnsUsage();
                int minAdditionalColumns = 2;
                int historySpaceWidth = EditorUtil.getPlainSpaceWidth(history);
                historySize.width += historySpaceWidth * (minAdditionalColumns - history.getSettings().getAdditionalColumnsCount());
                int inputSpaceWidth = EditorUtil.getPlainSpaceWidth(input);
                inputSize.width += inputSpaceWidth * (minAdditionalColumns - input.getSettings().getAdditionalColumnsCount());
                int max = Math.max(historySize.width, inputSize.width);
                history.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - historySize.width) / historySpaceWidth);
                input.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - inputSize.width) / inputSpaceWidth);
            }
            if (history.getDocument().getLineCount() == 0) {
                historySize.height = 0;
            }
            int minHistoryHeight = historySize.height > 0 ? LanguageConsoleImpl.this.getMinHistoryLineCount() * history.getLineHeight() : 0;
            int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
            int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
            int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
            int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
            int oldHistoryHeight = history.getComponent().getHeight();
            int newHistoryHeight = panelSize.height - newInputHeight;
            int delta = newHistoryHeight - newHistoryHeight / history.getLineHeight() * history.getLineHeight();
            input.getComponent().setBounds(0, newHistoryHeight -= delta, panelSize.width, newInputHeight += delta);
            history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
            input.getComponent().doLayout();
            history.getComponent().doLayout();
            if (newHistoryHeight < oldHistoryHeight) {
                JViewport viewport = history.getScrollPane().getViewport();
                Point position = viewport.getViewPosition();
                position.translate(0, oldHistoryHeight - newHistoryHeight);
                viewport.setViewPosition(position);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/console/LanguageConsoleImpl$MyLayout", "layoutContainer"));
        }
    }

    public static class Helper {
        public final Project project;
        public final VirtualFile virtualFile;
        String title;
        PsiFile file;

        public Helper(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.virtualFile = virtualFile;
            this.title = virtualFile.getName();
        }

        public Helper setTitle(String title) {
            this.title = title;
            return this;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.project, (VirtualFile)this.virtualFile));
            if (psiFile == null) {
                Helper.$$$reportNull$$$0(2);
            }
            return psiFile;
        }

        @NotNull
        public Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                Language language = this.virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)this.virtualFile).getLanguage() : null;
                throw new AssertionError((Object)String.format("no document for: %s (fileType: %s, language: %s, length: %s, valid: %s)", this.virtualFile, this.virtualFile.getFileType(), language, this.virtualFile.getLength(), this.virtualFile.isValid()));
            }
            Document document2 = document;
            if (document2 == null) {
                Helper.$$$reportNull$$$0(3);
            }
            return document2;
        }

        public void setLanguage(Language language) {
            if (!(this.virtualFile instanceof LightVirtualFile)) {
                throw new UnsupportedOperationException();
            }
            ((LightVirtualFile)this.virtualFile).setLanguage(language);
            ((LightVirtualFile)this.virtualFile).setContent((Object)this.getDocument(), (CharSequence)this.getDocument().getText(), false);
            FileContentUtil.reparseFiles((Project)this.project, Collections.singletonList(this.virtualFile), (boolean)false);
        }

        public void setupEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                Helper.$$$reportNull$$$0(4);
            }
            ConsoleViewUtil.setupConsoleEditor(editor, false, false);
            editor.getContentComponent().setFocusCycleRoot(false);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.setBorder(null);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setAdditionalLinesCount(1);
            editorSettings.setAdditionalColumnsCount(1);
            DataManager.registerDataProvider((JComponent)editor.getComponent(), dataId -> this.getEditorData(editor, dataId));
        }

        @NotNull
        PsiFile getFileSafe() {
            PsiFile psiFile = this.file == null || !this.file.isValid() ? (this.file = this.getFile()) : this.file;
            if (psiFile == null) {
                Helper.$$$reportNull$$$0(5);
            }
            return psiFile;
        }

        @Nullable
        protected Object getEditorData(@NotNull EditorEx editor, String dataId) {
            if (editor == null) {
                Helper.$$$reportNull$$$0(6);
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return editor;
            }
            if (this.project.isInitialized()) {
                Caret caret = editor.getCaretModel().getCurrentCaret();
                return FileEditorManagerEx.getInstanceEx(this.project).getData(dataId, editor, caret);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/console/LanguageConsoleImpl$Helper";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl$Helper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSafe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setupEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditorData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

