/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModuleProblemDescriptorImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OfflineDescriptorResolveResult {
    private static final Logger LOG = Logger.getInstance(OfflineDescriptorResolveResult.class);
    private final RefEntity myResolvedEntity;
    private final CommonProblemDescriptor myResolvedDescriptor;
    private volatile boolean myExcluded;

    private OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.myExcluded = excluded;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor, @NotNull InspectionToolWrapper wrapper2, @NotNull InspectionToolPresentation presentation) {
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(0);
        }
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(2);
        }
        RefEntity element = descriptor.getRefElement(presentation.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = (CommonProblemDescriptor)ReadAction.compute(() -> OfflineDescriptorResolveResult.createDescriptor(element, descriptor, wrapper2, presentation));
        OfflineDescriptorResolveResult offlineDescriptorResolveResult = new OfflineDescriptorResolveResult(element, resolvedDescriptor);
        if (offlineDescriptorResolveResult == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(3);
        }
        return offlineDescriptorResolveResult;
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (offlineDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(4);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(6);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor = OfflineDescriptorResolveResult.createDescriptor(element, offlineDescriptor, localTool, presentation)) != null) {
                return descriptor;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element, offlineDescriptor);
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)presentation.getContext().getProject());
        OfflineProblemDescriptor offlineProblemDescriptor = offlineDescriptor;
        if (element instanceof RefElement) {
            ProblemDescriptor descriptor;
            PsiElement psiElement = ((RefElement)element).getPsiElement();
            if (psiElement != null && (descriptor = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> OfflineDescriptorResolveResult.runLocalTool(psiElement, offlineProblemDescriptor, (LocalInspectionToolWrapper)toolWrapper, inspectionManager, presentation.getContext()), (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        CommonProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor, hints, presentation);
        if (quickFixes != null) {
            descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        return descriptor;
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContextImpl context) {
        if (psiElement == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(7);
        }
        if (offlineProblemDescriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(8);
        }
        if (toolWrapper == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(9);
        }
        if (inspectionManager == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(11);
        }
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        TextRange textRange = psiElement.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("text range muse be not null here; isValid = " + psiElement.isValid() + ", isPhysical = " + psiElement.isPhysical() + ", containingFile = " + containingFile.getName() + ", inspection = " + toolWrapper.getShortName()));
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        final PsiElementVisitor visitor = localTool.buildVisitor(holder, true, session2);
        localTool.inspectionStarted(session2, false);
        PsiElement[] elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, startOffset, endOffset);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)context.getProject());
        for (PsiElement element : elementsInRange) {
            List injectedPsiFiles = injectedLanguageManager.getInjectedPsiFiles(element);
            if (injectedPsiFiles != null) {
                for (Pair file2 : injectedPsiFiles) {
                    ((PsiElement)file2.getFirst()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            element.accept(visitor);
                            super.visitElement(element);
                        }
                    });
                }
            }
            element.accept(visitor);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list2 = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor : list2) {
                PsiNamedElement member = BatchModeDescriptorsUtil.getContainerElement(descriptor.getPsiElement(), localTool, context);
                if (!(psiElement instanceof PsiFile) && !psiElement.equals(member)) continue;
                if (curIdx == idx) {
                    return descriptor;
                }
                ++curIdx;
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    @Nullable
    private static LocalQuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor, List<String> hints, InspectionToolPresentation presentation) {
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(13);
        }
        ArrayList fixes = new ArrayList(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor, List<? super LocalQuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        IntentionAction intentionAction;
        if (descriptor == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(14);
        }
        if ((intentionAction = presentation.findQuickFixes(descriptor, hint)) instanceof QuickFixWrapper) {
            fixes.add((LocalQuickFix)((QuickFixWrapper)intentionAction).getFix());
        }
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper2, final @Nullable RefEntity entity, OfflineProblemDescriptor offlineDescriptor) {
        if (wrapper2 == null) {
            OfflineDescriptorResolveResult.$$$reportNull$$$0(15);
        }
        QuickFix rerunFix = new QuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = "Rerun '" + wrapper2.getDisplayName() + "' inspection";
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                }
                RunInspectionAction.runInspection(project, wrapper2.getShortName(), file2, null, psiFile);
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        List hints = offlineDescriptor.getHints();
        if (hints != null && entity instanceof RefModule) {
            List<QuickFix> fixes = hints.stream().map(hint -> ((GlobalInspectionTool)wrapper2.getTool()).getQuickFix(hint)).filter(f -> f != null).collect(Collectors.toList());
            return new ModuleProblemDescriptorImpl((QuickFix[])ArrayUtil.append((Object[])fixes.toArray(QuickFix.EMPTY_ARRAY), (Object)rerunFix), offlineDescriptor.getDescription(), ((RefModule)entity).getModule());
        }
        return new CommonProblemDescriptorImpl(new QuickFix[]{rerunFix}, offlineDescriptor.getDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDescriptor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineProblemDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/offlineViewer/OfflineDescriptorResolveResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsIntersectingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runLocalTool";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRerunGlobalToolDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

