/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.module;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;

public final class ModuleDescriptor {
    private String name;
    private String description;
    private int priority = ModulePriority.DEFAULT.getPriority();
    private String supportURL;
    private final List<ModuleInputOutputType> inputTypes;
    public final ModuleCategory category;

    ModuleDescriptor(ModuleCategory category, String name, String description, int priority, String supportURL, ModuleInputOutputType ... inputTypes) {
        this.category = Optional.ofNullable(category).orElse(ModuleCategory.OTHER);
        this.name = name;
        this.description = description;
        this.priority = priority;
        this.supportURL = supportURL;
        this.inputTypes = Optional.ofNullable(inputTypes).filter(t -> ((ModuleInputOutputType[])t).length > 0).map(Arrays::asList).orElseGet(() -> Arrays.asList(ModuleInputOutputType.OTHER));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public Optional<String> getSupportURL() {
        return Optional.ofNullable((String)StringUtils.defaultIfBlank((CharSequence)this.supportURL, null));
    }

    public boolean hasInputType(ModuleInputOutputType type) {
        return this.inputTypes.contains((Object)type);
    }
}

