/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.action;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;

public class PDActionURI
extends PDAction {
    public static final String SUB_TYPE = "URI";

    public PDActionURI() {
        this.setSubType(SUB_TYPE);
    }

    public PDActionURI(COSDictionary a) {
        super(a);
    }

    @Deprecated
    public String getS() {
        return this.action.getNameAsString(COSName.S);
    }

    @Deprecated
    public void setS(String s) {
        this.action.setName(COSName.S, s);
    }

    public String getURI() {
        COSString base = this.action.getDictionaryObject(COSName.URI, COSString.class);
        if (Objects.nonNull(base)) {
            byte[] bytes = base.getBytes();
            if (bytes.length >= 2) {
                if ((bytes[0] & 0xFF) == 254 && (bytes[1] & 0xFF) == 255) {
                    return this.action.getString(COSName.URI);
                }
                if ((bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254) {
                    return this.action.getString(COSName.URI);
                }
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    public void setURI(String uri) {
        this.action.setString(COSName.URI, uri);
    }

    public boolean shouldTrackMousePosition() {
        return this.action.getBoolean("IsMap", false);
    }

    public void setTrackMousePosition(boolean value) {
        this.action.setBoolean("IsMap", value);
    }
}

