/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.SQLStatementExecutor;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SQLExecutionHelper {
    private static final Logger LOGGER = Logger.getLogger(SQLExecutionHelper.class.getName());
    private final DataView dataView;
    private final RequestProcessor rp = new RequestProcessor("SQLStatementExecution", 20, true);
    private static final String LIMIT_CLAUSE = "LIMIT ";
    public static final String OFFSET_CLAUSE = "OFFSET ";
    private static Pattern GROUP_BY_IN_SELECT = null;
    private boolean limitSupported = false;
    private boolean useScrollableCursors = false;
    private int resultSetScrollType = 1003;
    private boolean supportesMultipleResultSets = false;

    SQLExecutionHelper(DataView dataView) {
        this.dataView = dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialDataLoad() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must be called off the EDT!";
        class Loader
        implements Runnable,
        Cancellable {
            private boolean finished = false;
            private Connection conn = null;
            private Statement stmt = null;
            private Thread loaderThread = null;

            Loader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                this.loaderThread = Thread.currentThread();
                try {
                    Object dc = SQLExecutionHelper.this.dataView.getDatabaseConnection();
                    this.conn = DBConnectionFactory.getInstance().getConnection((DatabaseConnection)dc);
                    this.checkNonNullConnection(this.conn);
                    this.checkSupportForMultipleResultSets(this.conn);
                    DBMetaDataFactory dbMeta = new DBMetaDataFactory(this.conn);
                    SQLExecutionHelper.this.limitSupported = dbMeta.supportsLimit();
                    String sql = SQLExecutionHelper.this.dataView.getSQLString();
                    boolean isSelect = SQLExecutionHelper.this.isSelectStatement(sql);
                    SQLExecutionHelper.this.updateScrollableSupport(this.conn, dc, sql);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, sql);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    boolean isResultSet = SQLExecutionHelper.this.executeSQLStatementForExtraction(this.stmt, sql);
                    int updateCount = -1;
                    if (!isResultSet) {
                        updateCount = this.stmt.getUpdateCount();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    do {
                        if (isResultSet) {
                            ResultSet rs = this.stmt.getResultSet();
                            Collection<DBTable> tables = dbMeta.generateDBTables(rs, sql, isSelect);
                            DataViewDBTable dvTable = new DataViewDBTable(tables);
                            DataViewPageContext pageContext = SQLExecutionHelper.this.dataView.addPageContext(dvTable);
                            SQLExecutionHelper.this.loadDataFrom(pageContext, rs);
                            DataViewUtils.closeResources(rs);
                            dbMeta.postprocessTables(tables);
                        } else {
                            DataView dataView = SQLExecutionHelper.this.dataView;
                            synchronized (dataView) {
                                SQLExecutionHelper.this.dataView.addUpdateCount(updateCount);
                            }
                        }
                        if (!SQLExecutionHelper.this.supportesMultipleResultSets) return;
                        isResultSet = this.stmt.getMoreResults();
                        updateCount = this.stmt.getUpdateCount();
                    } while (isResultSet || updateCount != -1);
                    return;
                }
                catch (RuntimeException | SQLException sqlEx) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SQLExecutionHelper.this.dataView.setErrorStatusText(conn, stmt, sqlEx);
                            }
                        });
                        return;
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        assert (false);
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.loaderThread = null;
                    DataViewUtils.closeResources(this.stmt);
                    Loader loader = this;
                    synchronized (loader) {
                        this.finished = true;
                        this.notifyAll();
                        return;
                    }
                }
                finally {
                    this.loaderThread = null;
                    DataViewUtils.closeResources(this.stmt);
                    Loader loader = this;
                    synchronized (loader) {
                        this.finished = true;
                        this.notifyAll();
                    }
                }
            }

            public boolean cancel() {
                if (this.stmt != null) {
                    try {
                        this.stmt.cancel();
                    }
                    catch (SQLException sqlEx) {
                        LOGGER.log(Level.FINE, null, sqlEx);
                    }
                }
                if (this.loaderThread != null) {
                    try {
                        this.loaderThread.interrupt();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                return true;
            }

            private void checkNonNullConnection(Connection conn) throws SQLException {
                if (conn == null) {
                    Throwable t = DBConnectionFactory.getInstance().getLastException();
                    String msg = t != null ? t.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)SQLExecutionHelper.this.dataView.getDatabaseConnection());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                    LOGGER.log(Level.INFO, msg, t);
                    throw new SQLException(msg, t);
                }
            }

            private void checkSupportForMultipleResultSets(Connection conn) {
                try {
                    SQLExecutionHelper.this.supportesMultipleResultSets = conn.getMetaData().supportsMultipleResultSets();
                }
                catch (RuntimeException | SQLException e) {
                    LOGGER.log(Level.INFO, "Database driver throws exception when checking for multiple resultset support.");
                    LOGGER.log(Level.FINE, null, e);
                }
            }
        }
        Loader loader = new Loader();
        Future f = this.rp.submit((Runnable)loader);
        try {
            f.get();
        }
        catch (InterruptedException ex) {
            f.cancel(true);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
        Loader loader2 = loader;
        synchronized (loader2) {
            while (!loader.finished) {
                try {
                    loader.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeInsertRow(final DataViewPageContext pageContext, DBTable table, String[] insertSQLs, Object[][] insertedRows) {
        Boolean needRequery;
        assert (!SwingUtilities.isEventDispatchThread());
        this.dataView.setEditable(false);
        int done = 0;
        Exception caughtException = null;
        try {
            Connection conn = this.dataView.getDatabaseConnection().getJDBCConnection();
            List<DBColumn> columns = table.getColumnList();
            for (int j = 0; j < insertSQLs.length; ++j) {
                try (PreparedStatement pstmt = conn.prepareStatement(insertSQLs[j]);){
                    int pos = 1;
                    for (int i = 0; i < insertedRows[j].length; ++i) {
                        Object val = insertedRows[j][i];
                        if (DataViewUtils.isSQLConstantString(val, columns.get(i))) continue;
                        int colType = columns.get(i).getJdbcType();
                        DBReadWriteHelper.setAttributeValue(pstmt, pos++, colType, val);
                    }
                    int rows = pstmt.executeUpdate();
                    if (rows != 1) {
                        throw new SQLException("MSG_failure_insert_rows");
                    }
                    ++done;
                    continue;
                }
            }
        }
        catch (SQLException | DBException ex) {
            LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            caughtException = ex;
        }
        finally {
            this.dataView.resetEditable();
        }
        final Exception finalCaught = caughtException;
        try {
            needRequery = (Boolean)Mutex.EVENT.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() {
                    if (finalCaught != null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)finalCaught.getLocalizedMessage()));
                    }
                    return pageContext.refreshRequiredOnInsert();
                }
            });
        }
        catch (MutexException ex) {
            needRequery = true;
        }
        if (needRequery.booleanValue()) {
            this.executeQuery();
        } else {
            Mutex.EVENT.writeAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataView dataView = SQLExecutionHelper.this.dataView;
                    synchronized (dataView) {
                        SQLExecutionHelper.this.dataView.resetToolbar(false);
                    }
                }
            });
        }
        return done;
    }

    void executeDeleteRow(DataViewPageContext pageContext, DBTable table, DataViewTableUI rsTable) {
        this.dataView.setEditable(false);
        SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_delete");
        class DeleteElement {
            public List<Object> values = new ArrayList<Object>();
            public List<Integer> types = new ArrayList<Integer>();
            public String sql;

            DeleteElement() {
            }
        }
        final ArrayList<DeleteElement> rows = new ArrayList<DeleteElement>();
        for (int viewRow : rsTable.getSelectedRows()) {
            int modelRow = rsTable.convertRowIndexToModel(viewRow);
            DeleteElement de = new DeleteElement();
            de.sql = generator.generateDeleteStatement(table, de.types, de.values, modelRow, rsTable.getModel());
            rows.add(de);
        }
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, "", true){

            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                for (DeleteElement de : rows) {
                    if (Thread.currentThread().isInterrupted() || this.error) break;
                    this.deleteARow(de);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void deleteARow(DeleteElement deleteRow) throws SQLException, DBException {
                PreparedStatement pstmt = this.conn.prepareStatement(deleteRow.sql);
                try {
                    int pos = 1;
                    for (Object val : deleteRow.values) {
                        DBReadWriteHelper.setAttributeValue(pstmt, pos, deleteRow.types.get(pos - 1), val);
                        ++pos;
                    }
                    int rows2 = SQLExecutionHelper.this.executePreparedStatement(pstmt);
                    if (rows2 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (rows2 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.resetEditable();
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_delete_command"));
            }

            @Override
            protected void executeOnSuccess() {
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeUpdateRow(DBTable table, final DataViewTableUI rsTable, boolean selectedOnly) {
        this.dataView.setEditable(false);
        SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
        DataViewTableUIModel dataViewTableUIModel = rsTable.getModel();
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_update");
        class UpdateElement {
            public List<Object> values = new ArrayList<Object>();
            public List<Integer> types = new ArrayList<Integer>();
            public String sql;
            public Integer key;

            UpdateElement() {
            }
        }
        final ArrayList<UpdateElement> updateSet = new ArrayList<UpdateElement>();
        int[] viewRows = rsTable.getSelectedRows();
        ArrayList<Integer> modelRows = new ArrayList<Integer>();
        Object object = viewRows;
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer viewRow = object[i];
            modelRows.add(rsTable.convertRowIndexToModel(viewRow));
        }
        object = dataViewTableUIModel.getUpdateKeys().iterator();
        while (object.hasNext()) {
            Integer key = (Integer)object.next();
            if (!modelRows.contains(key) && selectedOnly) continue;
            UpdateElement ue = new UpdateElement();
            try {
                ue.key = key;
                ue.sql = generator.generateUpdateStatement(table, key, dataViewTableUIModel.getChangedData(key), ue.values, ue.types, rsTable.getModel());
                updateSet.add(ue);
            }
            catch (DBException ex) {
                throw new RuntimeException(ex);
            }
        }
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, "", true){
            private PreparedStatement pstmt;
            private final Set<Integer> keysToRemove;
            {
                super(parent, title, msg, runInTransaction);
                this.keysToRemove = new HashSet<Integer>();
            }

            @Override
            public void execute() throws SQLException, DBException {
                for (UpdateElement ue : updateSet) {
                    if (Thread.interrupted()) break;
                    this.updateARow(ue);
                    this.keysToRemove.add(ue.key);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateARow(UpdateElement ue) throws SQLException, DBException {
                this.pstmt = this.conn.prepareStatement(ue.sql);
                int pos = 1;
                for (Object val : ue.values) {
                    DBReadWriteHelper.setAttributeValue(this.pstmt, pos, ue.types.get(pos - 1), val);
                    ++pos;
                }
                try {
                    int rows = SQLExecutionHelper.this.executePreparedStatement(this.pstmt);
                    if (rows == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_update");
                    } else if (rows > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(this.pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.resetEditable();
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_update_command"));
            }

            @Override
            protected void executeOnSuccess() {
                this.dataView.getSQLExecutionHelper().executeQuery();
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        DataViewTableUIModel tblContext = rsTable.getModel();
                        for (Integer key : keysToRemove) {
                            tblContext.removeUpdateForSelectedRow(key, false);
                        }
                        this.reinstateToolbar();
                    }
                });
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeTruncate(final DataViewPageContext pageContext, final DBTable dbTable) {
        String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_truncate_table_progress");
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_truncate");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, msg, true){
            private PreparedStatement stmt;
            {
                super(parent, title, msg, runInTransaction);
                this.stmt = null;
            }

            @Override
            public void execute() throws SQLException, DBException {
                String truncateSql = "TRUNCATE TABLE " + dbTable.getFullyQualifiedName(true);
                try {
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                catch (SQLException sqe) {
                    LOGGER.log(Level.FINE, "TRUNCATE Not supported...will try DELETE * \n");
                    truncateSql = "DELETE FROM " + dbTable.getFullyQualifiedName(true);
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                }
            }

            @Override
            public void finished() {
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_truncate_command"));
            }

            @Override
            protected void executeOnSuccess() {
                pageContext.first();
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeQueryOffEDT() {
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                SQLExecutionHelper.this.executeQuery();
            }
        });
    }

    void executeQuery() {
        assert (!SwingUtilities.isEventDispatchThread());
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executequery");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, this.dataView.getSQLString(), false){
            private Statement stmt;
            {
                this.stmt = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                String sql = this.dataView.getSQLString();
                if (Thread.interrupted()) {
                    return;
                }
                this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, sql);
                try {
                    if (Thread.interrupted()) {
                        return;
                    }
                    boolean isResultSet = SQLExecutionHelper.this.executeSQLStatementForExtraction(this.stmt, sql);
                    int updateCount = -1;
                    if (!isResultSet) {
                        updateCount = this.stmt.getUpdateCount();
                    }
                    ResultSet rs = null;
                    int res = -1;
                    do {
                        if (isResultSet) {
                            DataViewPageContext pageContext = this.dataView.getPageContext(++res);
                            rs = this.stmt.getResultSet();
                            SQLExecutionHelper.this.loadDataFrom(pageContext, rs);
                            DataViewUtils.closeResources(rs);
                        } else {
                            DataView dataView = this.dataView;
                            synchronized (dataView) {
                                this.dataView.addUpdateCount(updateCount);
                            }
                        }
                        if (!SQLExecutionHelper.this.supportesMultipleResultSets) return;
                        isResultSet = this.stmt.getMoreResults();
                        updateCount = this.stmt.getUpdateCount();
                    } while (isResultSet || updateCount != -1);
                    return;
                }
                catch (InterruptedException | SQLException sqlEx) {
                    LOGGER.log(Level.INFO, "Failed to retrieve resultset", sqlEx);
                    String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_error");
                    String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"Confirm_Close");
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(sqlEx.getMessage() + "\n" + msg), title, 2, 3);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) return;
                    this.dataView.removeComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished() {
                DataView dataView = this.dataView;
                synchronized (dataView) {
                    this.dataView.resetEditable();
                    if (this.error) {
                        this.dataView.setErrorStatusText(this.conn, this.stmt, this.ex);
                    }
                    this.dataView.resetToolbar(this.error);
                }
                DataViewUtils.closeResources(this.stmt);
            }

            @Override
            public boolean cancel() {
                boolean superResult = super.cancel();
                if (this.stmt != null) {
                    try {
                        this.stmt.cancel();
                    }
                    catch (SQLException sqlEx) {
                        LOGGER.log(Level.FINEST, null, sqlEx);
                    }
                }
                return superResult;
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    private void loadDataFrom(DataViewPageContext pageContext, ResultSet rs) throws SQLException, InterruptedException {
        if (rs == null) {
            return;
        }
        int pageSize = pageContext.getPageSize();
        int startFrom = this.useScrollableCursors ? pageContext.getCurrentPos() : (!this.limitSupported || this.isLimitUsedInSelect(this.dataView.getSQLString()) ? pageContext.getCurrentPos() : 0);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int colCnt = pageContext.getTableMetaData().getColumnCount();
        int curRowPos = 0;
        try {
            long start = System.currentTimeMillis();
            boolean hasNext = false;
            boolean needSlowSkip = true;
            if (this.useScrollableCursors && (rs.getType() == 1004 || rs.getType() == 1005)) {
                try {
                    hasNext = rs.absolute(startFrom);
                    curRowPos = rs.getRow();
                    needSlowSkip = false;
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.FINE, "Absolute positioning failed", ex);
                }
            }
            if (needSlowSkip) {
                hasNext = rs.next();
                ++curRowPos;
                while (hasNext && curRowPos < startFrom) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    hasNext = rs.next();
                    ++curRowPos;
                }
            }
            int rowCnt = 0;
            while ((pageSize <= 0 || pageSize > rowCnt) && hasNext) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Object[] row = new Object[colCnt];
                for (int i = 0; i < colCnt; ++i) {
                    row[i] = DBReadWriteHelper.readResultSet(rs, pageContext.getTableMetaData().getColumn(i), i + 1);
                }
                rows.add(row);
                ++rowCnt;
                try {
                    hasNext = rs.next();
                    ++curRowPos;
                }
                catch (SQLException x) {
                    LOGGER.log(Level.INFO, "Failed to forward to next record, cause: " + x.getLocalizedMessage(), x);
                    hasNext = false;
                }
            }
            long end = System.currentTimeMillis();
            this.dataView.addFetchTime(end - start);
        }
        catch (SQLException e) {
            try {
                LOGGER.log(Level.INFO, "Failed to set up table model.", e);
                throw e;
            }
            catch (Throwable throwable) {
                Mutex.EVENT.writeAccess(new Runnable(pageContext, rows){
                    final /* synthetic */ DataViewPageContext val$pageContext;
                    final /* synthetic */ List val$rows;
                    {
                        this.val$pageContext = dataViewPageContext;
                        this.val$rows = list;
                    }

                    @Override
                    public void run() {
                        this.val$pageContext.getModel().setData(this.val$rows);
                        this.val$pageContext.getModel().setRowOffset(this.val$pageContext.getCurrentPos() - 1);
                    }
                });
                throw throwable;
            }
        }
        Mutex.EVENT.writeAccess(new /* invalid duplicate definition of identical inner class */);
    }

    private Statement prepareSQLStatement(Connection conn, String sql) throws SQLException {
        Statement stmt;
        if (sql.startsWith("{")) {
            stmt = this.useScrollableCursors ? conn.prepareCall(sql, this.resultSetScrollType, 1007) : conn.prepareCall(sql);
        } else if (this.isSelectStatement(sql)) {
            stmt = this.useScrollableCursors ? conn.createStatement(this.resultSetScrollType, 1007) : conn.createStatement();
            SQLExecutionHelper.setFetchSize(stmt, 50);
            try {
                Integer maxRows = 0;
                for (DataViewPageContext pageContext : this.dataView.getPageContexts()) {
                    int currentRows = pageContext.getCurrentPos();
                    int pageSize = pageContext.getPageSize();
                    if (pageSize <= 0) {
                        maxRows = 0;
                        break;
                    }
                    maxRows = Math.max(maxRows, currentRows + pageSize);
                }
                stmt.setMaxRows(maxRows);
            }
            catch (SQLException exc) {
                LOGGER.log(Level.WARNING, "Unable to set Max row count", exc);
                try {
                    stmt.setMaxRows(0);
                }
                catch (SQLException sQLException) {}
            }
        } else {
            stmt = this.useScrollableCursors ? conn.createStatement(this.resultSetScrollType, 1007) : conn.createStatement();
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSQLStatementForExtraction(Statement stmt, String sql) throws SQLException {
        LOGGER.log(Level.FINE, "Statement: {0}", sql);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executestmt") + sql);
        long startTime = System.currentTimeMillis();
        boolean isResultSet = false;
        try {
            if (stmt instanceof PreparedStatement) {
                isResultSet = ((PreparedStatement)stmt).execute();
            } else {
                DataViewPageContext pc = this.dataView.getPageContexts().size() > 0 ? this.dataView.getPageContext(0) : null;
                isResultSet = stmt.execute(sql);
            }
        }
        catch (NullPointerException ex) {
            LOGGER.log(Level.INFO, "Failed to execute SQL Statement [{0}], cause: {1}", new Object[]{sql, ex});
            throw new SQLException(ex);
        }
        catch (SQLException sqlExc) {
            LOGGER.log(Level.INFO, "Failed to execute SQL Statement [{0}], cause: {1}", new Object[]{sql, sqlExc});
            throw sqlExc;
        }
        finally {
            this.extractWarnings(stmt);
        }
        long executionTime = System.currentTimeMillis() - startTime;
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setExecutionTime(executionTime);
        }
        return isResultSet;
    }

    private int executePreparedStatement(PreparedStatement stmt) throws SQLException {
        long startTime = System.currentTimeMillis();
        stmt.execute();
        long executionTime = System.currentTimeMillis() - startTime;
        String execTimeStr = SQLExecutionHelper.millisecondsToSeconds(executionTime);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_execution_success", (Object)execTimeStr));
        return stmt.getUpdateCount();
    }

    private boolean isSelectStatement(String queryString) {
        String sqlUpperTrimmed = queryString.trim().toUpperCase();
        return sqlUpperTrimmed.startsWith("SELECT") && !sqlUpperTrimmed.contains("INTO");
    }

    private boolean isLimitUsedInSelect(String sql) {
        return sql.toUpperCase().contains(LIMIT_CLAUSE);
    }

    static String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }

    private static void setFetchSize(Statement stmt, int fetchSize) {
        try {
            stmt.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            LOGGER.log(Level.INFO, "Unable to set Fetch size", e);
            try {
                stmt.setFetchSize(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void updateScrollableSupport(Connection conn, DatabaseConnection dc, String sql) {
        this.useScrollableCursors = dc.isUseScrollableCursors();
        if (!this.useScrollableCursors) {
            return;
        }
        String driverName = dc.getDriverClass();
        if (driverName != null && driverName.startsWith("org.apache.derby") && !this.isSelectStatement(sql)) {
            this.resultSetScrollType = 1003;
            return;
        }
        try {
            if (conn.getMetaData().supportsResultSetType(1004)) {
                this.resultSetScrollType = 1004;
            } else if (conn.getMetaData().supportsResultSetType(1005)) {
                this.resultSetScrollType = 1005;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Exception while querying database for scrollable resultset support");
        }
    }

    private void extractWarnings(Statement stmt) {
        SQLWarning warning;
        try {
            for (warning = stmt.getConnection().getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.dataView.addWarning(warning);
            }
            stmt.getConnection().clearWarnings();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve warnings", ex);
        }
        try {
            for (warning = stmt.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.dataView.addWarning(warning);
            }
            stmt.clearWarnings();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.FINE, "Failed to retrieve warnings", ex);
        }
    }
}

