/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ExportCommand
extends SvnCommand {
    private final SVNUrl url;
    private final File file;
    private final SVNRevision revision;
    private final boolean force;
    private final File destination;

    public ExportCommand(SVNUrl url, File destination, SVNRevision revision, boolean force) {
        this.url = url;
        this.destination = destination;
        this.revision = revision;
        this.force = force;
        this.file = null;
    }

    public ExportCommand(File file, File destination, boolean force) {
        this.file = file;
        this.destination = destination;
        this.force = force;
        this.revision = null;
        this.url = null;
    }

    @Override
    protected int getCommand() {
        return 2;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("export");
        if (this.revision != null) {
            arguments.add(this.revision);
        }
        if (this.url != null) {
            arguments.add(this.url);
            arguments.add(this.destination);
        } else {
            arguments.add(this.file);
            arguments.add(this.destination);
        }
        if (this.force) {
            arguments.add("--force");
        }
        this.setCommandWorkingDirectory(this.destination);
    }
}

