/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.openide.filesystems.FileObject;

public final class JavaRefactoringUtils {
    private JavaRefactoringUtils() {
    }

    public static Collection<ExecutableElement> getOverriddenMethods(ExecutableElement method, CompilationInfo info) {
        return RefactoringUtils.getOverridenMethods(method, info);
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement method, CompilationInfo info, AtomicBoolean cancel) {
        return RefactoringUtils.getOverridingMethods(method, info, cancel);
    }

    @Deprecated
    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement method, CompilationInfo info) {
        return RefactoringUtils.getOverridingMethods(method, info, new AtomicBoolean());
    }

    public static boolean isFromLibrary(ElementHandle<? extends Element> element, ClasspathInfo info) {
        return RefactoringUtils.isFromLibrary(element, info);
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        return RefactoringUtils.isOnSourceClasspath(fo);
    }

    public static boolean isRefactorable(FileObject file) {
        return RefactoringUtils.isRefactorable(file) && file.canWrite() && file.canRead();
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement type, CompilationInfo info, boolean sourceOnly) {
        return RefactoringUtils.getSuperTypes(type, info, sourceOnly);
    }

    public static TreePath findEnclosingClass(CompilationInfo javac, TreePath path, boolean isClass, boolean isInterface, boolean isEnum, boolean isAnnotation, boolean isAnonymous) {
        return RefactoringUtils.findEnclosingClass(javac, path, isClass, isInterface, isEnum, isAnnotation, isAnonymous);
    }

    public static List<TypeMirror> elementsToTypes(List<? extends Element> typeParams) {
        return RefactoringUtils.resolveTypeParamsAsTypes(typeParams);
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        return RefactoringUtils.getClasspathInfoFor(files);
    }

    public static List<TreePathHandle> treesToHandles(TreePath parent, Iterable<? extends Tree> trees, CompilationInfo info) {
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>(trees instanceof Collection ? ((Collection)trees).size() : 11);
        for (Tree tree : trees) {
            TreePath path = TreePath.getPath(parent, tree);
            TreePathHandle handle = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
            result.add(handle);
            assert (handle.resolve(info) != null) : "Newly created TreePathHandle resolves to null";
            assert (handle.resolve(info).getLeaf() != null) : "Newly created TreePathHandle.getLeaf() resolves to null";
        }
        return result;
    }

    public static List<TreePathHandle> treesToHandles(Iterable<? extends Tree> trees, CompilationInfo info) {
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>(trees instanceof Collection ? ((Collection)trees).size() : 11);
        for (Tree tree : trees) {
            TreePath path = TreePath.getPath(info.getCompilationUnit(), tree);
            if (path == null) {
                throw new IllegalArgumentException(tree + " does not belong to the same compilation unit passed to this method");
            }
            TreePathHandle handle = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
            result.add(handle);
            assert (handle.resolve(info) != null) : "Newly created TreePathHandle resolves to null";
            assert (handle.resolve(info).getLeaf() != null) : "Newly created TreePathHandle.getLeaf() resolves to null";
        }
        return result;
    }

    public static <T extends Element> List<T> handlesToElements(Iterable<ElementHandle<T>> handles, CompilationInfo info) {
        ArrayList<Element> result = new ArrayList<Element>(handles instanceof Collection ? ((Collection)handles).size() : 0);
        for (ElementHandle<T> h : handles) {
            Element element = h.resolve(info);
            assert (element != null) : element + " resolves to null";
            result.add(element);
        }
        return result;
    }

    public static List<TypeMirror> handlesToTypes(Iterable<? extends TypeMirrorHandle> types, CompilationInfo info) {
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>();
        for (TypeMirrorHandle typeMirrorHandle : types) {
            result.add(typeMirrorHandle.resolve(info));
        }
        return result;
    }

    public static List<TypeMirrorHandle> typesToHandles(Iterable<? extends TypeMirror> types) {
        ArrayList<TypeMirrorHandle> result = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror : types) {
            result.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
        }
        return result;
    }

    public static <T extends Element> List<ElementHandle<T>> elementsToHandles(Iterable<? extends T> elements) {
        ArrayList<ElementHandle<T>> result = new ArrayList<ElementHandle<T>>(elements instanceof Collection ? ((Collection)elements).size() : 11);
        for (Element element : elements) {
            ElementHandle handle = ElementHandle.create((Element)element);
            assert (handle != null) : "Couldn't create handle for " + element;
            result.add(handle);
        }
        return result;
    }

    public static Collection<TreePathHandle> getInvocationsOf(ElementHandle e, CompilationController wc) throws IOException {
        assert (e != null);
        assert (wc != null);
        wc.toPhase(JavaSource.Phase.RESOLVED);
        Element element = e.resolve((CompilationInfo)wc);
        TypeElement type = wc.getElementUtilities().enclosingTypeElement(element);
        ElementHandle elh = ElementHandle.create((Element)type);
        assert (elh != null);
        Set classes = wc.getClasspathInfo().getClassIndex().getElements(elh, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>();
        for (ElementHandle h : classes) {
            result.addAll(JavaRefactoringUtils.getReferencesToMember((ElementHandle<TypeElement>)h, wc.getClasspathInfo(), e));
        }
        return result;
    }

    public static Collection<TreePathHandle> getReferencesToMember(ElementHandle<TypeElement> on, ClasspathInfo info, ElementHandle toFind) throws IOException {
        FileObject ob = SourceUtils.getFile(on, (ClasspathInfo)info);
        assert (ob != null) : "SourceUtils.getFile(" + on + ") returned null";
        JavaSource src = JavaSource.forFileObject((FileObject)ob);
        InvocationScanner scanner = new InvocationScanner(toFind);
        src.runUserActionTask((Task)scanner, true);
        return scanner.usages;
    }

    public static void cacheTreePathInfo(TreePath tp, CompilationInfo info) {
        ElementGripFactory.getDefault().put(info.getFileObject(), tp, info);
    }

    private static final class InvocationScanner
    extends ErrorAwareTreePathScanner<Tree, ElementHandle>
    implements CancellableTask<CompilationController> {
        private CompilationController cc;
        private final ElementHandle toFind;
        Set<TreePathHandle> usages = new HashSet<TreePathHandle>();
        boolean cancelled;

        InvocationScanner(ElementHandle toFind) {
            this.toFind = toFind;
        }

        public Tree visitMemberSelect(MemberSelectTree node, ElementHandle p) {
            assert (this.cc != null);
            Element e = p.resolve((CompilationInfo)this.cc);
            this.addIfMatch(this.getCurrentPath(), node, e);
            return (Tree)super.visitMemberSelect(node, (Object)p);
        }

        private void addIfMatch(TreePath path, Tree tree, Element elementToFind) {
            if (this.cc.getTreeUtilities().isSynthetic(path)) {
                return;
            }
            Element el = this.cc.getTrees().getElement(path);
            if (el == null) {
                return;
            }
            if (elementToFind.getKind() == ElementKind.METHOD && el.getKind() == ElementKind.METHOD) {
                if (el.equals(elementToFind) || this.cc.getElements().overrides((ExecutableElement)el, (ExecutableElement)elementToFind, (TypeElement)elementToFind.getEnclosingElement())) {
                    this.addUsage(this.getCurrentPath());
                }
            } else if (el.equals(elementToFind)) {
                this.addUsage(this.getCurrentPath());
            }
        }

        void addUsage(TreePath path) {
            this.usages.add(TreePathHandle.create((TreePath)path, (CompilationInfo)this.cc));
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(CompilationController cc) throws Exception {
            if (this.cancelled) {
                return;
            }
            cc.toPhase(JavaSource.Phase.RESOLVED);
            if (this.cancelled) {
                return;
            }
            this.cc = cc;
            try {
                TreePath path = new TreePath(cc.getCompilationUnit());
                this.scan(path, this.toFind);
            }
            finally {
                this.cc = null;
            }
        }
    }
}

