/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jdk.jshell.execution.JdiDefaultExecutionControl;
import jdk.jshell.execution.RemoteExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;

public class JdiExecutionControlProvider
implements ExecutionControlProvider {
    public static final String PARAM_REMOTE_AGENT = "remoteAgent";
    public static final String PARAM_TIMEOUT = "timeout";
    public static final String PARAM_HOST_NAME = "hostname";
    public static final String PARAM_LAUNCH = "launch";
    private static final int DEFAULT_TIMEOUT = 5000;

    @Override
    public String name() {
        return "jdi";
    }

    @Override
    public Map<String, String> defaultParameters() {
        HashMap<String, String> dp = new HashMap<String, String>();
        dp.put(PARAM_REMOTE_AGENT, RemoteExecutionControl.class.getName());
        dp.put(PARAM_TIMEOUT, "5000");
        dp.put(PARAM_HOST_NAME, "");
        dp.put(PARAM_LAUNCH, "false");
        return dp;
    }

    @Override
    public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) throws IOException {
        Map<String, String> dp = this.defaultParameters();
        if (parameters == null) {
            parameters = dp;
        }
        String remoteAgent = parameters.getOrDefault(PARAM_REMOTE_AGENT, dp.get(PARAM_REMOTE_AGENT));
        int timeout = Integer.parseUnsignedInt(parameters.getOrDefault(PARAM_TIMEOUT, dp.get(PARAM_TIMEOUT)));
        String host = parameters.getOrDefault(PARAM_HOST_NAME, dp.get(PARAM_HOST_NAME));
        String sIsLaunch = parameters.getOrDefault(PARAM_LAUNCH, dp.get(PARAM_LAUNCH)).toLowerCase(Locale.ROOT);
        boolean isLaunch = sIsLaunch.length() > 0 && ("true".startsWith(sIsLaunch) || "yes".startsWith(sIsLaunch));
        return JdiDefaultExecutionControl.create(env, remoteAgent, isLaunch, host, timeout);
    }
}

