/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionManager;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.ItemsListener;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.PaintersListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.canvas.InteractiveCanvasComponent;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;

public class ChartComponent
extends InteractiveCanvasComponent {
    private RenderingHints renderingHints;
    private List<ChartDecorator> preDecorators;
    private List<ChartDecorator> postDecorators;
    private ItemsModel itemsModel;
    private PaintersModel paintersModel;
    protected LongRect dataBounds;
    private LongRect initialDataBounds;
    private ChartContext chartContext;
    private ItemsModelListener itemsListener;
    private PaintersModelListener paintersListener;
    private List<ChartOverlay> overlays;
    private ChartSelectionModel selectionModel;
    private SelectionListener selectionListener;
    private List<ChartConfigurationListener> configurationListeners;

    public ChartComponent() {
        this.initRenderingHints();
        this.itemsListener = new ItemsModelListener();
        this.paintersListener = new PaintersModelListener();
        this.dataBounds = new LongRect();
        this.initialDataBounds = new LongRect();
        this.setLayout(null);
        this.setSelectionModel(new ChartSelectionManager());
    }

    public final void setItemsModel(ItemsModel itemsModel) {
        if (itemsModel == null) {
            throw new IllegalArgumentException("ItemsModel cannot be null");
        }
        if (itemsModel == this.itemsModel) {
            return;
        }
        if (this.itemsModel != null) {
            this.itemsModel.removeItemsListener(this.itemsListener);
        }
        this.itemsModel = itemsModel;
        this.itemsModel.addItemsListener(this.itemsListener);
        this.updateChart();
    }

    public final ItemsModel getItemsModel() {
        return this.itemsModel;
    }

    public final void setPaintersModel(PaintersModel paintersModel) {
        if (paintersModel == null) {
            throw new IllegalArgumentException("PaintersModel cannot be null");
        }
        if (paintersModel == this.paintersModel) {
            return;
        }
        if (this.paintersModel != null) {
            this.paintersModel.removePaintersListener(this.paintersListener);
        }
        this.paintersModel = paintersModel;
        this.paintersModel.addPaintersListener(this.paintersListener);
        this.updateChart();
    }

    public final PaintersModel getPaintersModel() {
        return this.paintersModel;
    }

    public final void setSelectionModel(ChartSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeSelectionListener(this.selectionListener);
            if (this.selectionModel instanceof ChartSelectionManager) {
                ((ChartSelectionManager)this.selectionModel).unregisterChart(this);
            }
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            if (this.selectionListener == null) {
                this.selectionListener = new SelectionListener();
            }
            selectionModel.addSelectionListener(this.selectionListener);
            if (selectionModel instanceof ChartSelectionManager) {
                ((ChartSelectionManager)selectionModel).registerChart(this);
            }
        } else {
            this.selectionListener = null;
        }
    }

    public final ChartSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public final void setInitialDataBounds(LongRect bounds) {
        if (LongRect.equals(bounds, this.initialDataBounds)) {
            return;
        }
        LongRect.set(this.initialDataBounds, bounds);
        if (LongRect.isEmpty(this.dataBounds)) {
            this.resizeChart();
            this.invalidateImage();
            this.repaintDirty();
        }
    }

    public final LongRect getInitialDataBounds() {
        return this.initialDataBounds;
    }

    public final void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = Utils.checkedRenderingHints(renderingHints);
    }

    public final RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    private void applyRenderingHints(Graphics2D g) {
        if (this.renderingHints != null) {
            g.setRenderingHints(this.renderingHints);
        }
    }

    private void initRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.setRenderingHints(hints);
    }

    public final ChartContext getChartContext() {
        return this.getChartContext(null);
    }

    protected ChartContext getChartContext(ChartItem item) {
        if (this.chartContext == null) {
            this.chartContext = this.createChartContext();
        }
        return this.chartContext;
    }

    protected ChartContext createChartContext() {
        return new Context(this);
    }

    public final void addConfigurationListener(ChartConfigurationListener listener) {
        if (this.configurationListeners == null) {
            this.configurationListeners = new ArrayList<ChartConfigurationListener>();
        }
        this.configurationListeners.add(listener);
    }

    public final void removeConfigurationListener(ChartConfigurationListener listener) {
        if (this.configurationListeners == null) {
            return;
        }
        this.configurationListeners.remove(listener);
    }

    @Override
    protected final void offsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
        super.offsetChanged(oldOffsetX, oldOffsetY, newOffsetX, newOffsetY);
        this.fireOffsetChanged(oldOffsetX, oldOffsetY, newOffsetX, newOffsetY);
    }

    @Override
    protected final void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
        super.scaleChanged(oldScaleX, oldScaleY, newScaleX, newScaleY);
        this.fireScaleChanged(oldScaleX, oldScaleY, newScaleX, newScaleY);
    }

    @Override
    protected final void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
        super.dataBoundsChanged(dataOffsetX, dataOffsetY, dataWidth, dataHeight, oldDataOffsetX, oldDataOffsetY, oldDataWidth, oldDataHeight);
        this.fireDataBoundsChanged(dataOffsetX, dataOffsetY, dataWidth, dataHeight, oldDataOffsetX, oldDataOffsetY, oldDataWidth, oldDataHeight);
    }

    @Override
    protected final void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
        super.contentsWillBeUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY);
        this.fireContentsWillBeUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY);
    }

    @Override
    protected final void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
        super.contentsUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY, shiftX, shiftY);
        this.fireContentsUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY, shiftX, shiftY);
    }

    private void fireOffsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener listener : this.configurationListeners) {
            listener.offsetChanged(oldOffsetX, oldOffsetY, newOffsetX, newOffsetY);
        }
    }

    private void fireScaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener listener : this.configurationListeners) {
            listener.scaleChanged(oldScaleX, oldScaleY, newScaleX, newScaleY);
        }
    }

    private void fireDataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener listener : this.configurationListeners) {
            listener.dataBoundsChanged(dataOffsetX, dataOffsetY, dataWidth, dataHeight, oldDataOffsetX, oldDataOffsetY, oldDataWidth, oldDataHeight);
        }
    }

    private void fireContentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener listener : this.configurationListeners) {
            listener.contentsWillBeUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY);
        }
    }

    private void fireContentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
        if (this.configurationListeners == null) {
            return;
        }
        for (ChartConfigurationListener listener : this.configurationListeners) {
            listener.contentsUpdated(offsetX, offsetY, scaleX, scaleY, lastOffsetX, lastOffsetY, lastScaleX, lastScaleY, shiftX, shiftY);
        }
    }

    public final void addPreDecorator(ChartDecorator decorator) {
        if (this.preDecorators == null) {
            this.preDecorators = new ArrayList<ChartDecorator>(2);
        }
        this.preDecorators.add(decorator);
    }

    public final void removePreDecorator(ChartDecorator decorator) {
        if (this.preDecorators != null) {
            this.preDecorators.remove(decorator);
        }
    }

    final List<ChartDecorator> getPreDecorators() {
        return this.preDecorators;
    }

    public final void addPostDecorator(ChartDecorator decorator) {
        if (this.postDecorators == null) {
            this.postDecorators = new ArrayList<ChartDecorator>(2);
        }
        this.postDecorators.add(decorator);
    }

    public final void removePostDecorator(ChartDecorator decorator) {
        if (this.postDecorators != null) {
            this.postDecorators.remove(decorator);
        }
    }

    final List<ChartDecorator> getPostDecorators() {
        return this.postDecorators;
    }

    public final void addOverlayComponent(ChartOverlay overlay) {
        if (this.overlays == null) {
            this.overlays = new ArrayList<ChartOverlay>();
        }
        overlay.setChartContext(this.getChartContext());
        this.overlays.add(overlay);
        this.add(overlay);
    }

    public final void removeOverlayComponent(ChartOverlay overlay) {
        this.remove(overlay);
        this.overlays.remove(overlay);
        overlay.setChartContext(null);
    }

    @Override
    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        super.reshaped(oldBounds, newBounds);
        if (this.overlays == null) {
            return;
        }
        for (ChartOverlay overlay : this.overlays) {
            overlay.setBounds(0, 0, newBounds.width, newBounds.height);
        }
    }

    @Override
    protected void paintContents(Graphics g, Rectangle invalidArea) {
        int itemsCount;
        Graphics2D g2 = (Graphics2D)g;
        g2.setClip(invalidArea);
        this.applyRenderingHints(g2);
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(invalidArea.x, invalidArea.y, invalidArea.width, invalidArea.height);
        }
        if (this.preDecorators != null) {
            for (ChartDecorator decorator : this.preDecorators) {
                decorator.paint(g2, invalidArea, this.getChartContext());
            }
        }
        if (this.itemsModel != null && this.paintersModel != null && (itemsCount = this.itemsModel.getItemsCount()) != 0) {
            boolean sel = this.selectionModel != null;
            List<ItemSelection> highlightedSelection = sel ? this.selectionModel.getHighlightedItems() : null;
            List<ItemSelection> selectedSelection = sel ? this.selectionModel.getSelectedItems() : null;
            List filteredHighlighted = sel ? new ArrayList() : Collections.EMPTY_LIST;
            List filteredSelected = sel ? new ArrayList() : Collections.EMPTY_LIST;
            for (int i = 0; i < itemsCount; ++i) {
                ChartItem item = this.itemsModel.getItem(i);
                ItemPainter painter = this.paintersModel.getPainter(item);
                if (sel) {
                    filteredHighlighted.clear();
                    if (painter.supportsHovering(item)) {
                        ChartComponent.filterSelection(highlightedSelection, filteredHighlighted, item);
                    }
                    filteredSelected.clear();
                    if (painter.supportsSelecting(item)) {
                        ChartComponent.filterSelection(selectedSelection, filteredSelected, item);
                    }
                }
                painter.paintItem(item, filteredHighlighted, filteredSelected, g2, invalidArea, this.getChartContext(item));
            }
        }
        if (this.postDecorators != null) {
            for (ChartDecorator decorator : this.postDecorators) {
                decorator.paint(g2, invalidArea, this.getChartContext());
            }
        }
    }

    private static void filterSelection(List<ItemSelection> selection, List<ItemSelection> result, ChartItem filter) {
        if (filter == null) {
            return;
        }
        for (ItemSelection sel : selection) {
            if (!sel.getItem().equals(filter)) continue;
            result.add(sel);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(Utils.checkedColor(bg));
    }

    protected void computeDataBounds() {
        LongRect.clear(this.dataBounds);
        if (this.itemsModel == null || this.paintersModel == null) {
            return;
        }
        int itemsCount = this.itemsModel.getItemsCount();
        for (int i = 0; i < itemsCount; ++i) {
            ChartItem item = this.itemsModel.getItem(i);
            ItemPainter painter = this.paintersModel.getPainter(item);
            if (i == 0) {
                LongRect.set(this.dataBounds, painter.getItemBounds(item));
                continue;
            }
            LongRect.add(this.dataBounds, painter.getItemBounds(item));
        }
    }

    protected void resizeChart() {
        if (LongRect.isEmpty(this.dataBounds)) {
            LongRect bounds = new LongRect(this.dataBounds);
            if (bounds.width == 0L) {
                bounds.width = this.initialDataBounds.width;
                if (bounds.x == 0L) {
                    bounds.x = this.initialDataBounds.x;
                }
            }
            if (bounds.height == 0L) {
                bounds.height = this.initialDataBounds.height;
                if (bounds.y == 0L) {
                    bounds.y = this.initialDataBounds.y;
                }
            }
            this.setDataBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            this.setDataBounds(this.dataBounds.x, this.dataBounds.y, this.dataBounds.width, this.dataBounds.height);
        }
    }

    protected void updateChart() {
        this.computeDataBounds();
        this.resizeChart();
        this.invalidateImage();
        this.repaintDirty();
    }

    protected void itemsAdded(List<ChartItem> addedItems) {
        LongRect oldBounds = new LongRect(this.dataBounds);
        for (ChartItem item : addedItems) {
            ItemPainter painter = this.paintersModel.getPainter(item);
            LongRect.add(this.dataBounds, painter.getItemBounds(item));
        }
        if (!LongRect.equals(oldBounds, this.dataBounds)) {
            this.resizeChart();
        }
        LongRect uiBounds = null;
        for (ChartItem item : addedItems) {
            ItemPainter painter = this.paintersModel.getPainter(item);
            if (uiBounds == null) {
                uiBounds = new LongRect(painter.getItemBounds(item, this.getChartContext(item)));
                continue;
            }
            LongRect.add(uiBounds, painter.getItemBounds(item, this.getChartContext(item)));
        }
        this.invalidateImage(Utils.checkedRectangle(uiBounds));
        this.repaintDirty();
    }

    protected void itemsRemoved(List<ChartItem> removedItems) {
        ArrayList<ItemPainter> painters = new ArrayList<ItemPainter>(removedItems.size());
        for (ChartItem item : removedItems) {
            ItemPainter painter = this.paintersModel.getPainter(item);
            if (painter == null) {
                painters = null;
                break;
            }
            painters.add(painter);
        }
        if (painters == null) {
            this.updateChart();
        } else {
            LongRect oldBounds = new LongRect(this.dataBounds);
            this.computeDataBounds();
            if (!LongRect.equals(oldBounds, this.dataBounds)) {
                this.resizeChart();
            }
            LongRect uiBounds = null;
            for (int i = 0; i < removedItems.size(); ++i) {
                ChartItem item = removedItems.get(i);
                ItemPainter painter = (ItemPainter)painters.get(i);
                if (uiBounds == null) {
                    uiBounds = new LongRect(painter.getItemBounds(item, this.getChartContext(item)));
                    continue;
                }
                LongRect.add(uiBounds, painter.getItemBounds(item, this.getChartContext(item)));
            }
            this.invalidateImage(Utils.checkedRectangle(uiBounds));
            this.repaintDirty();
        }
    }

    protected void itemsChanged(List<ChartItemChange> itemChanges) {
        ArrayList<ItemPainter> painters = new ArrayList<ItemPainter>(itemChanges.size());
        for (ChartItemChange change : itemChanges) {
            painters.add(this.paintersModel.getPainter(change.getItem()));
        }
        boolean boundsChange = false;
        for (int i = 0; i < itemChanges.size(); ++i) {
            ChartItemChange change = itemChanges.get(i);
            ItemPainter painter = (ItemPainter)painters.get(i);
            boundsChange = painter.isBoundsChange(change);
            if (boundsChange) break;
        }
        if (boundsChange) {
            LongRect oldBounds = new LongRect(this.dataBounds);
            this.computeDataBounds();
            if (!LongRect.equals(oldBounds, this.dataBounds)) {
                this.resizeChart();
            }
        }
        boolean appearanceChange = false;
        for (int i = 0; i < itemChanges.size(); ++i) {
            ChartItemChange change = itemChanges.get(i);
            ItemPainter painter = (ItemPainter)painters.get(i);
            appearanceChange = painter.isAppearanceChange(change);
            if (appearanceChange) break;
        }
        if (appearanceChange) {
            LongRect uiBounds = null;
            for (int i = 0; i < itemChanges.size(); ++i) {
                ChartItemChange change = itemChanges.get(i);
                ChartItem item = change.getItem();
                ItemPainter painter = this.paintersModel.getPainter(item);
                if (!painter.isAppearanceChange(change)) continue;
                if (uiBounds == null) {
                    uiBounds = new LongRect(painter.getDirtyBounds(change, this.getChartContext(item)));
                    continue;
                }
                LongRect.add(uiBounds, painter.getDirtyBounds(change, this.getChartContext(item)));
            }
            this.invalidateImage(Utils.checkedRectangle(uiBounds));
            this.repaintDirtyAccel();
        } else {
            this.repaintDirty();
        }
    }

    protected void paintersChanged() {
        this.updateChart();
    }

    protected void paintersChanged(List<ItemPainter> changedPainters) {
        HashSet<ChartItem> changedItems = new HashSet<ChartItem>();
        LongRect oldBounds = new LongRect(this.dataBounds);
        this.computeDataBounds();
        if (!LongRect.equals(oldBounds, this.dataBounds)) {
            this.resizeChart();
        }
        for (int i = 0; i < this.itemsModel.getItemsCount(); ++i) {
            ChartItem item = this.itemsModel.getItem(i);
            if (!changedPainters.contains(this.paintersModel.getPainter(item))) continue;
            changedItems.add(item);
        }
        LongRect uiBounds = null;
        for (ChartItem item : changedItems) {
            ItemPainter painter = this.paintersModel.getPainter(item);
            if (uiBounds == null) {
                uiBounds = new LongRect(painter.getItemBounds(item, this.getChartContext(item)));
                continue;
            }
            LongRect.add(uiBounds, painter.getItemBounds(item, this.getChartContext(item)));
        }
        this.invalidateImage(Utils.checkedRectangle(uiBounds));
        this.repaintDirty();
    }

    protected static class Context
    implements ChartContext {
        private ChartComponent chart;

        public Context(ChartComponent chart) {
            this.chart = chart;
        }

        protected ChartComponent getChartComponent() {
            return this.chart;
        }

        @Override
        public boolean isRightBased() {
            return this.chart.isRightBased();
        }

        @Override
        public boolean isBottomBased() {
            return this.chart.isBottomBased();
        }

        @Override
        public boolean fitsWidth() {
            return this.chart.fitsWidth();
        }

        @Override
        public boolean fitsHeight() {
            return this.chart.fitsHeight();
        }

        @Override
        public long getDataOffsetX() {
            return this.chart.getDataOffsetX();
        }

        @Override
        public long getDataOffsetY() {
            return this.chart.getDataOffsetY();
        }

        @Override
        public long getDataWidth() {
            return this.chart.getDataWidth();
        }

        @Override
        public long getDataHeight() {
            return this.chart.getDataHeight();
        }

        @Override
        public long getViewWidth() {
            return this.chart.getContentsWidth();
        }

        @Override
        public long getViewHeight() {
            return this.chart.getContentsHeight();
        }

        @Override
        public long getViewportOffsetX() {
            return 0L;
        }

        @Override
        public long getViewportOffsetY() {
            return 0L;
        }

        @Override
        public int getViewportWidth() {
            return this.chart.getWidth();
        }

        @Override
        public int getViewportHeight() {
            return this.chart.getHeight();
        }

        @Override
        public double getViewX(double dataX) {
            return this.chart.getViewX(dataX);
        }

        @Override
        public double getReversedViewX(double dataX) {
            return this.chart.getReversedViewX(dataX);
        }

        @Override
        public double getViewY(double dataY) {
            return this.chart.getViewY(dataY);
        }

        @Override
        public double getReversedViewY(double dataY) {
            return this.chart.getReversedViewY(dataY);
        }

        @Override
        public double getViewWidth(double dataWidth) {
            return this.chart.getViewWidth(dataWidth);
        }

        @Override
        public double getViewHeight(double dataHeight) {
            return this.chart.getViewHeight(dataHeight);
        }

        @Override
        public LongRect getViewRect(LongRect dataRect) {
            return this.getViewRectImpl(dataRect);
        }

        @Override
        public double getDataX(double viewX) {
            return this.chart.getDataX(viewX);
        }

        @Override
        public double getReversedDataX(double viewX) {
            return this.chart.getReversedDataX(viewX);
        }

        @Override
        public double getDataY(double viewY) {
            return this.chart.getDataY(viewY);
        }

        @Override
        public double getReversedDataY(double viewY) {
            return this.chart.getReversedDataY(viewY);
        }

        @Override
        public double getDataWidth(double viewWidth) {
            return this.chart.getDataWidth(viewWidth);
        }

        @Override
        public double getDataHeight(double viewHeight) {
            return this.chart.getDataHeight(viewHeight);
        }

        private LongRect getViewRectImpl(LongRect dataRect) {
            LongRect viewRect = new LongRect();
            viewRect.x = (long)Math.ceil(this.getViewX(dataRect.x));
            viewRect.width = (long)Math.ceil(this.getViewWidth(dataRect.width));
            if (this.isRightBased()) {
                viewRect.x -= viewRect.width;
            }
            viewRect.y = (long)Math.ceil(this.getViewY(dataRect.y));
            viewRect.height = (long)Math.ceil(this.getViewHeight(dataRect.height));
            if (this.isBottomBased()) {
                viewRect.y -= viewRect.height;
            }
            return viewRect;
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void selectionModeChanged(int newMode, int oldMode) {
        }

        @Override
        public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        }

        @Override
        public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            this.refreshSelection(addedItems, removedItems);
        }

        @Override
        public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            this.refreshSelection(addedItems, removedItems);
        }

        private void refreshSelection(List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            ItemPainter painter;
            ChartItem item;
            Rectangle dirtyArea = new Rectangle();
            if (!removedItems.isEmpty() && removedItems.get(0) != null) {
                for (ItemSelection sel : removedItems) {
                    item = sel.getItem();
                    painter = ChartComponent.this.paintersModel.getPainter(item);
                    if (!painter.supportsHovering(item)) continue;
                    if (dirtyArea.isEmpty()) {
                        dirtyArea.setBounds(Utils.checkedRectangle(painter.getSelectionBounds(sel, ChartComponent.this.getChartContext(item))));
                        continue;
                    }
                    dirtyArea.add(Utils.checkedRectangle(painter.getSelectionBounds(sel, ChartComponent.this.getChartContext(item))));
                }
            }
            if (!dirtyArea.isEmpty()) {
                ChartComponent.this.invalidateImage(dirtyArea);
                ChartComponent.this.paintImmediately(dirtyArea);
                dirtyArea = new Rectangle();
            }
            if (!addedItems.isEmpty() && addedItems.get(0) != null) {
                for (ItemSelection sel : addedItems) {
                    item = sel.getItem();
                    painter = ChartComponent.this.paintersModel.getPainter(item);
                    if (!painter.supportsHovering(item)) continue;
                    if (dirtyArea.isEmpty()) {
                        dirtyArea.setBounds(Utils.checkedRectangle(painter.getSelectionBounds(sel, ChartComponent.this.getChartContext(item))));
                        continue;
                    }
                    dirtyArea.add(Utils.checkedRectangle(painter.getSelectionBounds(sel, ChartComponent.this.getChartContext(item))));
                }
            }
            if (!dirtyArea.isEmpty()) {
                ChartComponent.this.invalidateImage(dirtyArea);
                ChartComponent.this.paintImmediately(dirtyArea);
            }
        }
    }

    private class PaintersModelListener
    implements PaintersListener {
        private PaintersModelListener() {
        }

        @Override
        public void paintersChanged() {
            ChartComponent.this.paintersChanged();
        }

        @Override
        public void paintersChanged(List<ItemPainter> changedPainters) {
            ChartComponent.this.paintersChanged(changedPainters);
        }
    }

    private class ItemsModelListener
    implements ItemsListener {
        private ItemsModelListener() {
        }

        @Override
        public void itemsAdded(List<ChartItem> addedItems) {
            ChartComponent.this.itemsAdded(addedItems);
        }

        @Override
        public void itemsRemoved(List<ChartItem> removedItems) {
            ChartComponent.this.itemsRemoved(removedItems);
        }

        @Override
        public void itemsChanged(List<ChartItemChange> itemChanges) {
            ChartComponent.this.itemsChanged(itemChanges);
        }
    }
}

