/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.Sets;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FailedReporter
extends TestListenerAdapter
implements IReporter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter() {
    }

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (int i = 0; i < suites.size(); ++i) {
            this.generateFailureSuite(suites.get(i).getXmlSuite(), suites.get(i), outputDirectory);
        }
    }

    protected void generateFailureSuite(XmlSuite xmlSuite, ISuite suite, String outputDir) {
        XmlSuite failedSuite = (XmlSuite)xmlSuite.clone();
        failedSuite.setName("Failed suite [" + xmlSuite.getName() + "]");
        this.m_xmlSuite = failedSuite;
        Map<String, XmlTest> xmlTests = Maps.newHashMap();
        for (XmlTest xmlT : xmlSuite.getTests()) {
            xmlTests.put(xmlT.getName(), xmlT);
        }
        Map<String, ISuiteResult> results = suite.getResults();
        for (Map.Entry<String, ISuiteResult> entry : results.entrySet()) {
            ISuiteResult suiteResult = entry.getValue();
            ITestContext testContext = suiteResult.getTestContext();
            this.generateXmlTest(suite, (XmlTest)xmlTests.get(testContext.getName()), testContext, testContext.getFailedTests().getAllResults(), testContext.getSkippedTests().getAllResults());
        }
        if (null != failedSuite.getTests() && failedSuite.getTests().size() > 0) {
            Utils.writeUtf8File(outputDir, TESTNG_FAILED_XML, failedSuite.toXml());
            Utils.writeUtf8File(suite.getOutputDirectory(), TESTNG_FAILED_XML, failedSuite.toXml());
        }
    }

    @Override
    @Deprecated
    public void onFinish(ITestContext context) {
    }

    private void generateXmlTest(ISuite suite, XmlTest xmlTest, ITestContext context, Collection<ITestResult> failedTests, Collection<ITestResult> skippedTests) {
        if (skippedTests.size() > 0 || failedTests.size() > 0) {
            Collection[] allTests;
            Set methodsToReRun = Sets.newHashSet();
            for (Collection tests : allTests = new Collection[]{failedTests, skippedTests}) {
                for (ITestResult failedTest : tests) {
                    ITestNGMethod current = failedTest.getMethod();
                    if (!current.isTest()) continue;
                    methodsToReRun.add(current);
                    ITestNGMethod method = failedTest.getMethod();
                    if (!method.isTest()) continue;
                    List<ITestNGMethod> methodsDependedUpon = MethodHelper.getMethodsDependedUpon(method, context.getAllTestMethods());
                    for (ITestNGMethod m : methodsDependedUpon) {
                        if (!m.isTest()) continue;
                        methodsToReRun.add(m);
                    }
                }
            }
            List<ITestNGMethod> result = Lists.newArrayList();
            for (ITestNGMethod m : context.getAllTestMethods()) {
                if (!methodsToReRun.contains(m)) continue;
                result.add(m);
            }
            methodsToReRun.clear();
            Collection<ITestNGMethod> invoked = suite.getInvokedMethods();
            for (ITestNGMethod tm : invoked) {
                if (tm.isTest()) continue;
                methodsToReRun.add(tm);
            }
            result.addAll(methodsToReRun);
            this.createXmlTest(context, result, xmlTest);
        }
    }

    private void createXmlTest(ITestContext context, List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        XmlTest xmlTest = new XmlTest(this.m_xmlSuite);
        xmlTest.setName(context.getName() + "(failed)");
        xmlTest.setBeanShellExpression(srcXmlTest.getExpression());
        xmlTest.setIncludedGroups(srcXmlTest.getIncludedGroups());
        xmlTest.setExcludedGroups(srcXmlTest.getExcludedGroups());
        xmlTest.setParallel(srcXmlTest.getParallel());
        xmlTest.setParameters(srcXmlTest.getLocalParameters());
        xmlTest.setJUnit(srcXmlTest.isJUnit());
        List<XmlClass> xmlClasses = this.createXmlClasses(methods, srcXmlTest);
        xmlTest.setXmlClasses(xmlClasses);
    }

    private List<XmlClass> createXmlClasses(List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        List<XmlClass> result = Lists.newArrayList();
        Map methodsMap = Maps.newHashMap();
        for (ITestNGMethod m : methods) {
            Object[] instances = m.getInstances();
            Class<?> clazz = instances == null || instances.length == 0 || instances[0] == null ? m.getRealClass() : instances[0].getClass();
            HashSet<ITestNGMethod> methodList = (HashSet<ITestNGMethod>)methodsMap.get(clazz);
            if (null == methodList) {
                methodList = new HashSet<ITestNGMethod>();
                methodsMap.put(clazz, methodList);
            }
            methodList.add(m);
        }
        Map<String, String> parameters = Maps.newHashMap();
        for (XmlClass c : srcXmlTest.getClasses()) {
            parameters.putAll(c.getLocalParameters());
        }
        int index = 0;
        for (Map.Entry entry : methodsMap.entrySet()) {
            Class clazz = (Class)entry.getKey();
            Set methodList = (Set)entry.getValue();
            XmlClass xmlClass = new XmlClass(clazz.getName(), index++, false);
            List<XmlInclude> methodNames = Lists.newArrayList(methodList.size());
            int ind = 0;
            for (ITestNGMethod m : methodList) {
                methodNames.add(new XmlInclude(m.getMethod().getName(), m.getFailedInvocationNumbers(), ind++));
            }
            xmlClass.setIncludedMethods(methodNames);
            xmlClass.setParameters(parameters);
            result.add(xmlClass);
        }
        return result;
    }

    private String getFileName(ITestContext context) {
        return TESTNG_FAILED_XML;
    }

    private static void ppp(String s) {
        System.out.println("[FailedReporter] " + s);
    }
}

