# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.sql_database import SQLDatabase


class ODBCDatabase(SQLDatabase):
    """
    ODBCDatabase - maintain an ODBC connection to a SQL database
    
    Superclass: SQLDatabase
    
    ODBC is a standard for connecting to an SQL database regardless of
    vendor or implementation.  In order to make it work you need two
    separate pices of software: a driver manager and then a
    database-specific driver.  On Windows, the driver manager is built
    into the OS.  On Unix platforms, the open-source packages i_odbc and
    unix_odbc will do the job.  Mac OS X has its own driver manager and
    can also use the open-source packages.  Database-specific drivers
    must be obtained from the entity that makes the database(s) you use.
    
    Unlike the other VTK database drivers, ODBC can read its parameters
    from a configuration file (odbc.ini).  That file can define an entire
    set of connection parameters and give it a single name called a data
    source name (DSN).  Writing and maintaining odbc.ini files is beyond
    the scope of this header file.
    
    @warning
    The password supplied as an argument to the Open call will override
    whatever password is set (if any) in the DSN definition.  To use the
    password from the DSN definition, pass in nullptr for the password
    argument.
    
    @warning
    Also, SQLDatabase::CreateFromURL() will only handle URLs of the
    following form for ODBC:
    
    @warning
    odbc://[user@]datsourcename[:port]/[dbname]
    
    @warning
    Anything more complicated than that needs to be set up manually.
    
    @warning
    Finally, this class does not yet support the schema API present in
    the SQLite, my_sql and postgre_sql drivers.  Those functions will be
    added once the bare-bones driver has been successfully integrated
    into VTK.
    
    @sa
    ODBCQuery
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkODBCDatabase, obj, update, **traits)
    
    data_source_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set the data source name.  For ODBC connections this will be
        something listed in odbc.ini.  The location of that file varies
        wildly based on system, ODBC library, and installation.  Good
        luck.
        """
    )

    def _data_source_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDataSourceName,
                        self.data_source_name)

    database_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _database_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDatabaseName,
                        self.database_name)

    def create_database(self, *args):
        """
        V.create_database(string, bool) -> bool
        C++: bool CreateDatabase(const char *dbName, bool dropExisting)
        Create a new database, optionally dropping any existing database
        of the same name. Returns true when the database is properly
        created and false on failure.
        """
        ret = self._wrap_call(self._vtk_obj.CreateDatabase, *args)
        return ret

    def drop_database(self, *args):
        """
        V.drop_database(string) -> bool
        C++: bool DropDatabase(const char *dbName)
        Drop a database if it exists. Returns true on success and false
        on failure.
        """
        ret = self._wrap_call(self._vtk_obj.DropDatabase, *args)
        return ret

    def parse_url(self, *args):
        """
        V.parse_url(string) -> bool
        C++: bool ParseURL(const char *url)
        This will only handle URLs of the form
        odbc://[user@]datsourcename[:port]/[dbname].  Anything more
        complicated than that needs to be set up manually.
        """
        ret = self._wrap_call(self._vtk_obj.ParseURL, *args)
        return ret

    def set_host_name(self, *args):
        """
        V.set_host_name(string)
        C++: virtual void SetHostName(const char *_arg)"""
        ret = self._wrap_call(self._vtk_obj.SetHostName, *args)
        return ret

    def set_password(self, *args):
        """
        V.set_password(string)
        C++: virtual void SetPassword(const char *_arg)"""
        ret = self._wrap_call(self._vtk_obj.SetPassword, *args)
        return ret

    def set_server_port(self, *args):
        """
        V.set_server_port(int)
        C++: virtual void SetServerPort(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetServerPort, *args)
        return ret

    def set_user_name(self, *args):
        """
        V.set_user_name(string)
        C++: virtual void SetUserName(const char *_arg)"""
        ret = self._wrap_call(self._vtk_obj.SetUserName, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('data_source_name', 'GetDataSourceName'),
    ('database_name', 'GetDatabaseName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'data_source_name',
    'database_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ODBCDatabase, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ODBCDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['data_source_name', 'database_name']),
            title='Edit ODBCDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ODBCDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

