/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.PluginConfigSpec;
import java.util.Collection;
import java.util.Map;
import org.logstash.config.ir.compiler.RubyIntegration;

public final class ConfigurationImpl
implements Configuration {
    private final RubyIntegration.PluginFactory pluginFactory;
    private final Map<String, Object> rawSettings;

    public ConfigurationImpl(Map<String, Object> raw, RubyIntegration.PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        this.rawSettings = raw;
    }

    public ConfigurationImpl(Map<String, Object> raw) {
        this(raw, null);
    }

    @Override
    public <T> T get(PluginConfigSpec<T> configSpec) {
        if (this.rawSettings.containsKey(configSpec.name())) {
            Object o = this.rawSettings.get(configSpec.name());
            if (configSpec.type().isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            if (configSpec.type() == Codec.class && o instanceof String && this.pluginFactory != null) {
                Codec codec = this.pluginFactory.buildDefaultCodec((String)o);
                return configSpec.type().cast(codec);
            }
            throw new IllegalStateException(String.format("Setting value for '%s' of type '%s' incompatible with defined type of '%s'", configSpec.name(), o.getClass(), configSpec.type()));
        }
        if (configSpec.type() == Codec.class && configSpec.getRawDefaultValue() != null && this.pluginFactory != null) {
            Codec codec = this.pluginFactory.buildDefaultCodec(configSpec.getRawDefaultValue());
            return configSpec.type().cast(codec);
        }
        return configSpec.defaultValue();
    }

    @Override
    public Object getRawValue(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.get(configSpec.name());
    }

    @Override
    public boolean contains(PluginConfigSpec<?> configSpec) {
        return this.rawSettings.containsKey(configSpec.name());
    }

    @Override
    public Collection<String> allKeys() {
        return this.rawSettings.keySet();
    }
}

