/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.api;

import co.elastic.logstash.api.Codec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PluginConfigSpec<T> {
    private final String name;
    private final Class<T> type;
    private final boolean deprecated;
    private final boolean required;
    private final T defaultValue;
    private String rawDefaultValue;
    private final Collection<PluginConfigSpec<?>> children;

    private PluginConfigSpec(String name, Class<T> type, T defaultValue, boolean deprecated, boolean required) {
        this(name, type, defaultValue, deprecated, required, Collections.emptyList());
    }

    private PluginConfigSpec(String name, Class<T> type, T defaultValue, boolean deprecated, boolean required, Collection<PluginConfigSpec<?>> children) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.deprecated = deprecated;
        this.required = required;
        if (!children.isEmpty() && !Map.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Only map type settings can have defined children.");
        }
        this.children = children;
    }

    public static PluginConfigSpec<String> stringSetting(String name) {
        return new PluginConfigSpec<Object>(name, String.class, null, false, false);
    }

    public static PluginConfigSpec<String> stringSetting(String name, String defaultValue) {
        return new PluginConfigSpec<String>(name, String.class, defaultValue, false, false);
    }

    public static PluginConfigSpec<String> requiredStringSetting(String name) {
        return new PluginConfigSpec<Object>(name, String.class, null, false, true);
    }

    public static PluginConfigSpec<String> stringSetting(String name, String defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<String>(name, String.class, defaultValue, deprecated, required);
    }

    public static PluginConfigSpec<Codec> codecSetting(String name) {
        return new PluginConfigSpec<Object>(name, Codec.class, null, false, false);
    }

    public static PluginConfigSpec<Codec> codecSetting(String name, String defaultCodecName) {
        PluginConfigSpec<Object> pcs = new PluginConfigSpec<Object>(name, Codec.class, null, false, false);
        pcs.rawDefaultValue = defaultCodecName;
        return pcs;
    }

    public static PluginConfigSpec<Codec> codecSetting(String name, Codec defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<Codec>(name, Codec.class, defaultValue, deprecated, required);
    }

    public static PluginConfigSpec<Long> numSetting(String name) {
        return new PluginConfigSpec<Object>(name, Long.class, null, false, false);
    }

    public static PluginConfigSpec<Long> numSetting(String name, long defaultValue) {
        return new PluginConfigSpec<Long>(name, Long.class, defaultValue, false, false);
    }

    public static PluginConfigSpec<Long> numSetting(String name, long defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<Long>(name, Long.class, defaultValue, deprecated, required);
    }

    public static PluginConfigSpec<Boolean> booleanSetting(String name) {
        return new PluginConfigSpec<Object>(name, Boolean.class, null, false, false);
    }

    public static PluginConfigSpec<Boolean> booleanSetting(String name, boolean defaultValue) {
        return new PluginConfigSpec<Boolean>(name, Boolean.class, defaultValue, false, false);
    }

    public static PluginConfigSpec<Boolean> requiredBooleanSetting(String name) {
        return new PluginConfigSpec<Object>(name, Boolean.class, null, false, true);
    }

    public static PluginConfigSpec<Boolean> booleanSetting(String name, boolean defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<Boolean>(name, Boolean.class, defaultValue, deprecated, required);
    }

    public static PluginConfigSpec<Map<String, Object>> hashSetting(String name) {
        return new PluginConfigSpec<Object>(name, Map.class, null, false, false);
    }

    public static PluginConfigSpec<Map<String, Object>> hashSetting(String name, Map<String, Object> defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<Map<String, Object>>(name, Map.class, defaultValue, deprecated, required);
    }

    public static PluginConfigSpec<List<Object>> arraySetting(String name) {
        return new PluginConfigSpec<Object>(name, List.class, null, false, false);
    }

    public static PluginConfigSpec<List<Object>> arraySetting(String name, List<Object> defaultValue, boolean deprecated, boolean required) {
        return new PluginConfigSpec<List<Object>>(name, List.class, defaultValue, deprecated, required);
    }

    public Collection<PluginConfigSpec<?>> children() {
        return this.children;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public boolean required() {
        return this.required;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public String getRawDefaultValue() {
        return this.rawDefaultValue;
    }
}

