/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureForResolvedCallKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;

public class ResolutionResultsHandler {
    private final OverloadingConflictResolver<MutableResolvedCall<?>> overloadingConflictResolver;

    public ResolutionResultsHandler(@NotNull KotlinBuiltIns builtIns2, @NotNull ModuleDescriptor module2, @NotNull TypeSpecificityComparator specificityComparator) {
        if (builtIns2 == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(1);
        }
        if (specificityComparator == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(2);
        }
        this.overloadingConflictResolver = FlatSignatureForResolvedCallKt.createOverloadingConflictResolver(builtIns2, module2, specificityComparator);
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Collection<MutableResolvedCall<D>> candidates2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (context == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(3);
        }
        if (tracing == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(4);
        }
        if (candidates2 == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(5);
        }
        if (languageVersionSettings == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(6);
        }
        LinkedHashSet<MutableResolvedCall<D>> successfulCandidates = new LinkedHashSet<MutableResolvedCall<D>>();
        LinkedHashSet<MutableResolvedCall<D>> failedCandidates = new LinkedHashSet<MutableResolvedCall<D>>();
        LinkedHashSet<MutableResolvedCall<D>> incompleteCandidates = new LinkedHashSet<MutableResolvedCall<D>>();
        LinkedHashSet candidatesWithWrongReceiver = new LinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates2) {
            ResolutionStatus status2 = candidateCall.getStatus();
            assert (status2 != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status2.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeSuccessfulResult(context, tracing, successfulCandidates, incompleteCandidates, context.checkArguments, languageVersionSettings);
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(7);
            }
            return overloadResolutionResultsImpl;
        }
        if (!failedCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeFailedResult(tracing, context.trace, failedCandidates, context.checkArguments, languageVersionSettings);
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(8);
            }
            return overloadResolutionResultsImpl;
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(context.trace, candidatesWithWrongReceiver);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(9);
            }
            return overloadResolutionResultsImpl;
        }
        tracing.unresolvedReference(context.trace);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(10);
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(@NotNull CallResolutionContext<?> context, @NotNull TracingStrategy tracing, @NotNull Set<MutableResolvedCall<D>> successfulCandidates, @NotNull Set<MutableResolvedCall<D>> incompleteCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (context == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(11);
        }
        if (tracing == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(12);
        }
        if (successfulCandidates == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(13);
        }
        if (incompleteCandidates == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(14);
        }
        if (checkArgumentsMode == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(15);
        }
        if (languageVersionSettings == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(16);
        }
        LinkedHashSet<MutableResolvedCall<D>> successfulAndIncomplete = new LinkedHashSet<MutableResolvedCall<D>>();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true, context.isDebuggerContext, checkArgumentsMode, languageVersionSettings);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(context.trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
                if (overloadResolutionResultsImpl == null) {
                    ResolutionResultsHandler.$$$reportNull$$$0(17);
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (results.isAmbiguity()) {
            tracing.recordAmbiguity(context.trace, results.getResultingCalls());
            boolean allCandidatesIncomplete = ResolutionResultsHandler.allIncomplete(results.getResultingCalls());
            if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS || !CallUtilKt.hasUnresolvedArguments(context.call, context)) {
                if (allCandidatesIncomplete) {
                    tracing.cannotCompleteResolve(context.trace, results.getResultingCalls());
                } else {
                    tracing.ambiguity(context.trace, results.getResultingCalls());
                }
            }
            if (allCandidatesIncomplete) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(results.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    ResolutionResultsHandler.$$$reportNull$$$0(18);
                }
                return overloadResolutionResultsImpl;
            }
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(19);
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Set<MutableResolvedCall<D>> failedCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (tracing == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(20);
        }
        if (trace == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(21);
        }
        if (failedCandidates == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(22);
        }
        if (checkArgumentsMode == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(23);
        }
        if (languageVersionSettings == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(24);
        }
        if (failedCandidates.size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, failedCandidates);
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(25);
            }
            return overloadResolutionResultsImpl;
        }
        for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
            LinkedHashSet<MutableResolvedCall<D>> thisLevel = new LinkedHashSet<MutableResolvedCall<D>>();
            for (MutableResolvedCall<D> candidate2 : failedCandidates) {
                if (!severityLevel.contains((Object)candidate2.getStatus())) continue;
                thisLevel.add(candidate2);
            }
            if (thisLevel.isEmpty()) continue;
            if (severityLevel.contains((Object)ResolutionStatus.ARGUMENTS_MAPPING_ERROR)) {
                OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, myResolver.filterOutEquivalentCalls(new LinkedHashSet<MutableResolvedCall<D>>(thisLevel)));
                if (overloadResolutionResultsImpl == null) {
                    ResolutionResultsHandler.$$$reportNull$$$0(26);
                }
                return overloadResolutionResultsImpl;
            }
            OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false, false, checkArgumentsMode, languageVersionSettings);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, results.getResultingCalls());
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(27);
            }
            return overloadResolutionResultsImpl;
        }
        throw new AssertionError((Object)("Should not be reachable, cause every status must belong to some level: " + failedCandidates));
    }

    @NotNull
    private static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> recordFailedInfo(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Collection<MutableResolvedCall<D>> candidates2) {
        if (tracing == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(28);
        }
        if (trace == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(29);
        }
        if (candidates2 == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(30);
        }
        if (candidates2.size() == 1) {
            MutableResolvedCall<D> failed = candidates2.iterator().next();
            failed.getTrace().moveAllMyDataTo(trace);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(failed);
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(31);
            }
            return overloadResolutionResultsImpl;
        }
        tracing.noneApplicable(trace, candidates2);
        tracing.recordAmbiguity(trace, candidates2);
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(candidates2);
        if (overloadResolutionResultsImpl == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(32);
        }
        return overloadResolutionResultsImpl;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results) {
        if (results == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(33);
        }
        for (MutableResolvedCall<D> result2 : results) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates2, boolean discriminateGenerics, boolean isDebuggerContext, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        Set<MutableResolvedCall<D>> specificCalls;
        if (candidates2 == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(34);
        }
        if (checkArgumentsMode == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(35);
        }
        if (languageVersionSettings == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(36);
        }
        OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
        Set<MutableResolvedCall<D>> refinedCandidates = candidates2;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.RefinedSamAdaptersPriority)) {
            HashSet<MutableResolvedCall<D>> nonSynthesized = new HashSet<MutableResolvedCall<D>>();
            for (MutableResolvedCall<D> candidate2 : candidates2) {
                if (TowerUtilsKt.isSynthesized(candidate2.getCandidateDescriptor())) continue;
                nonSynthesized.add(candidate2);
            }
            if (!nonSynthesized.isEmpty()) {
                refinedCandidates = nonSynthesized;
            }
        }
        if ((specificCalls = myResolver.chooseMaximallySpecificCandidates(refinedCandidates, checkArgumentsMode, discriminateGenerics, isDebuggerContext)).size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(specificCalls.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                ResolutionResultsHandler.$$$reportNull$$$0(37);
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(specificCalls);
        if (overloadResolutionResultsImpl == null) {
            ResolutionResultsHandler.$$$reportNull$$$0(38);
        }
        return overloadResolutionResultsImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificityComparator";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracing";
                break;
            }
            case 5: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 6: 
            case 16: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successfulCandidates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompleteCandidates";
                break;
            }
            case 15: 
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkArgumentsMode";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedCandidates";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResultAndReportErrors";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSuccessfulResult";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFailedResult";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "recordFailedInfo";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndReportMaximallySpecific";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeResultAndReportErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeSuccessfulResult";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "computeFailedResult";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "recordFailedInfo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "allIncomplete";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndReportMaximallySpecific";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

