/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.TempArray;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private P3[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private AtomIndexIterator iter;
    private BS bsSurfacePoints;
    private BS bsSurfaceDone;
    private BS[] bsLocale;
    private Map<String, Edge> htEdges;
    protected Lst<Edge> vEdges;
    private Lst<Face> vFaces;
    private final P3 ptS1 = new P3();
    private final P3 ptS2 = new P3();
    protected final V3 vTemp = new V3();
    protected final P4 plane = new P4();
    protected final P3 ptTemp2 = new P3();
    protected final V3 vTemp2 = new V3();
    protected final P3 p = new P3();
    private static boolean testLinear = false;
    private BS[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    int nTest = 0;
    private float rAS;
    private float rBS;
    private float rAS2;
    private float rBS2;
    private float dAB;
    private float dAB2;
    private float ecosASB2;

    IsoSolventReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        if (this.isProgressive) {
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BS[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    @Override
    protected void setup(boolean bl) {
        this.setup2();
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.sr = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !bl && this.sg.atomDataServer != null && !this.isCavity && this.sr > 0.0f && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN, null);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !bl) {
                float f = 0.0f;
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, f);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0f;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!bl) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (bl) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BSUtil.setAll(this.myAtomCount);
        }
    }

    @Override
    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        if (this.isCavity && this.dataType != 1207 && this.dataType != 1208) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, Float.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        Lst<Object[]> lst = this.params.slabInfo;
        if (lst != null) {
            int n = 0;
            while (n < lst.size()) {
                if (((Boolean)((Object[])lst.get(n))[2]).booleanValue() && ((Object[])lst.get(n))[0] instanceof P4) {
                    this.volumeData.capData((P4)((Object[])lst.get(n))[0], this.params.cutoff);
                    lst.removeItemAt(n--);
                }
                ++n;
            }
        }
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        int n6;
        int n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        int n8 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        boolean bl2 = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(n7) || this.bsSurfaceVoxels.get(n8));
        if (this.voxelSource != null && (n6 = Math.abs(Float.isNaN(f3) || f2 < f3 ? this.voxelSource[n7] : this.voxelSource[n8])) > 0) {
            this.iAtomSurface = this.atomIndex[n6 - 1];
        }
        if (testLinear || this.voxelSource == null || this.voxelSource[n7] == 0 || this.voxelSource[n7] != this.voxelSource[n8]) {
            return this.getSPF(f, bl, f2, f3, t3, v3, n, n2, n3, n7, n8, fArray, t32);
        }
        float f4 = fArray[0] = MeshSurface.getSphericalInterpolationFraction(this.voxelSource[n7] < 0 ? this.sr : this.atomRadius[this.voxelSource[n7] - 1], f2, f3, v3.length());
        t32.scaleAdd2(f4, v3, t3);
        float f5 = f3 - f2;
        return f2 + f4 * f5;
    }

    @Override
    public int addVertexCopy(T3 t3, float f, int n, boolean bl) {
        int n2 = this.addVC(t3, f, n, bl);
        if (n2 < 0) {
            return n2;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(n2);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[n2] = this.iAtomSurface;
        }
        return n2;
    }

    @Override
    public void selectPocket(boolean bl) {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        T3[] t3Array = this.meshData.vs;
        int n = this.meshData.vc;
        float[] fArray = this.meshData.vvs;
        int n2 = this.dots.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                if (this.dots[n4].distance(t3Array[n3]) < this.envelopeRadius) {
                    fArray[n3] = Float.NaN;
                }
                ++n4;
            }
            ++n3;
        }
        this.meshData.getSurfaceSet();
        n3 = this.meshData.nSets;
        BS bS = BS.newN(n3);
        int n5 = 0;
        while (n5 < n3) {
            BS bS2 = this.meshData.surfaceSet[n5];
            if (bS2 != null) {
                int n6 = bS2.nextSetBit(0);
                while (n6 >= 0) {
                    if (Float.isNaN(this.meshData.vvs[n6])) {
                        bS.set(n5);
                        break;
                    }
                    n6 = bS2.nextSetBit(n6 + 1);
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            if (this.meshData.surfaceSet[n5] != null && bS.get(n5) == bl) {
                this.meshData.invalidateSurfaceSet(n5);
            }
            ++n5;
        }
        this.updateSurfaceData();
        if (!bl) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    @Override
    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BS bS = new BS();
            BS[] bSArray = this.meshData.getSurfaceSet();
            BS[] bSArray2 = null;
            double[] dArray = (double[])(this.isPocket ? null : MeshData.calculateVolumeOrArea(this.meshData, Integer.MIN_VALUE, false, false));
            float f = this.isCavity ? (float)(4.71238898038469 * Math.pow(this.sr, 3.0)) : 0.0f;
            double d = 0.0;
            boolean bl = false;
            if (dArray != null && !this.isCavity) {
                int n = 0;
                while (n < this.meshData.nSets) {
                    double d2 = dArray[n];
                    if (Math.abs(d2) > d) {
                        d = Math.abs(d2);
                        bl = d2 < 0.0;
                    }
                    ++n;
                }
            }
            double d3 = bl ? -1 : 1;
            int n = 0;
            while (n < this.meshData.nSets) {
                BS bS2 = bSArray[n];
                if (bS2.intersects(this.bsSurfacePoints) && (dArray == null || dArray[n] * d3 > (double)f) && this.params.vertexSource != null) {
                    BS bS3 = new BS();
                    if (bSArray2 == null) {
                        bSArray2 = new BS[bSArray.length];
                    }
                    int n2 = bS2.nextSetBit(0);
                    while (n2 >= 0) {
                        int n3 = this.params.vertexSource[n2];
                        if (n3 >= 0) {
                            if (bS.get(n3)) {
                                this.meshData.invalidateSurfaceSet(n);
                                break;
                            }
                            bS3.set(n3);
                        }
                        n2 = bS2.nextSetBit(n2 + 1);
                    }
                    bS.or(bS3);
                } else {
                    this.meshData.invalidateSurfaceSet(n);
                }
                ++n;
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(TempArray.getSlabWithinRange(-100.0f, 0.0f));
        }
    }

    private void generateSolventCavity() {
        int n;
        int n2;
        int n3;
        BS bS = BS.newN(this.nPointsX * this.nPointsY * this.nPointsZ);
        int n4 = 0;
        int n5 = this.dots.length;
        int n6 = 0;
        float f = this.envelopeRadius;
        int n7 = 0;
        while (n7 < this.nPointsX) {
            n3 = 0;
            while (n3 < this.nPointsY) {
                n2 = 0;
                while (n2 < this.nPointsZ) {
                    block10: {
                        float f2;
                        float f3 = this.voxelData[n7][n3][n2];
                        if (f2 < Float.MAX_VALUE && f3 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(n7, n3, n2, this.ptV);
                            n = 0;
                            while (n < n5) {
                                if (!(this.dots[n].distance(this.ptV) < f)) {
                                    ++n;
                                    continue;
                                }
                                break block10;
                            }
                            bS.set(n4);
                            ++n6;
                        }
                    }
                    ++n2;
                    ++n4;
                }
                ++n3;
            }
            ++n7;
        }
        Logger.info("cavities include " + n6 + " voxel points");
        this.atomRadius = new float[n6];
        this.atomXyzTruncated = new P3[n6];
        n7 = 0;
        n3 = 0;
        n2 = 0;
        while (n7 < this.nPointsX) {
            n = 0;
            while (n < this.nPointsY) {
                int n8 = 0;
                while (n8 < this.nPointsZ) {
                    if (bS.get(n3++)) {
                        this.atomXyzTruncated[n2] = new P3();
                        this.volumeData.voxelPtToXYZ(n7, n, n8, this.atomXyzTruncated[n2]);
                        this.atomRadius[n2++] = this.voxelData[n7][n][n8];
                    }
                    ++n8;
                }
                ++n;
            }
            ++n7;
        }
        this.myAtomCount = this.firstNearbyAtom = n6;
        this.thisAtomSet = BSUtil.setAll(this.myAtomCount);
        this.rs = null;
        this.setRadii();
    }

    private void generateSolventCube() {
        if (this.dataType == 1207) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BS();
        this.bsSurfaceVoxels = new BS();
        this.bsSurfacePoints = new BS();
        if (this.doCalculateTroughs) {
            this.iter = this.sg.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new Lst();
            this.bsLocale = new BS[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info(String.valueOf(this.vEdges.size()) + " edges");
            this.vFaces = new Lst();
            this.getFaces();
            Logger.info(String.valueOf(this.vFaces.size()) + " faces");
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.validSpheres.or(this.noFaceSpheres);
            this.vEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
        }
        this.markSphereVoxels(0.0f, this.doCalculateTroughs ? Float.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        int n = 0;
        while (n < this.myAtomCount) {
            this.bsLocale[n] = new BS();
            ++n;
        }
        n = 0;
        while (n < this.myAtomCount) {
            P3 p3 = this.atomXyzTruncated[n];
            float f = this.rs[n];
            this.sg.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[n], f + this.maxRS);
            while (this.iter.hasNext()) {
                int n2 = this.iter.next();
                int n3 = this.myIndex[n2];
                if (n >= this.firstNearbyAtom && n3 >= this.firstNearbyAtom) continue;
                P3 p32 = this.atomXyzTruncated[n3];
                float f2 = this.rs[n3];
                float f3 = p3.distance(p32);
                if (f3 >= f + f2) continue;
                Edge edge = new Edge(this, n, n3, f3);
                this.vEdges.addLast(edge);
                this.bsLocale[n].set(n3);
                this.bsLocale[n3].set(n);
                this.htEdges.put(edge.toString(), edge);
            }
            ++n;
        }
    }

    protected Edge findEdge(int n, int n2) {
        return this.htEdges.get(n < n2 ? String.valueOf(n) + "_" + n2 : String.valueOf(n2) + "_" + n);
    }

    private void getFaces() {
        BS bS = new BS();
        this.params.surfaceAtoms = this.validSpheres = new BS();
        this.noFaceSpheres = BSUtil.setAll(this.myAtomCount);
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)this.vEdges.get(n);
            int n2 = edge.ia;
            int n3 = edge.ib;
            bS.clearAll();
            bS.or(this.bsLocale[n2]);
            bS.and(this.bsLocale[n3]);
            int n4 = bS.nextSetBit(n3 + 1);
            while (n4 >= 0) {
                if (this.getSolventPoints(edge, n2, n3, n4)) {
                    boolean bl = false;
                    Face face = this.validateFace(n2, n3, n4, edge, this.ptS1);
                    if (face != null) {
                        this.vFaces.addLast(face);
                        bl = true;
                    }
                    if ((face = this.validateFace(n2, n3, n4, edge, this.ptS2)) != null) {
                        this.vFaces.addLast(face);
                        bl = true;
                    }
                    if (bl) {
                        this.noFaceSpheres.clear(n2);
                        this.noFaceSpheres.clear(n3);
                        this.noFaceSpheres.clear(n4);
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
    }

    private Face validateFace(int n, int n2, int n3, Edge edge, P3 p3) {
        this.sg.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, p3, this.maxRS);
        boolean bl = true;
        while (this.iter.hasNext()) {
            float f;
            int n4 = this.iter.next();
            int n5 = this.myIndex[n4];
            if (n5 == n || n5 == n2 || n5 == n3 || !((f = this.atomData.atoms[n4].distance(p3)) < this.atomData.atomRadius[n4] + this.sr)) continue;
            bl = false;
            break;
        }
        Edge edge2 = this.findEdge(n2, n3);
        Edge edge3 = this.findEdge(n, n3);
        Face face = bl ? new Face(n, n2, n3, p3) : null;
        edge.addFace(face);
        edge2.addFace(face);
        edge3.addFace(face);
        if (!bl) {
            return null;
        }
        this.validSpheres.set(n);
        this.validSpheres.set(n2);
        this.validSpheres.set(n3);
        return face;
    }

    private void markFaceVoxels(boolean bl) {
        BS bS = new BS();
        V3 v3 = this.volumetricVectors[0];
        V3 v32 = this.volumetricVectors[1];
        V3 v33 = this.volumetricVectors[2];
        int n = this.vFaces.size();
        while (--n >= 0) {
            Face face = (Face)this.vFaces.get(n);
            P3 p3 = this.atomXyzTruncated[face.ia];
            P3 p32 = this.atomXyzTruncated[face.ib];
            P3 p33 = this.atomXyzTruncated[face.ic];
            P3 p34 = face.pS;
            this.setGridLimitsForAtom(p34, this.sr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptV);
            int n2 = this.pt0.x;
            while (n2 < this.pt1.x) {
                this.ptY0.setT(this.ptV);
                int n3 = this.pt0.y;
                while (n3 < this.pt1.y) {
                    this.ptZ0.setT(this.ptV);
                    int n4 = this.pt0.z;
                    while (n4 < this.pt1.z) {
                        float f = this.sr - this.ptV.distance(p34);
                        float f2 = this.voxelData[n2][n3][n4];
                        int n5 = this.volumeData.getPointIndex(n2, n3, n4);
                        if (bl && f > 0.0f) {
                            this.bsSurfaceDone.set(n5);
                        }
                        if (Measure.isInTetrahedron(this.ptV, p3, p32, p33, p34, this.plane, this.vTemp, this.vTemp2, false) && (!bl ? !this.bsSurfaceDone.get(n5) && f < 0.0f && f > -this.volumeData.maxGrid * 1.8f && f > f2 == bS.get(n5) : f > 0.0f && (f2 < 0.0f || f2 == Float.MAX_VALUE || f > f2 == bS.get(n5)))) {
                            bS.set(n5);
                            this.setVoxel(n2, n3, n4, n5, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n5] = -1 - face.ia;
                            }
                            if (f > 0.0f) {
                                this.bsSurfaceVoxels.set(n5);
                            }
                        }
                        ++n4;
                        this.ptV.add(v33);
                    }
                    ++n3;
                    this.ptV.add2(v32, this.ptZ0);
                }
                ++n2;
                this.ptV.add2(v3, this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        V3 v3 = this.volumetricVectors[0];
        V3 v32 = this.volumetricVectors[1];
        V3 v33 = this.volumetricVectors[2];
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)this.vEdges.get(n);
            if (!edge.isValid()) continue;
            int n2 = edge.ia;
            int n3 = edge.ib;
            P3 p3 = this.atomXyzTruncated[n2];
            P3 p32 = this.atomXyzTruncated[n3];
            this.rAS = this.rs[n2];
            this.rBS = this.rs[n3];
            this.rAS2 = this.rs2[n2];
            this.rBS2 = this.rs2[n3];
            this.dAB = edge.d;
            this.dAB2 = edge.d2;
            this.ecosASB2 = edge.cosASB2;
            this.setGridLimitsForAtom(edge, edge.maxr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptV);
            int n4 = this.pt0.x;
            while (n4 < this.pt1.x) {
                this.ptY0.setT(this.ptV);
                int n5 = this.pt0.y;
                while (n5 < this.pt1.y) {
                    this.ptZ0.setT(this.ptV);
                    int n6 = this.pt0.z;
                    while (n6 < this.pt1.z) {
                        float f;
                        float f2 = this.checkSpecialVoxel(p3, p32, this.ptV);
                        if (!Float.isNaN(f2) && (f = this.sr - f2) < this.voxelData[n4][n5][n6]) {
                            int n7 = this.volumeData.getPointIndex(n4, n5, n6);
                            this.setVoxel(n4, n5, n6, n7, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n7] = -1 - n2;
                            }
                        }
                        ++n6;
                        this.ptV.add(v33);
                    }
                    ++n5;
                    this.ptV.add2(v32, this.ptZ0);
                }
                ++n4;
                this.ptV.add2(v3, this.ptY0);
            }
        }
    }

    @Override
    protected void unsetVoxelData() {
        if (!this.havePlane) {
            this.unsetVoxelData2();
            return;
        }
        if (this.isProgressive) {
            int n = 0;
            while (n < this.yzCount) {
                if (!(this.thisPlane[n] < 0.001f)) {
                    this.thisPlane[n] = 0.001f;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.nPointsX) {
                int n2 = 0;
                while (n2 < this.nPointsY) {
                    int n3 = 0;
                    while (n3 < this.nPointsZ) {
                        if (!(this.voxelData[n][n2][n3] < 0.001f)) {
                            this.voxelData[n][n2][n3] = 0.001f;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private boolean getSolventPoints(Edge edge, int n, int n2, int n3) {
        float f = this.rs[n];
        V3 v3 = edge.v;
        float f2 = (edge.d2 + this.rs2[n] - this.rs2[n2]) / (2.0f * edge.d * f);
        float f3 = (float)Math.acos(f2);
        this.p.scaleAdd2(f2 * f, v3, this.atomXyzTruncated[n]);
        Measure.getPlaneThroughPoint(this.p, v3, this.plane);
        float f4 = (float)(Math.sin(f3) * (double)f);
        P3 p3 = this.atomXyzTruncated[n3];
        float f5 = this.rs[n3];
        float f6 = Measure.distanceToPlane(this.plane, p3);
        if (Math.abs(f6) >= f5 * 0.9f) {
            return false;
        }
        this.ptTemp.scaleAdd2(-f6, v3, p3);
        float f7 = this.p.distance(this.ptTemp);
        float f8 = f4 * f4;
        float f9 = this.rs2[n3] - f6 * f6;
        float f10 = (f8 + f7 * f7 - f9) / (2.0f * f4 * f7);
        if ((double)Math.abs(f10) >= 0.99) {
            return false;
        }
        V3 v32 = this.vTemp2;
        v32.sub2(this.ptTemp, this.p);
        v32.normalize();
        this.ptTemp.scaleAdd2(f4 * f10, v32, this.p);
        v32.cross(v3, v32);
        v32.normalize();
        v32.scale((float)(Math.sqrt(1.0f - f10 * f10) * (double)f4));
        this.ptS1.add2(this.ptTemp, v32);
        this.ptS2.sub2(this.ptTemp, v32);
        return true;
    }

    private float checkSpecialVoxel(P3 p3, P3 p32, P3 p33) {
        float f;
        float f2 = p3.distance(p33);
        float f3 = p3.distanceSquared(p33);
        float f4 = this.rAS / f2;
        if (f4 > 1.0f) {
            this.p.set(p3.x + (p33.x - p3.x) * f4, p3.y + (p33.y - p3.y) * f4, p3.z + (p33.z - p3.z) * f4);
            return p32.distanceSquared(this.p) >= this.rBS2 ? Float.NaN : this.solventDistance(this.rAS, this.rAS2, this.rBS2, f2, f3, p32.distanceSquared(p33));
        }
        float f5 = p32.distance(p33);
        f4 = this.rBS / f5;
        if (f > 1.0f) {
            this.p.set(p32.x + (p33.x - p32.x) * f4, p32.y + (p33.y - p32.y) * f4, p32.z + (p33.z - p32.z) * f4);
            return p3.distanceSquared(this.p) >= this.rAS2 ? Float.NaN : this.solventDistance(this.rBS, this.rBS2, this.rAS2, f5, f5 * f5, f3);
        }
        return Float.NaN;
    }

    private float solventDistance(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8 = (float)Math.acos((f5 + this.dAB2 - f6) / (2.0f * f4 * this.dAB));
        float f9 = (float)Math.acos((f2 + this.dAB2 - f3) / (2.0f * f * this.dAB));
        float f10 = (float)((double)(f2 + f5) - (double)(2.0f * f * f4) * Math.cos(f9 - f8));
        return this.ecosASB2 < (f2 + f10 - f4 * f4) / ((f7 = (float)Math.sqrt(f10)) * f) ? f7 : Float.NaN;
    }

    void dumpLine(P3 p3, T3 t3, String string, String string2) {
        this.sg.log("draw ID \"x" + string + this.nTest++ + "\" " + P3.newP(p3) + " " + P3.newP(t3) + " color " + string2);
    }

    void dumpLine2(P3 p3, P3 p32, String string, float f, String string2, String string3) {
        V3 v3 = new V3();
        v3.setT(p32);
        v3.sub(p3);
        v3.normalize();
        v3.scale(f);
        v3.add(p3);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" " + P3.newP(p3) + " " + P3.newP(v3) + " color " + string2);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\"" + P3.newP(v3) + " " + P3.newP(p32) + " color " + string3 + "\"" + string + "\"");
    }

    void dumpPoint(P3 p3, String string, String string2) {
        this.sg.log("draw ID \"" + string + this.nTest++ + "\"" + P3.newP(p3) + " color " + string2);
    }

    @Override
    public float getValueAtPoint(T3 t3, boolean bl) {
        if (this.contactPair != null) {
            return t3.distance(this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        float f = Float.MAX_VALUE;
        int n = 0;
        while (n < this.firstNearbyAtom) {
            float f2 = t3.distance(this.atomXyzTruncated[n]) - this.rs[n];
            if (f2 < f) {
                f = f2;
            }
            ++n;
        }
        return f == Float.MAX_VALUE ? Float.NaN : f;
    }

    @Override
    void discardTempData(boolean bl) {
        this.rs = null;
        this.rs2 = null;
        this.discardTempDataSR(bl);
    }

    @Override
    public float[] getPlane(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = n;
        this.thisPlane = this.yzPlanes[n % 2];
        if (this.contactPair == null) {
            this.resetPlane(Float.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[n];
            this.markSphereVoxels(0.0f, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels(this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Edge
    extends P3 {
        int ia;
        int ib;
        int nFaces;
        int nInvalid;
        float d;
        float d2;
        float maxr;
        float cosASB2;
        V3 v;

        Edge(IsoSolventReader isoSolventReader2, int n, int n2, float f) {
            this.ia = Math.min(n, n2);
            this.ib = Math.max(n, n2);
            this.d = f;
            this.d2 = f * f;
            this.maxr = (float)Math.sqrt(this.d2 / 4.0f + Math.max(isoSolventReader2.rs2[n], isoSolventReader2.rs2[n2]));
            this.ave(isoSolventReader2.atomXyzTruncated[n], isoSolventReader2.atomXyzTruncated[n2]);
            this.cosASB2 = (isoSolventReader2.rs2[n] + isoSolventReader2.rs2[n2] - this.d2) / (isoSolventReader2.rs[n2] * isoSolventReader2.rs[n]);
            this.v = V3.newVsub(isoSolventReader2.atomXyzTruncated[n2], isoSolventReader2.atomXyzTruncated[n]);
            this.v.normalize();
        }

        void addFace(Face face) {
            ++this.nFaces;
            if (face == null) {
                ++this.nInvalid;
                return;
            }
        }

        boolean isValid() {
            return this.nFaces == 0 || this.nInvalid != this.nFaces;
        }

        @Override
        public String toString() {
            return String.valueOf(this.ia) + "_" + this.ib;
        }
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        P3 pS;

        Face(int n, int n2, int n3, P3 p3) {
            this.ia = n;
            this.ib = n2;
            this.ic = n3;
            this.pS = P3.newP(p3);
        }

        public String toString() {
            return String.valueOf(this.ia) + "_" + this.ib + "_" + this.ic + "_" + this.pS;
        }
    }
}

