/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private Float groupTieBreaker = null;

    public MultiMatchQuery(QueryShardContext context) {
        super(context);
    }

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        List<Query> queries;
        float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
        switch (type) {
            case PHRASE: 
            case PHRASE_PREFIX: 
            case BEST_FIELDS: 
            case MOST_FIELDS: {
                queries = this.buildFieldQueries(type, fieldNames, value, minimumShouldMatch);
                break;
            }
            case CROSS_FIELDS: {
                queries = this.buildCrossFieldQuery(type, fieldNames, value, minimumShouldMatch, tieBreaker);
                break;
            }
            default: {
                throw new IllegalStateException("No such type: " + type);
            }
        }
        return this.combineGrouped(queries, tieBreaker);
    }

    private Query combineGrouped(List<Query> groupQuery, float tieBreaker) {
        if (groupQuery.isEmpty()) {
            return this.zeroTermsQuery();
        }
        if (groupQuery.size() == 1) {
            return groupQuery.get(0);
        }
        return new DisjunctionMaxQuery(groupQuery, tieBreaker);
    }

    private List<Query> buildFieldQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (String fieldName : fieldNames.keySet()) {
            if (this.context.fieldMapper(fieldName) == null) continue;
            float boostValue = fieldNames.getOrDefault(fieldName, Float.valueOf(1.0f)).floatValue();
            Query query = this.parse(type.matchQueryType(), fieldName, value);
            if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) != null && boostValue != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                query = new BoostQuery(query, boostValue);
            }
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    private List<Query> buildCrossFieldQuery(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch, float tieBreaker) throws IOException {
        float boost;
        HashMap groups = new HashMap();
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
            String name = entry.getKey();
            MappedFieldType fieldType = this.context.fieldMapper(name);
            if (fieldType == null) continue;
            Analyzer actualAnalyzer = this.getAnalyzer(fieldType, type == MultiMatchQueryBuilder.Type.PHRASE);
            if (!groups.containsKey(actualAnalyzer)) {
                groups.put(actualAnalyzer, new ArrayList());
            }
            boost = entry.getValue() == null ? 1.0f : entry.getValue().floatValue();
            ((List)groups.get(actualAnalyzer)).add(new FieldAndBoost(fieldType, boost));
        }
        for (Map.Entry<String, Float> entry : groups.entrySet()) {
            MatchQuery.MatchQueryBuilder builder = ((List)((Object)entry.getValue())).size() == 1 ? new MatchQuery.MatchQueryBuilder((Analyzer)entry.getKey(), ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).fieldType) : new BlendedQueryBuilder((Analyzer)entry.getKey(), (List)((Object)entry.getValue()), tieBreaker);
            String representativeField = ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).fieldType.name();
            Query query = this.parseInternal(type.matchQueryType(), representativeField, builder, value);
            if ((query = Queries.maybeApplyMinimumShouldMatch(query, minimumShouldMatch)) == null) continue;
            if (((List)((Object)entry.getValue())).size() == 1 && (boost = ((FieldAndBoost)((List)((Object)entry.getValue())).get((int)0)).boost) != 1.0f) {
                query = new BoostQuery(query, boost);
            }
            queries.add(query);
        }
        return queries;
    }

    static Query blendTerm(QueryShardContext context, BytesRef value, Float commonTermsCutoff, float tieBreaker, boolean lenient, List<FieldAndBoost> blendedFields) {
        return MultiMatchQuery.blendTerms(context, new BytesRef[]{value}, commonTermsCutoff, tieBreaker, lenient, blendedFields);
    }

    static Query blendTerms(QueryShardContext context, BytesRef[] values, Float commonTermsCutoff, float tieBreaker, boolean lenient, List<FieldAndBoost> blendedFields) {
        ArrayList<Query> queries = new ArrayList<Query>();
        Term[] terms = new Term[blendedFields.size() * values.length];
        float[] blendedBoost = new float[blendedFields.size() * values.length];
        int i = 0;
        for (FieldAndBoost ft : blendedFields) {
            for (BytesRef term : values) {
                Query query;
                try {
                    query = ft.fieldType.termQuery(term, context);
                }
                catch (RuntimeException e) {
                    if (lenient) {
                        query = Queries.newLenientFieldQuery(ft.fieldType.name(), e);
                    }
                    throw e;
                }
                float boost = ft.boost;
                while (query instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)query;
                    query = bq.getQuery();
                    boost *= bq.getBoost();
                }
                if (query.getClass() == TermQuery.class) {
                    terms[i] = ((TermQuery)query).getTerm();
                    blendedBoost[i] = boost;
                    ++i;
                    continue;
                }
                if (boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                    query = new BoostQuery(query, boost);
                }
                queries.add(query);
            }
        }
        if (i > 0) {
            terms = Arrays.copyOf(terms, i);
            blendedBoost = Arrays.copyOf(blendedBoost, i);
            if (commonTermsCutoff != null) {
                queries.add(BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, commonTermsCutoff.floatValue()));
            } else {
                queries.add(BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, tieBreaker));
            }
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        return new DisjunctionMaxQuery(queries, tieBreaker);
    }

    static final class FieldAndBoost {
        final MappedFieldType fieldType;
        final float boost;

        FieldAndBoost(MappedFieldType fieldType, float boost) {
            this.fieldType = Objects.requireNonNull(fieldType);
            this.boost = boost;
        }
    }

    private class BlendedQueryBuilder
    extends MatchQuery.MatchQueryBuilder {
        private final List<FieldAndBoost> blendedFields;
        private final float tieBreaker;

        BlendedQueryBuilder(Analyzer analyzer, List<FieldAndBoost> blendedFields, float tieBreaker) {
            super(analyzer, blendedFields.get((int)0).fieldType);
            this.blendedFields = blendedFields;
            this.tieBreaker = tieBreaker;
        }

        protected Query newSynonymQuery(Term[] terms) {
            BytesRef[] values = new BytesRef[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                values[i] = terms[i].bytes();
            }
            return MultiMatchQuery.blendTerms(MultiMatchQuery.this.context, values, MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, MultiMatchQuery.this.lenient, this.blendedFields);
        }

        @Override
        public Query newTermQuery(Term term) {
            return MultiMatchQuery.blendTerm(MultiMatchQuery.this.context, term.bytes(), MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, MultiMatchQuery.this.lenient, this.blendedFields);
        }

        @Override
        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            ArrayList<Query> disjunctions = new ArrayList<Query>();
            for (FieldAndBoost fieldType : this.blendedFields) {
                Query query = fieldType.fieldType.phraseQuery(stream, slop, this.enablePositionIncrements);
                if (fieldType.boost != 1.0f) {
                    query = new BoostQuery(query, fieldType.boost);
                }
                disjunctions.add(query);
            }
            return new DisjunctionMaxQuery(disjunctions, this.tieBreaker);
        }

        @Override
        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            ArrayList<Query> disjunctions = new ArrayList<Query>();
            for (FieldAndBoost fieldType : this.blendedFields) {
                Query query = fieldType.fieldType.multiPhraseQuery(stream, slop, this.enablePositionIncrements);
                if (fieldType.boost != 1.0f) {
                    query = new BoostQuery(query, fieldType.boost);
                }
                disjunctions.add(query);
            }
            return new DisjunctionMaxQuery(disjunctions, this.tieBreaker);
        }
    }
}

