/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.apt.core.internal.env.ReconcileFilerImpl;
import org.eclipse.jdt.apt.core.internal.util.TestCodeUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;

public class ReconcileEnv
extends AbstractCompilationEnv
implements EclipseAnnotationProcessorEnvironment {
    private final ICompilationUnit _workingCopy;
    private final ReconcileContext _context;

    static ReconcileEnv newEnv(ReconcileContext context) {
        ICompilationUnit workingCopy = context.getWorkingCopy();
        IJavaProject javaProject = workingCopy.getJavaProject();
        IFile file = (IFile)workingCopy.getResource();
        return new ReconcileEnv(context, workingCopy, file, javaProject, TestCodeUtil.isTestCode(workingCopy));
    }

    private ReconcileEnv(ReconcileContext context, ICompilationUnit workingCopy, IFile file, IJavaProject javaProj, boolean isTestCode) {
        super(EMPTY_AST_UNIT, file, javaProj, Phase.RECONCILE, isTestCode);
        this._context = context;
        this._workingCopy = workingCopy;
        if (AptPlugin.DEBUG_COMPILATION_ENV) {
            AptPlugin.trace("constructed " + this + " for " + this._workingCopy.getElementName());
        }
    }

    @Override
    void addMessage(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        this.checkValid();
        if (resource == null) {
            resource = this.getFile();
        }
        assert (resource != null) : "don't know about the current resource";
        if (resource != null && !resource.equals((Object)this.getFile())) {
            return;
        }
        this._problems.add(this.createProblem(resource, start, end, severity, msg, line, arguments));
    }

    @Override
    public CompilationUnit getASTFrom(IFile file) {
        if (this._file.equals((Object)file)) {
            return this._astRoot;
        }
        return null;
    }

    @Override
    public void addTypeDependency(String fullyQualifiedTypeName) {
    }

    @Override
    public Filer getFiler() {
        return new ReconcileFilerImpl(this);
    }

    void openPipeline() {
        this._requestor = new CallbackRequestor();
        ReconcileEnv.createASTs(this._javaProject, new ICompilationUnit[]{this._workingCopy}, this._requestor);
    }

    @Override
    public void close() {
        this._context.resetAST();
        super.close();
    }

    ICompilationUnit getCompilationUnit() {
        return this._workingCopy;
    }

    class CallbackRequestor
    extends ASTRequestor {
        CallbackRequestor() {
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            ReconcileEnv.this._astRoot = ast;
        }

        public void acceptBinding(String bindingKey, IBinding binding) {
            ReconcileEnv.this._callback.run(ReconcileEnv.this);
        }
    }
}

