/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

class TopLevelTypeProblemsLabelDecorator
extends ProblemsLabelDecorator {
    public TopLevelTypeProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        super(registry);
    }

    @Override
    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        if (!(sourceElement instanceof IType) || ((IType)sourceElement).getDeclaringType() != null) {
            return false;
        }
        IJavaScriptUnit cu = ((IType)sourceElement).getJavaScriptUnit();
        if (cu == null) {
            return false;
        }
        IType[] types = cu.getTypes();
        if (types.length < 1) {
            return false;
        }
        int firstTypeStartOffset = -1;
        ISourceRange range = types[0].getSourceRange();
        if (range != null) {
            firstTypeStartOffset = range.getOffset();
        }
        int lastTypeEndOffset = -1;
        range = types[types.length - 1].getSourceRange();
        if (range != null) {
            lastTypeEndOffset = range.getOffset() + range.getLength() - 1;
        }
        return pos < firstTypeStartOffset || pos > lastTypeEndOffset || this.isInside(pos, sourceElement.getSourceRange());
    }

    private boolean isInside(int pos, ISourceRange range) {
        if (range == null) {
            return false;
        }
        int offset = range.getOffset();
        return offset <= pos && pos < offset + range.getLength();
    }
}

