/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output;

import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebuggerCommand;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class EvaluateMessage
extends DebuggerMessage {
    public EvaluateMessage(String expression, Integer frame, Boolean global, Boolean disableBreak, List<Map.Entry<String, Value>> additionalContext) {
        super(DebuggerCommand.EVALUATE.value);
        this.putArgument("expression", expression);
        if (frame != null) {
            this.putArgument("frame", frame);
        }
        this.putArgument("global", global);
        this.putArgument("disable_break", disableBreak);
        this.putArgument("inlineRefs", Boolean.TRUE);
        if (additionalContext != null) {
            JSONArray contextParam = new JSONArray();
            for (Map.Entry<String, Value> en : additionalContext) {
                JSONObject mapping = en.getValue().createJsonParameter();
                mapping.put((Object)"name", (Object)en.getKey());
                contextParam.add((Object)mapping);
            }
            this.putArgument("additional_context", contextParam);
        }
    }

    public static abstract class Value {
        public static Value createForType(final Type type) {
            return new Value(){

                @Override
                JSONObject createJsonParameter() {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"type", (Object)type.jsonName);
                    return jsonObject;
                }
            };
        }

        public static Value createForValue(final Object value) {
            return new Value(){

                @Override
                JSONObject createJsonParameter() {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"value", value);
                    return jsonObject;
                }
            };
        }

        public static Value createForStringDescription(final Type type, final String description) {
            return new Value(){

                @Override
                JSONObject createJsonParameter() {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"type", (Object)type.jsonName);
                    jsonObject.put((Object)"stringDescription", (Object)description);
                    return jsonObject;
                }
            };
        }

        public static Value createForId(final long id) {
            return new Value(){

                @Override
                JSONObject createJsonParameter() {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"handle", (Object)id);
                    return jsonObject;
                }
            };
        }

        abstract JSONObject createJsonParameter();

        public static enum Type {
            NULL("null"),
            UNDEFINED("undefined"),
            BOOLEAN("boolean"),
            NUMBER("number"),
            STRING("string");

            final String jsonName;

            private Type(String jsonName) {
                this.jsonName = jsonName;
            }
        }
    }
}

