/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database.page;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseConsumerPageLoadSettings
extends ActiveWizardPage<DataTransferWizard> {
    public DatabaseConsumerPageLoadSettings() {
        super("Data load");
        this.setTitle("Data load settings");
        this.setDescription("Configuration of table data load");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final DatabaseConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
        Group loadSettings = UIUtils.createControlGroup((Composite)composite, (String)"Data load", (int)1, (int)768, (int)0);
        final Button truncateTargetTable = UIUtils.createCheckbox((Composite)loadSettings, (String)"Truncate target table before load", (boolean)settings.isTruncateBeforeLoad());
        truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setTruncateBeforeLoad(truncateTargetTable.getSelection());
            }
        });
        Group performanceSettings = UIUtils.createControlGroup((Composite)composite, (String)"Performance", (int)4, (int)768, (int)0);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)"Use transactions", null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        final Spinner commitAfterEdit = UIUtils.createLabelSpinner((Composite)performanceSettings, (String)"Commit after insert of ", (int)settings.getCommitAfterRows(), (int)1, (int)Integer.MAX_VALUE);
        commitAfterEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCommitAfterRows(commitAfterEdit.getSelection());
            }
        });
        commitAfterEdit.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)"General", (int)4, (int)768, (int)0);
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)"Open table editor on finish", null, (boolean)settings.isOpenTableOnFinish(), (int)4);
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)"Show finish message", null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)DatabaseConsumerPageLoadSettings.this.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

