/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class PostgreForeignKeyManager
extends SQLForeignKeyManager<PostgreTableForeignKey, PostgreTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableForeignKey> getObjectsCache(PostgreTableForeignKey object) {
        PostgreTableBase parent = (PostgreTableBase)object.getParentObject();
        if (parent instanceof PostgreTable) {
            return ((PostgreTable)parent).getForeignKeyCache();
        }
        return null;
    }

    protected PostgreTableForeignKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final PostgreTableBase table, Object from) {
        return (PostgreTableForeignKey)new UITask<PostgreTableForeignKey>(){

            protected PostgreTableForeignKey runTask() {
                EditPGForeignKeyPage editPage = new EditPGForeignKeyPage(PostgreMessages.postgre_foreign_key_manager_header_edit_foreign_key, (DBSTable)table);
                if (!editPage.edit()) {
                    return null;
                }
                PostgreTableForeignKey foreignKey = new PostgreTableForeignKey(table, editPage.getUniqueConstraint(), editPage.getOnDeleteRule(), editPage.getOnUpdateRule());
                foreignKey.setName(PostgreForeignKeyManager.this.getNewConstraintName(monitor, foreignKey));
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new PostgreTableForeignKeyColumn(foreignKey, (PostgreTableColumn)tableColumn.getOwnColumn(), colIndex++, (PostgreTableColumn)tableColumn.getRefColumn()));
                }
                foreignKey.setDeferrable(editPage.isDeferrable);
                foreignKey.setDeferred(editPage.isDeferred);
                return foreignKey;
            }
        }.execute();
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableForeignKey> command, Map<String, Object> options) {
        PostgreTableForeignKey fk = (PostgreTableForeignKey)command.getObject();
        if (fk.isPersisted()) {
            try {
                String constrDDL = fk.getObjectDefinitionText(monitor, Collections.singletonMap("embedded.source", true));
                if (!CommonUtils.isEmpty((String)constrDDL)) {
                    return new StringBuilder(constrDDL);
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract FK DDL", (Throwable)e);
            }
        }
        StringBuilder sql = super.getNestedDeclaration(monitor, (JDBCTable)owner, command, options);
        if (fk.isDeferrable()) {
            sql.append(" DEFERRABLE");
        }
        if (fk.isDeferred()) {
            sql.append(" INITIALLY DEFERRED");
        }
        return sql;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            PostgreConstraintManager.addConstraintCommentAction(actionList, (PostgreTableConstraintBase)command.getObject());
        }
    }

    protected String getDropForeignKeyPattern(PostgreTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    private static class EditPGForeignKeyPage
    extends EditForeignKeyPage {
        private boolean isDeferrable;
        private boolean isDeferred;

        public EditPGForeignKeyPage(String title, DBSTable table) {
            super(title, table, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
        }

        protected Composite createPageContents(Composite parent) {
            Composite panel = super.createPageContents(parent);
            Composite defGroup = UIUtils.createComposite((Composite)panel, (int)2);
            defGroup.setLayoutData((Object)new GridData(768));
            final Button deferrableCheck = UIUtils.createCheckbox((Composite)defGroup, (String)PostgreMessages.postgre_foreign_key_manager_checkbox_deferrable, (boolean)false);
            deferrableCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    isDeferrable = deferrableCheck.getSelection();
                }
            });
            final Button deferredCheck = UIUtils.createCheckbox((Composite)defGroup, (String)PostgreMessages.postgre_foreign_key_manager_checkbox_deferred, (boolean)false);
            deferredCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    isDeferred = deferredCheck.getSelection();
                }
            });
            return panel;
        }
    }
}

