/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class SQLServerTableCheckConstraint
implements DBSEntityConstraint,
SQLServerObject,
DBPScriptObject {
    private final SQLServerTable table;
    private boolean persisted;
    private boolean disabled;
    private String name;
    private String definition;
    private long objectId;

    public SQLServerTableCheckConstraint(SQLServerTable table, JDBCResultSet dbResult) {
        this.table = table;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.disabled = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_disabled") != 0;
        this.definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition");
        this.persisted = true;
    }

    public SQLServerTable getParentObject() {
        return this.table;
    }

    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.CHECK;
    }

    @Property(viewable=true, editable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=false, editable=true, order=10)
    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)this.table.getDataSource();
    }

    @Property(viewable=false, editable=true, order=80)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, editable=true, multiline=true, order=20)
    public String getDefinition() {
        return this.definition;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDefinition();
    }
}

