/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class FileSystemExporter {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++n2;
            }
        }
    }

    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException {
        OutputStream output = null;
        BufferedInputStream contentStream = null;
        try {
            contentStream = new BufferedInputStream(file.getContents(false));
            output = new BufferedOutputStream(new FileOutputStream(destinationPath.toOSString()));
            int available = ((InputStream)contentStream).available();
            available = available <= 0 ? 16384 : available;
            int chunkSize = Math.min(16384, available);
            byte[] readBuffer = new byte[chunkSize];
            int n = ((InputStream)contentStream).read(readBuffer);
            while (n > 0) {
                output.write(readBuffer, 0, n);
                n = ((InputStream)contentStream).read(readBuffer);
            }
        }
        finally {
            if (contentStream != null) {
                try {
                    ((InputStream)contentStream).close();
                }
                catch (IOException e) {
                    IDEWorkbenchPlugin.log("Error closing input stream for file: " + file.getLocation(), e);
                }
            }
            if (output != null) {
                output.close();
            }
        }
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

