/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools.maintenance;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.GenerateMultiSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptStatusDialog;
import org.jkiss.utils.CommonUtils;

public abstract class TableToolDialog
extends GenerateMultiSQLDialog<MySQLTable> {
    public TableToolDialog(IWorkbenchPartSite partSite, String title, Collection<MySQLTable> objects) {
        super(partSite, title, objects, true);
    }

    protected SQLScriptProgressListener<MySQLTable> getScriptListener() {
        return new SQLScriptStatusDialog<MySQLTable>(String.valueOf(this.getTitle()) + " progress", null){

            protected void createStatusColumns(Tree objectTree) {
                TreeColumn msgColumn = new TreeColumn(objectTree, 0);
                msgColumn.setText("Message");
            }

            public void processObjectResults(@NotNull MySQLTable object, @Nullable DBCStatement statement, @Nullable DBCResultSet resultSet) throws DBCException {
                if (resultSet == null) {
                    return;
                }
                LinkedHashMap<String, String> statusMap = new LinkedHashMap<String, String>();
                while (resultSet.nextRow()) {
                    statusMap.put(CommonUtils.toString((Object)resultSet.getAttributeValue("Msg_type")), CommonUtils.toString((Object)resultSet.getAttributeValue("Msg_text")));
                }
                TreeItem treeItem = this.getTreeItem(object);
                if (treeItem != null && !statusMap.isEmpty()) {
                    if (statusMap.size() == 1) {
                        treeItem.setText(1, (String)statusMap.values().iterator().next());
                    } else {
                        String statusText = (String)statusMap.get("status");
                        if (!CommonUtils.isEmpty((String)statusText)) {
                            treeItem.setText(1, statusText);
                        }
                        for (Map.Entry status : statusMap.entrySet()) {
                            if (((String)status.getKey()).equals("status")) continue;
                            TreeItem subItem = new TreeItem(treeItem, 0);
                            subItem.setText(0, (String)status.getKey());
                            subItem.setText(1, (String)status.getValue());
                        }
                        treeItem.setExpanded(true);
                    }
                }
            }
        };
    }
}

