/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class DatabaseLabelProviders {
    public static final String EMPTY_SELECTION_TEXT = CoreMessages.toolbar_datasource_selector_empty;

    public static class ConnectionLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Image getImage(Object element) {
            if (element == null) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT);
            }
            DBNModel nm = DBWorkbench.getPlatform().getNavigatorModel();
            nm.ensureProjectLoaded(((DBPDataSourceContainer)element).getRegistry().getProject());
            DBNDatabaseNode node = nm.findNode((DBSObject)((DBPDataSourceContainer)element));
            return node == null ? null : DBeaverIcons.getImage((DBPImage)node.getNodeIcon());
        }

        public String getText(Object element) {
            if (element == null) {
                return EMPTY_SELECTION_TEXT;
            }
            return ((DBPDataSourceContainer)element).getName();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return element == null ? null : UIUtils.getConnectionColor((DBPConnectionConfiguration)((DBPDataSourceContainer)element).getConnectionConfiguration());
        }
    }

    public static class DatabaseLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Image getImage(Object element) {
            if (element == null) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT);
            }
            return DBeaverIcons.getImage((DBPImage)((DBNDatabaseNode)element).getNodeIconDefault());
        }

        public String getText(Object element) {
            if (element == null) {
                return EMPTY_SELECTION_TEXT;
            }
            return ((DBNDatabaseNode)element).getNodeName();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            DBPDataSourceContainer container;
            if (element instanceof DBNDatabaseNode && (container = ((DBNDatabaseNode)element).getDataSourceContainer()) != null) {
                return UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
            }
            return null;
        }
    }
}

