/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.ExternalResourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataSourceProviderRegistry
implements DBPDataSourceProviderRegistry {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private static DataSourceProviderRegistry instance = null;
    private final List<DataSourceProviderDescriptor> dataSourceProviders = new ArrayList<DataSourceProviderDescriptor>();
    private final List<DBPRegistryListener> registryListeners = new ArrayList<DBPRegistryListener>();
    private final Map<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
    private final Map<String, ExternalResourceDescriptor> resourceContributions = new HashMap<String, ExternalResourceDescriptor>();

    public static synchronized DataSourceProviderRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataSourceProviderRegistry() {
    }

    /*
     * WARNING - void declaration
     */
    public void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        void var6_9;
        IConfigurationElement ext;
        IConfigurationElement[] extElements2 = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceProvider");
        Arrays.sort(extElements2, (o1, o2) -> {
            String p2;
            String p1 = o1.getAttribute("parent");
            if (CommonUtils.equalObjects((Object)p1, (Object)(p2 = o2.getAttribute("parent")))) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            return 0;
        });
        IConfigurationElement[] iConfigurationElementArray = extElements2;
        int n = extElements2.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            switch (ext.getName()) {
                case "datasource": {
                    DataSourceProviderDescriptor provider = new DataSourceProviderDescriptor(this, ext);
                    this.dataSourceProviders.add(provider);
                }
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = extElements2;
        n = extElements2.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray2[n2];
            switch (ext.getName()) {
                case "datasourcePatch": {
                    String dsId = ext.getAttribute("id");
                    DataSourceProviderDescriptor dataSourceProvider = this.getDataSourceProvider(dsId);
                    if (dataSourceProvider != null) {
                        dataSourceProvider.patchConfigurationFrom(ext);
                        break;
                    }
                    log.warn((Object)("Datasource '" + dsId + "' not found for patch"));
                }
            }
            ++n2;
        }
        this.dataSourceProviders.sort((o1, o2) -> {
            if (o1.isDriversManagable() && !o2.isDriversManagable()) {
                return 1;
            }
            if (o2.isDriversManagable() && !o1.isDriversManagable()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        File driversConfig = DBeaverActivator.getConfigurationFile("drivers.xml");
        if (driversConfig.exists()) {
            this.loadDrivers(driversConfig);
        }
        ArrayList<DriverDescriptor> allDrivers = new ArrayList<DriverDescriptor>();
        for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
            allDrivers.addAll(provider.getDrivers());
        }
        for (DriverDescriptor driver1 : allDrivers) {
            for (DriverDescriptor driverDescriptor : allDrivers) {
                if (driver1 == driverDescriptor || !driver1.replaces(driverDescriptor)) continue;
                driverDescriptor.setReplacedBy(driver1);
            }
        }
        int driverCount = 0;
        int customDriverCount = 0;
        for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
            for (DriverDescriptor dd : pd.getDrivers()) {
                if (dd.isDisabled() || dd.getReplacedBy() != null) continue;
                ++driverCount;
                if (!dd.isCustom()) continue;
                ++customDriverCount;
            }
        }
        log.debug((Object)("Total database drivers: " + driverCount + " (" + (driverCount - customDriverCount) + ")"));
        DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
        int n3 = DBPConnectionType.SYSTEM_TYPES.length;
        boolean bl = false;
        while (var6_9 < n3) {
            DBPConnectionType ct = dBPConnectionTypeArray[var6_9];
            this.connectionTypes.put(ct.getId(), ct);
            ++var6_9;
        }
        File ctConfig = DBeaverActivator.getConfigurationFile("connection-types.xml");
        if (ctConfig.exists()) {
            this.loadConnectionTypes(ctConfig);
        }
        IConfigurationElement[] iConfigurationElementArray3 = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resources");
        int n4 = extElements.length;
        n3 = 0;
        while (n3 < n4) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray3[n3];
            ExternalResourceDescriptor resource = new ExternalResourceDescriptor(iConfigurationElement);
            this.resourceContributions.put(resource.getName(), resource);
            if (!CommonUtils.isEmpty((String)resource.getAlias())) {
                String[] stringArray = resource.getAlias().split(",");
                int n5 = stringArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    String alias = stringArray[n6];
                    this.resourceContributions.put(alias, resource);
                    ++n6;
                }
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            if (!this.registryListeners.isEmpty()) {
                log.warn((Object)("Some datasource registry listeners are still registered: " + this.registryListeners));
            }
            this.registryListeners.clear();
        }
        for (DataSourceProviderDescriptor providerDescriptor : this.dataSourceProviders) {
            providerDescriptor.dispose();
        }
        this.dataSourceProviders.clear();
        this.resourceContributions.clear();
    }

    @Nullable
    public DataSourceProviderDescriptor getDataSourceProvider(String id) {
        for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
            if (!provider.getId().equals(id)) continue;
            return provider;
        }
        return null;
    }

    public List<DataSourceProviderDescriptor> getDataSourceProviders() {
        return this.dataSourceProviders;
    }

    public List<DataSourceProviderDescriptor> getEnabledDataSourceProviders() {
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        ArrayList<DataSourceProviderDescriptor> enabled = new ArrayList<DataSourceProviderDescriptor>(this.dataSourceProviders);
        enabled.removeIf(p -> !activityManager.getIdentifier(p.getFullIdentifier()).isEnabled());
        return enabled;
    }

    @Nullable
    public DriverDescriptor findDriver(@NotNull String driverIdOrName) {
        for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
            DriverDescriptor driver = pd.getDriver(driverIdOrName);
            if (driver == null) continue;
            return driver;
        }
        for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
            for (DriverDescriptor driver : pd.getDrivers()) {
                if (!driver.getName().equalsIgnoreCase(driverIdOrName)) continue;
                while (driver.getReplacedBy() != null) {
                    driver = driver.getReplacedBy();
                }
                return driver;
            }
        }
        return null;
    }

    private void loadDrivers(File driversConfig) {
        if (driversConfig.exists()) {
            try {
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (FileInputStream is = new FileInputStream(driversConfig);){
                        new SAXReader((InputStream)is).parse((SAXListener)new DriverDescriptor.DriversParser());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (XMLException ex) {
                    log.warn((Object)"Drivers config parse error", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                log.warn((Object)("Error loading drivers from " + driversConfig.getPath()), (Throwable)ex);
            }
        }
    }

    public void saveDrivers() {
        File driversConfig = DBeaverActivator.getConfigurationFile("drivers.xml");
        try {
            FileOutputStream os = new FileOutputStream(driversConfig);
            XMLBuilder xml = new XMLBuilder((OutputStream)os, "UTF-8");
            xml.setButify(true);
            xml.startElement("drivers");
            for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
                xml.startElement("provider");
                xml.addAttribute("id", provider.getId());
                for (DriverDescriptor driver : provider.getDrivers()) {
                    if (!driver.isModified()) continue;
                    driver.serialize(xml, false);
                }
                xml.endElement();
            }
            xml.endElement();
            xml.flush();
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    private void loadConnectionTypes(File configFile) {
        try {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileInputStream is = new FileInputStream(configFile);){
                    new SAXReader((InputStream)is).parse((SAXListener)new ConnectionTypeParser());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XMLException ex) {
                log.warn((Object)("Can't load connection types config from " + configFile.getPath()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error parsing connection types", (Throwable)ex);
        }
    }

    public Collection<DBPConnectionType> getConnectionTypes() {
        return this.connectionTypes.values();
    }

    public DBPConnectionType getConnectionType(String id, DBPConnectionType defaultType) {
        DBPConnectionType connectionType = this.connectionTypes.get(id);
        return connectionType == null ? defaultType : connectionType;
    }

    public void addConnectionType(DBPConnectionType connectionType) {
        if (this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Duplicate connection type id: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.put(connectionType.getId(), connectionType);
    }

    public void removeConnectionType(DBPConnectionType connectionType) {
        if (!this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Connection type doesn't exist: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.remove(connectionType.getId());
    }

    public void saveConnectionTypes() {
        File ctConfig = DBeaverActivator.getConfigurationFile("connection-types.xml");
        try {
            FileOutputStream os = new FileOutputStream(ctConfig);
            XMLBuilder xml = new XMLBuilder((OutputStream)os, "UTF-8");
            xml.setButify(true);
            xml.startElement("types");
            for (DBPConnectionType connectionType : this.connectionTypes.values()) {
                xml.startElement("type");
                xml.addAttribute("id", connectionType.getId());
                xml.addAttribute("name", CommonUtils.toString((Object)connectionType.getName()));
                xml.addAttribute("color", connectionType.getColor());
                xml.addAttribute("description", CommonUtils.toString((Object)connectionType.getDescription()));
                xml.addAttribute("autocommit", connectionType.isAutocommit());
                xml.addAttribute("confirmExecute", connectionType.isConfirmExecute());
                xml.endElement();
            }
            xml.endElement();
            xml.flush();
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    @Nullable
    public URL findResourceURL(String resourcePath) {
        ExternalResourceDescriptor descriptor = this.resourceContributions.get(resourcePath);
        return descriptor == null ? null : descriptor.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistryChange(DataSourceRegistry registry, boolean load) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            for (DBPRegistryListener listener : this.registryListeners) {
                if (load) {
                    listener.handleRegistryLoad((DBPDataSourceRegistry)registry);
                    continue;
                }
                listener.handleRegistryUnload((DBPDataSourceRegistry)registry);
            }
        }
    }

    class ConnectionTypeParser
    implements SAXListener {
        ConnectionTypeParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals("type")) {
                DBPConnectionType connectionType = new DBPConnectionType(atts.getValue("id"), atts.getValue("name"), atts.getValue("color"), atts.getValue("description"), CommonUtils.getBoolean((String)atts.getValue("autocommit")), CommonUtils.getBoolean((String)atts.getValue("confirmExecute")));
                DataSourceProviderRegistry.this.connectionTypes.put(connectionType.getId(), connectionType);
            }
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
        }
    }
}

