/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class ResultSetDataReceiver
implements DBDDataReceiver {
    private static final Log log = Log.getLog(ResultSetDataReceiver.class);
    private ResultSetViewer resultSetViewer;
    private int columnsCount;
    private DBDAttributeBindingMeta[] metaColumns;
    private List<Object[]> rows = new ArrayList<Object[]>();
    private boolean hasMoreData;
    private boolean nextSegmentRead;
    private long offset;
    private long maxRows;
    private Map<DBCAttributeMetaData, List<String>> attrErrors = new HashMap<DBCAttributeMetaData, List<String>>();
    private List<Throwable> errorList = new ArrayList<Throwable>();
    private int focusRow;
    private DBSDataContainer targetDataContainer;

    ResultSetDataReceiver(ResultSetViewer resultSetViewer) {
        this.resultSetViewer = resultSetViewer;
    }

    boolean isHasMoreData() {
        return this.hasMoreData;
    }

    void setHasMoreData(boolean hasMoreData) {
        this.hasMoreData = hasMoreData;
    }

    void setNextSegmentRead(boolean nextSegmentRead) {
        this.nextSegmentRead = nextSegmentRead;
    }

    public void setFocusRow(int focusRow) {
        this.focusRow = focusRow;
    }

    public void setTargetDataContainer(DBSDataContainer targetDataContainer) {
        this.targetDataContainer = targetDataContainer;
    }

    public List<Throwable> getErrorList() {
        return this.errorList;
    }

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        this.errorList.clear();
        this.rows.clear();
        this.offset = offset;
        this.maxRows = maxRows;
        if (!this.nextSegmentRead) {
            DBCResultSetMetaData metaData = resultSet.getMeta();
            if (metaData == null) {
                throw new DBCException("Null resultset metadata");
            }
            List rsAttributes = metaData.getAttributes();
            this.columnsCount = rsAttributes.size();
            this.metaColumns = new DBDAttributeBindingMeta[this.columnsCount];
            int i = 0;
            while (i < this.columnsCount) {
                this.metaColumns[i] = DBUtils.getAttributeBinding((DBCSession)session, (DBCAttributeMetaData)((DBCAttributeMetaData)rsAttributes.get(i)));
                ++i;
            }
            this.resultSetViewer.setMetaData(resultSet, (DBDAttributeBinding[])this.metaColumns);
        }
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        Object[] row = new Object[this.columnsCount];
        int i = 0;
        while (i < this.columnsCount) {
            block5: {
                try {
                    row[i] = this.metaColumns[i].getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)this.metaColumns[i].getAttribute(), this.metaColumns[i].getOrdinalPosition());
                }
                catch (Throwable e) {
                    String errMessage;
                    row[i] = new DBDValueError(e);
                    List<String> attrErrors = this.attrErrors.get(this.metaColumns[i].getMetaAttribute());
                    if (attrErrors == null) {
                        attrErrors = new ArrayList<String>();
                        this.attrErrors.put(this.metaColumns[i].getMetaAttribute(), attrErrors);
                    }
                    if (!(errMessage = e.getClass().getName()).startsWith("java.lang.")) {
                        errMessage = String.valueOf(errMessage) + ":" + e.getMessage();
                    }
                    if (attrErrors.contains(errMessage)) break block5;
                    log.warn((Object)("Can't read column '" + this.metaColumns[i].getName() + "' value"), e);
                    attrErrors.add(errMessage);
                    this.errorList.add(e);
                }
            }
            ++i;
        }
        this.rows.add(row);
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        if (!this.nextSegmentRead) {
            try {
                DBSDataContainer dataContainer;
                DBSEntity entity = null;
                DBSDataContainer dBSDataContainer = dataContainer = this.targetDataContainer != null ? this.targetDataContainer : this.resultSetViewer.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)dataContainer;
                }
                ResultSetUtils.bindAttributes(session, entity, resultSet, this.metaColumns, this.rows);
            }
            catch (Throwable e) {
                this.errorList.add(e);
            }
        }
        List<Object[]> tmpRows = this.rows;
        boolean nextSegmentRead = this.nextSegmentRead;
        UIUtils.syncExec(() -> {
            if (!nextSegmentRead) {
                boolean metadataChanged = this.resultSetViewer.getModel().isMetadataChanged();
                this.resultSetViewer.updatePresentation(resultSet, metadataChanged);
                this.resultSetViewer.setData(tmpRows, this.focusRow);
                this.resultSetViewer.getActivePresentation().refreshData(true, false, !metadataChanged);
                this.resultSetViewer.updateStatusMessage();
            } else {
                if (this.resultSetViewer.getDataContainer().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.reread.on.scroll")) {
                    ResultSetRow currentRow = this.resultSetViewer.getCurrentRow();
                    this.resultSetViewer.setData(tmpRows, currentRow == null ? 0 : currentRow.getVisualNumber());
                } else {
                    this.resultSetViewer.appendData(tmpRows);
                }
                this.resultSetViewer.getActivePresentation().refreshData(false, true, true);
            }
            this.hasMoreData = this.maxRows > 0L && (long)tmpRows.size() >= this.maxRows;
        });
    }

    public void close() {
        this.nextSegmentRead = false;
        this.attrErrors.clear();
        this.rows = new ArrayList<Object[]>();
    }
}

