"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MacUpdater = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _builderUtilRuntime() {
  const data = require("builder-util-runtime");

  _builderUtilRuntime = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

function _http() {
  const data = require("http");

  _http = function () {
    return data;
  };

  return data;
}

function _AppUpdater() {
  const data = require("./AppUpdater");

  _AppUpdater = function () {
    return data;
  };

  return data;
}

function _Provider() {
  const data = require("./providers/Provider");

  _Provider = function () {
    return data;
  };

  return data;
}

class MacUpdater extends _AppUpdater().AppUpdater {
  constructor(options, app) {
    super(options, app);
    this.nativeUpdater = require("electron").autoUpdater;
    this.updateInfoForPendingUpdateDownloadedEvent = null;
    this.nativeUpdater.on("error", it => {
      this._logger.warn(it);

      this.emit("error", it);
    });
    this.nativeUpdater.on("update-downloaded", () => {
      const updateInfo = this.updateInfoForPendingUpdateDownloadedEvent;
      this.updateInfoForPendingUpdateDownloadedEvent = null;
      this.dispatchUpdateDownloaded(updateInfo);
    });
  }

  doDownloadUpdate(downloadUpdateOptions) {
    var _this = this;

    this.updateInfoForPendingUpdateDownloadedEvent = null;
    const files = downloadUpdateOptions.updateInfoAndProvider.provider.resolveFiles(downloadUpdateOptions.updateInfoAndProvider.info);
    const zipFileInfo = (0, _Provider().findFile)(files, "zip", ["pkg", "dmg"]);

    if (zipFileInfo == null) {
      throw (0, _builderUtilRuntime().newError)(`ZIP file not provided: ${(0, _builderUtilRuntime().safeStringifyJson)(files)}`, "ERR_UPDATER_ZIP_FILE_NOT_FOUND");
    }

    const server = (0, _http().createServer)();
    server.on("close", () => {
      this._logger.info(`Proxy server for native Squirrel.Mac is closed (was started to download ${zipFileInfo.url.href})`);
    });

    function getServerUrl() {
      const address = server.address();
      return `http://127.0.0.1:${address.port}`;
    }

    return this.executeDownload({
      fileExtension: "zip",
      fileInfo: zipFileInfo,
      downloadUpdateOptions,
      task: (destinationFile, downloadOptions) => {
        return this.httpExecutor.download(zipFileInfo.url, destinationFile, downloadOptions);
      },
      done: function () {
        var _ref = (0, _bluebirdLst().coroutine)(function* (event) {
          const downloadedFile = event.downloadedFile;
          _this.updateInfoForPendingUpdateDownloadedEvent = event;
          let updateFileSize = zipFileInfo.info.size;

          if (updateFileSize == null) {
            updateFileSize = (yield (0, _fsExtraP().stat)(downloadedFile)).size;
          }

          return yield new Promise((resolve, reject) => {
            // insecure random is ok
            const fileUrl = "/" + Date.now() + "-" + Math.floor(Math.random() * 9999) + ".zip";
            server.on("request", (request, response) => {
              const requestUrl = request.url;

              _this._logger.info(`${requestUrl} requested`);

              if (requestUrl === "/") {
                const data = Buffer.from(`{ "url": "${getServerUrl()}${fileUrl}" }`);
                response.writeHead(200, {
                  "Content-Type": "application/json",
                  "Content-Length": data.length
                });
                response.end(data);
                return;
              }

              if (!requestUrl.startsWith(fileUrl)) {
                _this._logger.warn(`${requestUrl} requested, but not supported`);

                response.writeHead(404);
                response.end();
                return;
              }

              _this._logger.info(`${fileUrl} requested by Squirrel.Mac, pipe ${downloadedFile}`);

              let errorOccurred = false;
              response.on("finish", () => {
                try {
                  setImmediate(() => server.close());
                } finally {
                  if (!errorOccurred) {
                    _this.nativeUpdater.removeListener("error", reject);

                    resolve([]);
                  }
                }
              });
              const readStream = (0, _fsExtraP().createReadStream)(downloadedFile);
              readStream.on("error", error => {
                try {
                  response.end();
                } catch (e) {
                  _this._logger.warn(`cannot end response: ${e}`);
                }

                errorOccurred = true;

                _this.nativeUpdater.removeListener("error", reject);

                reject(new Error(`Cannot pipe "${downloadedFile}": ${error}`));
              });
              response.writeHead(200, {
                "Content-Type": "application/zip",
                "Content-Length": updateFileSize
              });
              readStream.pipe(response);
            });
            server.listen(0, "127.0.0.1", () => {
              _this.nativeUpdater.setFeedURL({
                url: getServerUrl(),
                headers: {
                  "Cache-Control": "no-cache"
                }
              });

              _this.nativeUpdater.once("error", reject);

              _this.nativeUpdater.checkForUpdates();
            });
          });
        });

        return function done(_x) {
          return _ref.apply(this, arguments);
        };
      }()
    });
  }

  quitAndInstall() {
    this.nativeUpdater.quitAndInstall();
  }

} exports.MacUpdater = MacUpdater;
// __ts-babel@6.0.4
//# sourceMappingURL=MacUpdater.js.map